/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import oracle.aurora.server.tools.loadjava.DatabaseOptions;
import oracle.aurora.server.tools.loadjava.LoadJava;
import oracle.aurora.server.tools.loadjava.ToolsException;
import oracle.jsp.tools.JspcWebApp;

public class JspcWebAppWrapper {
    JspcWebApp jspcWebApp;
    ZipFile zipFile;
    Vector jspFiles = new Vector();
    ZipEntry jsaFile;
    int errorStatus;
    boolean debug = true;
    Properties props;
    LoadJava lj = new LoadJava();
    PrintWriter out = new PrintWriter(System.out, true);
    private static final String MSG_FILE = "oracle.jsp.tools.LocalStrings";
    private static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.tools.LocalStrings");

    public static void main(String[] stringArray) {
        new JspcWebAppWrapper().run(stringArray);
    }

    public void run(String[] stringArray) {
        if (this.parseArgs(stringArray)) {
            this.jspFiles = this.initializeJspFiles(this.zipFile);
            this.lj.setOutput(this.out);
            DatabaseOptions databaseOptions = new DatabaseOptions();
            try {
                databaseOptions.parseArgs(new String[]{"-kprb"});
            }
            catch (ToolsException toolsException) {
                this.out.println(String.valueOf(msgs.getString("db_conn_error")) + toolsException.getMessage());
            }
            this.lj.setDatabase(databaseOptions);
            if (this.jspFiles.size() > 0 || this.jsaFile != null) {
                this.jspcWebApp = new JspcWebApp(this.out, this.lj);
                this.jspcWebApp.processOptions(this.props, this.zipFile);
                if (this.debug) {
                    this.jspcWebApp.setDebug("true");
                }
                if (this.jsaFile != null) {
                    this.errorStatus = this.jspcWebApp.translateAndLoadOne(this.jsaFile);
                    if (this.errorStatus == 0 && this.debug) {
                        this.out.println("Translated name is " + this.jspcWebApp.getOutFileName());
                    }
                }
                ZipEntry zipEntry = null;
                if (this.debug) {
                    this.out.println("jspFiles.size() is " + this.jspFiles.size());
                }
                int n = 0;
                while (n < this.jspFiles.size()) {
                    zipEntry = (ZipEntry)this.jspFiles.elementAt(n);
                    if (this.debug) {
                        this.out.println(zipEntry.getName());
                    }
                    this.jspcWebApp.setHotload("true");
                    this.errorStatus = this.jspcWebApp.translateAndLoadOne(zipEntry);
                    if (this.errorStatus == 0 && this.debug) {
                        this.out.println("Translated name is " + this.jspcWebApp.getOutFileName());
                    }
                    ++n;
                }
            }
        }
        this.out.flush();
    }

    private boolean initializeJspArgs(String string) {
        try {
            this.props = new Properties();
            this.props.load(new FileInputStream(new File(string)));
        }
        catch (IOException iOException) {
            this.out.println("Exception " + iOException);
            return false;
        }
        return true;
    }

    private Vector initializeJspFiles(ZipFile zipFile) {
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            if (zipEntry.getName().endsWith(".jsa") || zipEntry.getName().endsWith(".JSA")) {
                this.jsaFile = zipEntry;
            }
            if (!zipEntry.getName().endsWith(".jsp") && !zipEntry.getName().endsWith(".JSP") && !zipEntry.getName().endsWith(".sqljsp") && !zipEntry.getName().endsWith(".SQLJSP")) continue;
            this.jspFiles.addElement(zipEntry);
        }
        return this.jspFiles;
    }

    public boolean parseArgs(String[] stringArray) {
        if (stringArray.length < 1 || stringArray.length > 2) {
            return this.useage(stringArray);
        }
        try {
            this.zipFile = new ZipFile(stringArray[0]);
        }
        catch (ZipException zipException) {
            this.out.println("Exception " + zipException);
            return false;
        }
        catch (IOException iOException) {
            this.out.println("Exception " + iOException);
            return false;
        }
        if (stringArray.length == 2) {
            return this.initializeJspArgs(stringArray[1]);
        }
        return true;
    }

    public boolean useage(String[] stringArray) {
        this.out.println("Usage: <war file> [<properties file>]");
        this.out.println("You must supply a war file.");
        this.out.println("A properties file is optional");
        return false;
    }
}

