/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.tools;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import oracle.aurora.mts.http.deployment.JspCompiler;
import oracle.aurora.rdbms.DbmsJava;
import oracle.aurora.rdbms.InvalidResolverPatternException;
import oracle.aurora.rdbms.OracleClassLoader;
import oracle.aurora.rdbms.Resolver;
import oracle.aurora.rdbms.Schema;
import oracle.aurora.rdbms.SchemaNotFoundException;
import oracle.aurora.server.tools.loadjava.LoadJava;
import oracle.aurora.server.tools.loadjava.ToolsException;
import oracle.jsp.parse.Jsp2JavaParms;
import oracle.jsp.parse.JspEncodingException;
import oracle.jsp.parse.JspParseException;
import oracle.jsp.parse.OracleJsp2Java;
import oracle.jsp.tools.JspZipFileResourceProvider;
import oracle.jsp.util.JspUtil;
import sun.io.CharacterEncoding;

public class JspcWebApp
implements JspCompiler {
    public static final String SQLJ_EXTENSION = "sqlj";
    public static final String RES_EXTENSION = "res";
    public static final String SQLJSP_EXTENSION = "sqljsp";
    public static final String JAVA_EXTENSION = "java";
    private static final String GLOBALS_EXT = "jsa";
    private static final char FILE_SEP = File.separatorChar;
    public static final int SUCCESS = 0;
    public static final int JSP_ERROR = -1;
    public static final int JAVAC_ERROR = -3;
    public static final int ARG_ERROR = -4;
    public static final int FILE_ERROR = -5;
    public static final int DB_ERROR = -6;
    private Properties m_options;
    private boolean verbose = false;
    private boolean debug = false;
    private String givenEncoding = "ISO-8859-1";
    private String givenPackageName;
    private String packageName = "";
    private String className;
    private ClassLoader classLoader;
    private String pagePath;
    private String user;
    private String resolverSpec;
    private String srcFile;
    private String outFile;
    private String resFile;
    private PrintWriter out;
    private InputStreamReader instr;
    private OutputStreamWriter outstr;
    private ByteArrayOutputStream ostr;
    private ByteArrayOutputStream rstr;
    private Jsp2JavaParms parms = new Jsp2JavaParms();
    private OracleJsp2Java pageTranslator;
    private int errorStatus = 0;
    private ZipFile warFile;
    private ZipEntry zipEntry;
    private LoadJava lj;
    private static final String MSG_FILE = "oracle.jsp.tools.LocalStrings";
    private static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.tools.LocalStrings");
    private static final String MSG1_FILE = "oracle.jsp.app.LocalStrings";
    private static ResourceBundle msgs1 = ResourceBundle.getBundle("oracle.jsp.app.LocalStrings");

    public JspcWebApp(PrintWriter printWriter, LoadJava loadJava) {
        this.out = printWriter;
        this.lj = loadJava;
    }

    public int translateAndLoadOne(ZipEntry zipEntry) {
        this.errorStatus = 0;
        this.zipEntry = zipEntry;
        this.srcFile = zipEntry.getName();
        if (this.user == null) {
            this.user = Schema.currentSchema().toString();
        }
        if (this.debug || this.verbose) {
            this.out.println(MessageFormat.format(msgs.getString("start_translation"), this.srcFile));
        }
        if (this.prepareAndTranslate() != 0 && (this.debug || this.verbose)) {
            this.out.println(MessageFormat.format(msgs.getString("error_translating"), this.srcFile, new Integer(this.errorStatus)));
        }
        if (this.debug || this.verbose) {
            this.out.println(MessageFormat.format(msgs.getString("done_translating"), this.srcFile));
        }
        this.out.flush();
        this.resetFileLevelDefaults();
        return this.errorStatus;
    }

    public void processOptions(Hashtable hashtable, ZipFile zipFile) {
        if (hashtable != null) {
            this.user = (String)hashtable.get("schema");
            this.user.trim();
            this.verbose = hashtable.get("verbose") == null ? false : ((String)hashtable.get("verbose")).equalsIgnoreCase("true");
            this.resolverSpec = (String)hashtable.get("resolver");
            boolean bl = hashtable.get("hotload") == null ? false : (this.parms.hotload = ((String)hashtable.get("hotload")).equalsIgnoreCase("true"));
            this.parms.validate = hashtable.get("validate") == null ? true : ((String)hashtable.get("validate")).equalsIgnoreCase("true");
        }
        this.processOptions(zipFile);
    }

    public void processOptions(ZipFile zipFile) {
        this.warFile = zipFile;
        this.setupCommonParms();
    }

    private boolean isJspClassExist() {
        try {
            this.getJspClass();
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    private Class getJspClass() throws ClassNotFoundException {
        String string = null;
        string = this.packageName == null || this.packageName.length() == 0 ? this.className : String.valueOf(this.packageName) + "." + this.className;
        return DbmsJava.classForNameAndSchema((String)string, (String)this.user);
    }

    private void callHotLoadMainMethod() {
        if (!this.parms.hotload) {
            return;
        }
        try {
            Class clazz = this.getJspClass();
            Object var2_3 = null;
            if (clazz == null) {
                return;
            }
            var2_3 = clazz.newInstance();
            if (var2_3 == null) {
                return;
            }
            Method method = clazz.getMethod("__jsp_hotload_class", null);
            if (method == null) {
                return;
            }
            method.invoke(var2_3, null);
            if (this.verbose) {
                this.out.println(String.valueOf(clazz.getName()) + msgs.getString("hotloaded"));
                return;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private int prepareAndTranslate() {
        this.setupFileParms();
        this.outFile = this.packageName == null || this.packageName.length() == 0 ? this.className : String.valueOf(this.packageName) + "." + this.className;
        this.outFile = String.valueOf(this.outFile.replace('.', FILE_SEP)) + ".class";
        this.outFile = this.srcFile.endsWith(SQLJSP_EXTENSION) ? JspUtil.replaceTargetExtension(this.outFile, SQLJ_EXTENSION) : JspUtil.replaceTargetExtension(this.outFile, JAVA_EXTENSION);
        this.resFile = JspUtil.replaceTargetExtension(this.outFile, RES_EXTENSION);
        if (this.errorStatus != 0) {
            return this.errorStatus;
        }
        this.jspTranslate(1, this.givenEncoding);
        if (this.isJspClassExist()) {
            this.errorStatus = 0;
        }
        if (this.debug && this.errorStatus != 0) {
            this.out.println("errorStatus is " + this.errorStatus);
        }
        if (this.errorStatus == 0) {
            this.callHotLoadMainMethod();
        }
        if (this.verbose) {
            this.out.println();
        }
        return this.errorStatus;
    }

    private void setupFileParms() {
        this.parms.sourceFileName = this.srcFile;
        this.packageName = this.givenPackageName == null ? JspUtil.getPackageNameFromRelPath(this.srcFile, FILE_SEP) : this.givenPackageName;
        this.className = JspUtil.getClassNameFromRelPath(this.srcFile, FILE_SEP);
        this.parms.packageName = this.packageName;
        this.parms.className = this.className;
        String string = this.srcFile;
        if (!(string = JspUtil.stripTarget(string, '/')).equals("/")) {
            this.parms.pagePath = string;
        }
    }

    private void setupCommonParms() {
        this.parms.globalInfo = null;
        this.parms.debugOut = this.debug ? this.out : null;
        this.pageTranslator = new OracleJsp2Java();
        if (this.user == null) {
            this.user = Schema.currentSchema().toString();
        }
        if (this.resolverSpec == null) {
            this.resolverSpec = "((* " + this.user + ") (* PUBLIC))";
        } else {
            String string = this.resolverSpec.trim();
            string = string.substring(1, string.length() - 1);
            this.resolverSpec = "((* " + this.user + ") " + string + ")";
        }
        try {
            this.parms.classLoader = OracleClassLoader.get((Resolver)new Resolver(this.resolverSpec), (Schema)Schema.lookup((String)this.user), (boolean)false, (boolean)false, null);
            if (this.parms.classLoader == null) {
                this.out.println(String.valueOf(msgs.getString("no_classloader")) + this.user);
                this.errorStatus = -6;
                return;
            }
        }
        catch (InvalidResolverPatternException invalidResolverPatternException) {
            this.out.println(String.valueOf(msgs.getString("invalid_resolver")) + invalidResolverPatternException.getMessage());
            this.errorStatus = -6;
            return;
        }
        catch (SchemaNotFoundException schemaNotFoundException) {
            this.out.println(String.valueOf(msgs.getString("invalid_schema")) + schemaNotFoundException.getMessage());
            this.errorStatus = -6;
            return;
        }
        this.parms.resourceProvider = new JspZipFileResourceProvider(this.warFile);
        this.lj.setResolve(true);
        this.lj.setResolver(this.resolverSpec);
        this.lj.setSchema(this.user);
        this.lj.setVerbose(this.verbose);
        this.lj.setForceLoading(true);
        this.lj.setEncoding(CharacterEncoding.aliasName((String)this.givenEncoding));
    }

    private void setupZipFileProvider() {
        this.parms.resourceProvider = new JspZipFileResourceProvider(this.warFile);
    }

    private void jspTranslate(int n, String string) {
        try {
            if (this.verbose) {
                this.out.println(MessageFormat.format(msgs.getString("file_msg"), this.srcFile));
            }
            this.parms.encoding = string;
            this.setupInOutZip(CharacterEncoding.aliasName((String)string));
            if (this.errorStatus != 0) {
                return;
            }
            int n2 = this.srcFile.endsWith(GLOBALS_EXT) ? 1 : 0;
            if (this.pageTranslator.transform(this.parms, this.instr, this.outstr, this.rstr, n2) == 1 && !this.srcFile.endsWith(SQLJSP_EXTENSION)) {
                this.outFile = JspUtil.replaceTargetExtension(this.outFile, SQLJ_EXTENSION);
            }
            this.srcFile = this.outFile;
            this.loadTranslated(this.outFile, CharacterEncoding.aliasName((String)string), this.ostr.toByteArray());
            if (this.parms.hotload && this.rstr != null) {
                this.loadTranslated(this.resFile, null, this.rstr.toByteArray());
                return;
            }
        }
        catch (JspEncodingException jspEncodingException) {
            this.lj.setEncoding(jspEncodingException.getSpecifiedEncoding());
            if (this.debug) {
                this.out.println("Trying " + jspEncodingException.getSpecifiedEncoding());
            }
            if (n == 1) {
                this.jspTranslate(n + 1, jspEncodingException.getSpecifiedEncoding());
                return;
            }
            this.out.println(MessageFormat.format(msgs.getString("parse_error"), this.srcFile));
            this.out.println(MessageFormat.format(msgs.getString("multiple_encoding"), this.srcFile));
            this.errorStatus = -1;
            return;
        }
        catch (JspParseException jspParseException) {
            this.out.println(MessageFormat.format(msgs.getString("parse_error"), this.srcFile));
            this.out.println(jspParseException);
            this.errorStatus = -1;
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.out.println(MessageFormat.format(msgs.getString("no_file"), fileNotFoundException.getMessage()));
            this.errorStatus = -5;
            return;
        }
        catch (IOException iOException) {
            this.out.println(MessageFormat.format(msgs.getString("file_io_err"), this.srcFile));
            this.out.println(iOException.getMessage());
            this.errorStatus = -5;
        }
    }

    private void loadTranslated(String string, String string2, byte[] byArray) {
        if (this.verbose) {
            this.out.println(String.valueOf(msgs.getString("calling_loadjava_file")) + string);
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        this.lj.add((InputStream)byteArrayInputStream, string);
        try {
            if (this.verbose) {
                this.out.println();
                this.out.println(msgs.getString("calling_loadjava"));
            }
            this.lj.processFinish();
            return;
        }
        catch (ToolsException toolsException) {
            this.errorStatus = -3;
            this.out.println(String.valueOf(msgs.getString("loadjava_exception")) + toolsException.getMessage());
            return;
        }
    }

    private void setupInOutZip(String string) {
        try {
            InputStream inputStream = this.warFile.getInputStream(this.zipEntry);
            if (inputStream == null) {
                this.out.println(String.valueOf(msgs.getString("cannot_find_jsp_a")) + this.srcFile);
                this.errorStatus = -5;
                return;
            }
            this.ostr = new ByteArrayOutputStream();
            this.rstr = this.parms.hotload ? new ByteArrayOutputStream() : null;
            if (string != null) {
                this.instr = new InputStreamReader(inputStream, string);
                this.outstr = new OutputStreamWriter((OutputStream)this.ostr, string);
                return;
            }
            this.instr = new InputStreamReader(inputStream);
            this.outstr = new OutputStreamWriter(this.ostr);
            return;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.out.println(MessageFormat.format(msgs1.getString("bad_encoding"), "sources", string));
            this.errorStatus = -5;
            return;
        }
        catch (IOException iOException) {
            this.out.println(MessageFormat.format(msgs.getString("file_io_err"), this.srcFile));
            this.out.println(iOException.getMessage());
            this.errorStatus = -5;
            return;
        }
    }

    private void resetFileLevelDefaults() {
        this.givenEncoding = "ISO-8859-1";
        this.lj.setEncoding(this.givenEncoding);
        this.parms.encoding = this.givenEncoding;
        this.parms.hotload = false;
    }

    public String getOutFileName() {
        return this.outFile;
    }

    public void setSchema(String string) {
        this.user = string;
        if (this.user != null) {
            this.user = this.user.toUpperCase();
        }
    }

    public String getSchema() {
        return this.user;
    }

    public void setVerbose(String string) {
        if (string.equalsIgnoreCase("true")) {
            this.verbose = true;
        }
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public void setHotload(String string) {
        this.parms.hotload = string.equalsIgnoreCase("true");
    }

    public boolean getHotload() {
        return this.parms.hotload;
    }

    public void setValidate(String string) {
        this.parms.validate = string.equalsIgnoreCase("true");
    }

    public boolean getValidate() {
        return this.parms.validate;
    }

    public void setResolver(String string) {
        this.resolverSpec = string;
    }

    public String getResolver() {
        return this.resolverSpec;
    }

    public void setDebug(String string) {
        boolean bl = this.debug = string.equalsIgnoreCase("true");
        if (this.debug) {
            this.parms.debugOut = this.out;
        }
    }

    public boolean getDebug() {
        return this.debug;
    }
}

