/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.tools;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.Properties;
import java.util.ResourceBundle;
import oracle.jsp.parse.Jsp2JavaParms;
import oracle.jsp.parse.JspEncodingException;
import oracle.jsp.parse.JspParseException;
import oracle.jsp.parse.OracleJsp2Java;
import oracle.jsp.tools.JspcFilesystemResource;
import oracle.jsp.util.JspUtil;
import sqlj.tools.Sqlj;
import sun.io.CharacterEncoding;
import sun.tools.javac.Main;

public class Jspc {
    public static final String SQLJ_TRANSLATOR = "sqlj_translator";
    public static final String SQLJ_EXTENSION = "sqlj";
    public static final String SQLJSP_EXTENSION = "sqljsp";
    public static final String JAVA_EXTENSION = "java";
    public static final String RES_EXTENSION = "res";
    private static final String GLOBALS_JSA = "globals.jsa";
    private static final String DEFAULT_SQLJ_TRANSLATOR = "sqlj.framework.ide.Translator";
    public static final int SUCCESS = 0;
    public static final int JSP_ERROR = -1;
    public static final int SQLJ_ERROR = -2;
    public static final int JAVAC_ERROR = -3;
    public static final int ARG_ERROR = -4;
    public static final int FILE_ERROR = -5;
    private Properties m_options;
    private boolean verbose = false;
    private String encoding = "ISO-8859-1";
    private String[] pagesJdkEncoding;
    private String extend;
    private String implement;
    private String imports;
    private String packageName = "";
    private String className;
    private ClassLoader classLoader;
    private String addclasspath;
    private boolean genLineInfo = false;
    private boolean hotload = false;
    private boolean extres = false;
    private boolean noCompile = false;
    private String[] sqljArgList = new String[0];
    private String outBinPath = ".";
    private String outSrcPath = ".";
    private String appRoot = ".";
    private String classpath;
    private JspcFilesystemResource incResource;
    private JspcFilesystemResource outBinResource;
    private JspcFilesystemResource outSrcResource;
    private Jsp2JavaParms parms;
    private OracleJsp2Java pageTranslator;
    private String[] jspFileList;
    private int numFiles;
    private boolean helpDone = false;
    private int globalFile = -1;
    private boolean callSqlj = false;
    private int errorStatus = 0;
    private static final String MSG_FILE = "oracle.jsp.tools.LocalStrings";
    private static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.tools.LocalStrings");
    private static final String MSG1_FILE = "oracle.jsp.app.LocalStrings";
    private static ResourceBundle msgs1 = ResourceBundle.getBundle("oracle.jsp.app.LocalStrings");

    public static void main(String[] stringArray) {
        Jspc jspc = new Jspc();
        System.exit(jspc.translate(stringArray));
    }

    public int translate(String[] stringArray) {
        int n;
        this.processArgs(stringArray);
        if (this.errorStatus != 0) {
            return this.errorStatus;
        }
        if (this.jspFileList == null) {
            if (!this.helpDone) {
                this.printLongHelp();
            }
            return 0;
        }
        this.initAppRootResource();
        if (this.errorStatus != 0) {
            return this.errorStatus;
        }
        this.setupParms();
        if (this.errorStatus != 0) {
            return this.errorStatus;
        }
        if (this.globalFile != -1) {
            n = this.globalFile;
            this.jspTranslate(n, 1, null);
        }
        n = 0;
        while (n < this.jspFileList.length) {
            if (n != this.globalFile) {
                this.jspTranslate(n, 1, null);
            }
            ++n;
        }
        if (this.errorStatus != 0) {
            return this.errorStatus;
        }
        if (this.verbose) {
            System.out.println(MessageFormat.format(msgs.getString("jsp_translate"), new Integer(this.numFiles)));
        }
        this.classpath = this.addclasspath != null ? String.valueOf(System.getProperty("java.class.path")) + File.pathSeparator + this.addclasspath : System.getProperty("java.class.path");
        if (this.callSqlj) {
            if (!this.isConsistentPagesJdkEncoding()) {
                System.err.println(msgs.getString("not_consistent_encoding"));
                return -2;
            }
            this.sqljTranslate();
            return this.errorStatus;
        }
        if (this.noCompile) {
            return 0;
        }
        if (!this.isConsistentPagesJdkEncoding()) {
            System.err.println(msgs.getString("not_consistent_encoding"));
            return -3;
        }
        this.javaCompile();
        return this.errorStatus;
    }

    private boolean isConsistentPagesJdkEncoding() {
        String string = this.pagesJdkEncoding[0];
        int n = 1;
        while (n < this.pagesJdkEncoding.length) {
            if (string == null ? this.pagesJdkEncoding[n] != null : !string.equals(this.pagesJdkEncoding[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private void processArgs(String[] stringArray) {
        if (stringArray.length == 0) {
            this.printShortHelp();
            return;
        }
        int n = 0;
        while (n < stringArray.length) {
            n = this.processOptions(stringArray, n);
            if (this.errorStatus != 0) {
                return;
            }
            ++n;
        }
        if (this.jspFileList != null) {
            this.pagesJdkEncoding = new String[this.jspFileList.length];
        }
    }

    private int processOptions(String[] stringArray, int n) {
        int n2 = n;
        try {
            if (stringArray[n2].equalsIgnoreCase("-addclasspath")) {
                this.addclasspath = stringArray[++n2];
            } else if (stringArray[n2].equalsIgnoreCase("-dir") || stringArray[n2].equalsIgnoreCase("-d")) {
                this.outBinPath = stringArray[++n2];
            } else if (stringArray[n2].equalsIgnoreCase("-srcdir")) {
                this.outSrcPath = stringArray[++n2];
            } else if (stringArray[n2].equalsIgnoreCase("-debug")) {
                this.genLineInfo = true;
            } else if (stringArray[n2].equalsIgnoreCase("-hotload")) {
                this.hotload = true;
            } else if (stringArray[n2].equalsIgnoreCase("-extres")) {
                this.extres = true;
            } else if (stringArray[n2].equalsIgnoreCase("-encoding")) {
                this.encoding = stringArray[++n2];
                String string = CharacterEncoding.aliasName((String)this.encoding);
                if (string == null) {
                    System.err.println(MessageFormat.format(msgs1.getString("bad_encoding"), "sources", this.encoding));
                    this.errorStatus = -4;
                }
            } else if (stringArray[n2].equalsIgnoreCase("-extend")) {
                this.extend = stringArray[++n2];
            } else if (stringArray[n2].equalsIgnoreCase("-help") || stringArray[n2].equalsIgnoreCase("-h")) {
                this.printLongHelp();
            } else if (stringArray[n2].equalsIgnoreCase("-implement")) {
                this.implement = stringArray[++n2];
            } else if (stringArray[n2].equalsIgnoreCase("-appRoot")) {
                this.appRoot = stringArray[++n2];
                this.checkAppRoot(this.appRoot);
            } else if (stringArray[n2].equalsIgnoreCase("-noCompile")) {
                this.noCompile = true;
            } else if (stringArray[n2].equalsIgnoreCase("-packageName")) {
                this.packageName = stringArray[++n2];
            } else if (stringArray[n2].startsWith("-S")) {
                if (stringArray[n2 + 1].startsWith("-")) {
                    this.setSqljArg(stringArray[n2], null);
                } else {
                    this.setSqljArg(stringArray[n2], stringArray[++n2]);
                }
            } else if (stringArray[n2].equalsIgnoreCase("-verbose")) {
                this.verbose = true;
            } else if (stringArray[n2].equalsIgnoreCase("-version")) {
                System.out.println("Oracle JSP Translator Release 1.1.2.0");
            } else if (this.isSource(stringArray[n2])) {
                n2 = this.readFileList(stringArray, n2);
            } else {
                System.err.println(MessageFormat.format(msgs.getString("bad_option"), stringArray[n2]));
                if (!this.helpDone) {
                    this.printLongHelp();
                }
                this.errorStatus = -4;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.err.println(msgs.getString("bad_opt_list"));
            this.errorStatus = -4;
        }
        catch (Exception exception) {
            System.err.println(String.valueOf(msgs.getString("option_error")) + exception);
            this.errorStatus = -4;
        }
        return n2;
    }

    private void printShortHelp() {
        System.out.println(String.valueOf(msgs.getString("usage")) + "ojspc <options> <file list> ");
        System.out.println(msgs.getString("help"));
    }

    private void printLongHelp() {
        this.helpDone = true;
        System.out.println("Usage: ojspc <options> <file list> ");
        System.out.println(msgs.getString("options"));
        System.out.println("  -addclasspath <classpath>    " + msgs.getString("classpath"));
        System.out.println("  -d <directory>               " + msgs.getString("directory"));
        System.out.println("  -srcdir <directory>          " + msgs.getString("src_directory"));
        System.out.println("  -debug                       " + msgs.getString("debug"));
        System.out.println("  -hotload                     " + msgs.getString("hotload"));
        System.out.println("  -extres                      " + msgs.getString("extres"));
        System.out.println("  -extend <class name>         " + msgs.getString("extend"));
        System.out.println("  -implement <class name>      " + msgs.getString("implement"));
        System.out.println("  -appRoot <path>              " + msgs.getString("approot"));
        System.out.println("  -noCompile                   " + msgs.getString("nocompile"));
        System.out.println("  -packageName <package name>  " + msgs.getString("package"));
        System.out.println("  -S-<option> <value>          " + msgs.getString("sqlj_option"));
        System.out.println("  -verbose                     " + msgs.getString("verbose"));
        System.out.println("  -version                     " + msgs.getString("version"));
    }

    private void printVersion() {
        System.out.println("Oracle JSP Translator Release 1.1.2.0");
    }

    private void setSqljArg(String string, String string2) {
        String string3 = string.substring(2, string.length());
        String[] stringArray = new String[this.sqljArgList.length + 1];
        int n = 0;
        while (n < this.sqljArgList.length) {
            stringArray[n] = this.sqljArgList[n];
            ++n;
        }
        stringArray[n] = string2 != null ? String.valueOf(string3) + "=" + string2 : string3;
        this.sqljArgList = stringArray;
    }

    private void checkAppRoot(String string) {
        File file = new File(string);
        if (!file.exists()) {
            System.err.println(MessageFormat.format(msgs.getString("bad_approot_notexist"), string));
            this.errorStatus = -5;
            return;
        }
        if (file.isFile()) {
            System.err.println(MessageFormat.format(msgs.getString("bad_approot_notdir"), file));
            this.errorStatus = -5;
            return;
        }
        this.appRoot = string;
    }

    private boolean isSource(String string) {
        return string.endsWith(".sqlj") || string.endsWith(".java") || string.endsWith(".jsp") || string.endsWith(".JSP") || string.endsWith(".sqljsp") || string.endsWith(".SQLJSP") || string.endsWith(".jsa") || string.endsWith(".jsa");
    }

    private int readFileList(String[] stringArray, int n) {
        int n2 = stringArray.length - n;
        this.jspFileList = new String[n2];
        int n3 = 0;
        while (n3 < n2) {
            this.jspFileList[n3] = stringArray[n++];
            this.checkFile(this.jspFileList[n3]);
            if (this.errorStatus != 0) {
                return this.errorStatus;
            }
            if (this.jspFileList[n3].endsWith(".jsa")) {
                if (this.globalFile != -1) {
                    System.err.println(msgs.getString("many_globals"));
                    this.errorStatus = -4;
                    return this.errorStatus;
                }
                this.globalFile = n3;
            }
            ++n3;
        }
        return stringArray.length;
    }

    private void checkFile(String string) {
        File file = new File(string);
        if (!(file.exists() && file.isFile() && file.canRead())) {
            System.err.println(MessageFormat.format(msgs.getString("bad_file"), string));
            if (!this.helpDone) {
                this.printLongHelp();
            }
            this.errorStatus = -5;
        }
        if (this.appRoot.equals(".") && this.isAbsolutePath(string)) {
            System.err.println(msgs.getString("app_root_undefined"));
            this.errorStatus = -5;
        }
    }

    private boolean isAbsolutePath(String string) {
        if (string == null) {
            return false;
        }
        if (string.length() == 0) {
            return false;
        }
        if (string.charAt(0) == File.separatorChar) {
            return true;
        }
        return File.separatorChar == '\\' && string.length() > 2 && string.charAt(1) == ':';
    }

    private void initAppRootResource() {
        this.incResource = new JspcFilesystemResource(this.verbose);
        this.outBinResource = new JspcFilesystemResource(this.verbose);
        this.outSrcResource = new JspcFilesystemResource(this.verbose);
        try {
            this.incResource.init(this.appRoot, "/", "/", null, null, null);
            this.outBinResource.init(this.outBinPath, "/", "/", null, null, null);
            this.outSrcResource.init(this.outSrcPath, "/", "/", null, null, null);
            return;
        }
        catch (IllegalStateException illegalStateException) {
            System.err.println(String.valueOf(msgs.getString("error")) + illegalStateException);
            this.errorStatus = -5;
            return;
        }
    }

    private void setupParms() {
        this.parms = new Jsp2JavaParms();
        this.parms.extend = this.extend;
        this.parms.implement = this.implement;
        this.parms.imports = null;
        this.parms.classLoader = null;
        this.parms.resourceProvider = this.incResource;
        this.parms.globalInfo = null;
        this.parms.debugOut = null;
        this.parms.genLineInfo = this.genLineInfo;
        this.parms.hotload = this.hotload;
        this.pageTranslator = new OracleJsp2Java();
    }

    private void jspTranslate(int n) {
        this.jspTranslate(n, 1, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void jspTranslate(int n, int n2, String string) {
        OutputStream outputStream;
        OutputStreamWriter outputStreamWriter;
        InputStreamReader inputStreamReader;
        block35: {
            block34: {
                String string2 = this.jspFileList[n];
                String string3 = null;
                inputStreamReader = null;
                outputStreamWriter = null;
                outputStream = null;
                try {
                    try {
                        String string4;
                        if (this.verbose) {
                            System.err.println(MessageFormat.format(msgs.getString("file_msg"), string2));
                        }
                        string2 = JspUtil.filePathAfterAppPath(string2, this.appRoot);
                        String string5 = this.packageName;
                        if (string5.length() == 0) {
                            string5 = JspUtil.getPackageNameFromRelPath(string2, File.separatorChar);
                        }
                        if ((string4 = this.className) == null) {
                            string4 = JspUtil.getClassNameFromRelPath(string2, File.separatorChar);
                        }
                        if (string == null) {
                            string = this.encoding;
                        }
                        if (string != null) {
                            this.pagesJdkEncoding[n] = CharacterEncoding.aliasName((String)string);
                            if (this.pagesJdkEncoding[n] == null) {
                                System.err.println(MessageFormat.format(msgs1.getString("bad_encoding"), "sources", string));
                                Object var10_15 = null;
                                break block34;
                            }
                        }
                        string3 = String.valueOf(string5.replace('.', File.separatorChar)) + File.separatorChar + string4 + ".class";
                        if (string2.endsWith(SQLJSP_EXTENSION)) {
                            string3 = JspUtil.replaceTargetExtension(string3, SQLJ_EXTENSION);
                            this.callSqlj = true;
                        } else {
                            string3 = JspUtil.replaceTargetExtension(string3, JAVA_EXTENSION);
                        }
                        try {
                            if (this.pagesJdkEncoding[n] != null) {
                                inputStreamReader = this.incResource.fromReader(string2, this.pagesJdkEncoding[n]);
                                outputStreamWriter = this.outSrcResource.toWriter(string3, this.pagesJdkEncoding[n]);
                            } else {
                                inputStreamReader = this.incResource.fromReader(string2);
                                outputStreamWriter = this.outSrcResource.toWriter(string3);
                            }
                            if (this.hotload || this.extres) {
                                String string6 = JspUtil.replaceTargetExtension(string3, RES_EXTENSION);
                                outputStream = this.outBinResource.toStream(string6);
                            }
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            System.err.println(MessageFormat.format(msgs1.getString("bad_encoding"), "sources", this.pagesJdkEncoding[n]));
                            this.errorStatus = -5;
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            System.err.println(MessageFormat.format(msgs.getString("no_file"), string2));
                            this.errorStatus = -5;
                        }
                        catch (IOException iOException) {
                            System.err.println(MessageFormat.format(msgs.getString("file_io_err"), string2));
                            System.err.println(iOException.getMessage());
                            this.errorStatus = -5;
                        }
                        this.parms.sourceFileName = string2;
                        this.parms.packageName = string5;
                        this.parms.className = string4;
                        this.parms.encoding = string;
                        this.parms.pagePath = String.valueOf(JspUtil.stripTarget(string2, '/')) + "/";
                        int n3 = string2.endsWith(GLOBALS_JSA) ? 1 : 0;
                        if (this.pageTranslator.transform(this.parms, inputStreamReader, outputStreamWriter, outputStream, n3) == 1 && !string2.endsWith(SQLJSP_EXTENSION)) {
                            this.callSqlj = true;
                            String string7 = JspUtil.replaceTargetExtension(string2, SQLJ_EXTENSION);
                            this.incResource.rename(string3, string7);
                            string3 = string7;
                        }
                        this.jspFileList[n] = this.outSrcResource.translateToAbsolutePath(string3);
                        ++this.numFiles;
                    }
                    catch (JspEncodingException jspEncodingException) {
                        if (n2 == 1) {
                            this.jspTranslate(n, n2 + 1, jspEncodingException.getSpecifiedEncoding());
                            break block35;
                        }
                        System.err.println(MessageFormat.format(msgs.getString("parse_error"), string2));
                        System.err.println(MessageFormat.format(msgs.getString("multiple_encoding"), string2));
                        this.errorStatus = -1;
                        this.jspFileList[n] = string2;
                    }
                    catch (JspParseException jspParseException) {
                        System.err.println(MessageFormat.format(msgs.getString("parse_error"), string2));
                        System.err.println(jspParseException);
                        this.errorStatus = -1;
                        this.jspFileList[n] = string2;
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        System.err.println(MessageFormat.format(msgs.getString("no_file"), fileNotFoundException.getMessage()));
                        this.errorStatus = -5;
                        this.jspFileList[n] = string2;
                    }
                    catch (IOException iOException) {
                        System.err.println(MessageFormat.format(msgs.getString("file_io_err"), string2));
                        System.err.println(iOException.getMessage());
                        this.errorStatus = -5;
                        this.jspFileList[n] = string2;
                    }
                    break block35;
                }
                catch (Throwable throwable) {
                    Object var10_17 = null;
                    try {
                        if (inputStreamReader != null) {
                            inputStreamReader.close();
                        }
                        if (outputStreamWriter != null) {
                            outputStreamWriter.close();
                        }
                        if (outputStream == null) throw throwable;
                        outputStream.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        throw throwable;
                    }
                }
            }
            try {}
            catch (IOException iOException) {}
            if (inputStreamReader != null) {
                inputStreamReader.close();
            }
            if (outputStreamWriter != null) {
                outputStreamWriter.close();
            }
            if (outputStream == null) return;
            outputStream.close();
            return;
        }
        Object var10_16 = null;
        try {}
        catch (IOException iOException) {}
        if (inputStreamReader != null) {
            inputStreamReader.close();
        }
        if (outputStreamWriter != null) {
            outputStreamWriter.close();
        }
        if (outputStream == null) return;
        outputStream.close();
        return;
    }

    private void sqljTranslate() {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(DEFAULT_SQLJ_TRANSLATOR);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println(String.valueOf(msgs.getString("no_sqlj")) + classNotFoundException);
            this.errorStatus = -2;
            return;
        }
        String string = this.pagesJdkEncoding[0];
        String[] stringArray = string != null ? new String[this.sqljArgList.length + this.numFiles + 4] : new String[this.sqljArgList.length + this.numFiles + 3];
        int n = 0;
        while (n < this.sqljArgList.length) {
            stringArray[n] = this.sqljArgList[n];
            ++n;
        }
        stringArray[n++] = "-C-classpath=" + this.classpath;
        stringArray[n++] = "-d=" + this.outBinPath;
        stringArray[n++] = !this.noCompile ? "-compile=true" : "-compile=false";
        if (string != null) {
            stringArray[n++] = "-encoding=" + string;
        }
        String string2 = null;
        int n2 = n;
        int n3 = 0;
        while (n3 < this.jspFileList.length) {
            string2 = this.jspFileList[n3];
            if (string2.endsWith(SQLJ_EXTENSION)) {
                stringArray[n2++] = string2;
                this.jspFileList[n3] = JspUtil.replaceTargetExtension(this.jspFileList[n3], JAVA_EXTENSION);
            } else if (string2.endsWith(JAVA_EXTENSION)) {
                stringArray[n2++] = string2;
                this.jspFileList[n3] = this.jspFileList[n3];
            }
            if (this.verbose) {
                System.out.println(MessageFormat.format(msgs.getString("sqlj_msg"), stringArray[n2 - 1]));
            }
            ++n3;
        }
        if (Sqlj.statusMain((String[])stringArray) != 0) {
            this.errorStatus = -2;
        }
    }

    private void javaCompile() {
        int n;
        String[] stringArray;
        PrintStream printStream = System.err;
        Main main = new Main((OutputStream)printStream, "javac");
        String string = this.pagesJdkEncoding[0];
        if (string != null) {
            stringArray = new String[this.numFiles + 6];
            n = 6;
        } else {
            stringArray = new String[this.numFiles + 4];
            n = 4;
        }
        stringArray[0] = "-classpath";
        stringArray[1] = this.classpath;
        stringArray[2] = "-d";
        stringArray[3] = this.outBinPath;
        if (string != null) {
            stringArray[4] = "-encoding";
            stringArray[5] = string;
        }
        int n2 = n - 1;
        int n3 = 0;
        while (n3 < this.jspFileList.length) {
            if (this.jspFileList[n3].endsWith(JAVA_EXTENSION)) {
                stringArray[++n2] = this.jspFileList[n3];
                if (this.verbose) {
                    System.out.println(MessageFormat.format(msgs.getString("javac_msg"), stringArray[n2]));
                }
            }
            ++n3;
        }
        if (n2 > n - 1) {
            main.compile(stringArray);
            String string2 = printStream.toString();
            if (string2.indexOf("error") != -1) {
                this.errorStatus = -3;
            }
        }
    }
}

