/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.tools;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import oracle.jsp.provider.JspResourceProvider;
import oracle.jsp.util.JspUtil;

public class JspZipFileResourceProvider
implements JspResourceProvider {
    private ZipFile zipFile;
    private Hashtable manifest = new Hashtable();
    private static final String MSG_FILE = "oracle.jsp.tools.LocalStrings";
    private static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.tools.LocalStrings");

    JspZipFileResourceProvider(ZipFile zipFile) {
        this.zipFile = zipFile;
        Enumeration<? extends ZipEntry> enumeration = this.zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            this.manifest.put(zipEntry.getName(), zipEntry);
        }
    }

    public void init(String string, String string2, String string3, ServletContext servletContext, HttpServletRequest httpServletRequest, Hashtable hashtable) throws IllegalStateException {
    }

    public void init(JspResourceProvider jspResourceProvider, String string) throws IllegalStateException {
    }

    public String getRepositoryRoot() {
        return null;
    }

    public String getContextRoot() {
        return null;
    }

    public String getAppRoot() {
        return null;
    }

    private ZipEntry locateEntryByName(String string) {
        return (ZipEntry)this.manifest.get(JspUtil.handleDotsInPath(string.startsWith(File.separator) ? string.substring(1, string.length()) : string, File.separatorChar));
    }

    public InputStream fromStream(String string) throws FileNotFoundException, IOException {
        if (string == null) {
            throw new IOException(msgs.getString("null_resource"));
        }
        ZipEntry zipEntry = this.locateEntryByName(string);
        InputStream inputStream = null;
        if (zipEntry != null) {
            inputStream = this.zipFile.getInputStream(zipEntry);
        }
        if (inputStream == null) {
            throw new FileNotFoundException(MessageFormat.format(msgs.getString("resource_not_found"), string));
        }
        return inputStream;
    }

    public InputStreamReader fromReader(String string) throws FileNotFoundException, IOException {
        InputStream inputStream = this.fromStream(string);
        if (inputStream != null) {
            return new InputStreamReader(inputStream);
        }
        return null;
    }

    public InputStreamReader fromReader(String string, String string2) throws FileNotFoundException, IOException, UnsupportedEncodingException {
        InputStream inputStream = this.fromStream(string);
        if (inputStream != null) {
            return new InputStreamReader(inputStream, string2);
        }
        return null;
    }

    public OutputStream toStream(String string) throws FileNotFoundException, IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        return byteArrayOutputStream;
    }

    public PrintWriter toPrintWriter(String string) throws FileNotFoundException, IOException {
        return null;
    }

    public PrintWriter toPrintWriter(String string, String string2) throws FileNotFoundException, IOException, UnsupportedEncodingException {
        return null;
    }

    public OutputStreamWriter toWriter(String string) throws FileNotFoundException, IOException {
        return null;
    }

    public OutputStreamWriter toWriter(String string, String string2) throws FileNotFoundException, IOException, UnsupportedEncodingException {
        return null;
    }

    public long getLastModified(String string) throws FileNotFoundException, IOException {
        return 0L;
    }

    public String getCanonicalPath(String string) {
        return null;
    }

    public String[] listClassRepositories(String string) {
        return null;
    }

    public String translateFromFullPath(String string) throws FileNotFoundException {
        return null;
    }

    public String translateToContextPath(String string) {
        return null;
    }

    public String translateToFullPath(String string) {
        return null;
    }

    public String translateToAbsolutePath(String string) {
        return null;
    }

    public String getAbsolutePath(String string) {
        return null;
    }
}

