/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.runtime.httpclient;

import HTTPClient.HTTPConnection;
import HTTPClient.HTTPResponse;
import HTTPClient.ModuleException;
import HTTPClient.NVPair;
import HTTPClient.ProtocolNotSuppException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import oracle.jsp.runtime.OracleJspRuntime;
import oracle.jsp.runtime.httpclient.NameValuePair;
import oracle.jsp.util.JspUtil;
import sun.io.CharacterEncoding;

public class ServerSideHttpClient {
    private static final String MSG_FILE = "oracle.jsp.runtime.httpclient.LocalStrings";
    private static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.runtime.httpclient.LocalStrings");
    private HTTPConnection con;
    private String protocol;
    private String host;
    private int port = -1;
    private boolean copyHeadersFromOrigClient = false;
    private boolean copyHeadersToOrigClient = false;
    private boolean copyParameters = false;
    private String[] headersExcludedForCopy;
    private String[] headersIncludedForCopy;
    static /* synthetic */ Class class$HTTPClient$CookieModule;

    public void setProtocol(String string) {
        this.protocol = string;
    }

    public void setHost(String string) {
        this.host = string;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public void setCopyHeadersFromOrigClient(boolean bl) {
        this.copyHeadersFromOrigClient = bl;
    }

    public void setCopyHeadersToOrigClient(boolean bl) {
        this.copyHeadersToOrigClient = bl;
    }

    public void setCopyParameters(boolean bl) {
        this.copyParameters = bl;
    }

    public void setHeadersExcludedForCopy(String[] stringArray) {
        this.headersExcludedForCopy = stringArray;
    }

    public void setHeadersIncludedForCopy(String[] stringArray) {
        this.headersIncludedForCopy = stringArray;
    }

    private void initCon(HttpServletRequest httpServletRequest) {
        if (this.con != null) {
            return;
        }
        if (this.protocol == null) {
            try {
                this.protocol = httpServletRequest.isSecure() ? "https" : "http";
            }
            catch (Throwable throwable) {
                this.protocol = "http";
            }
        }
        if (this.host == null) {
            this.host = httpServletRequest.getServerName();
            if (this.port == -1) {
                this.port = httpServletRequest.getServerPort();
            }
        }
        try {
            this.con = new HTTPConnection(this.protocol, this.host, this.port);
            this.con.setAllowUserInteraction(false);
        }
        catch (ProtocolNotSuppException protocolNotSuppException) {
            throw new IllegalArgumentException(protocolNotSuppException.toString());
        }
        this.con.removeModule(class$HTTPClient$CookieModule != null ? class$HTTPClient$CookieModule : (class$HTTPClient$CookieModule = ServerSideHttpClient.class$("HTTPClient.CookieModule")));
    }

    private boolean headerNeedsCopy(String string) {
        return (this.headersIncludedForCopy == null ? true : this.isStrInArray(string, this.headersIncludedForCopy)) && !this.isStrInArray(string, this.headersExcludedForCopy);
    }

    private boolean isIncluded(String string) {
        if (this.headersIncludedForCopy == null) {
            return true;
        }
        return this.isStrInArray(string, this.headersIncludedForCopy);
    }

    private boolean isExcluded(String string) {
        return this.isStrInArray(string, this.headersExcludedForCopy);
    }

    private boolean isStrInArray(String string, String[] stringArray) {
        if (stringArray == null || string == null) {
            return false;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (string.equals(stringArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private void copyHeadersToOrig(HttpServletResponse httpServletResponse, HTTPResponse hTTPResponse) throws IOException, ModuleException {
        if (this.copyHeadersToOrigClient) {
            Enumeration enumeration = hTTPResponse.listHeaders();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (!(this.headersIncludedForCopy == null ? true : this.isStrInArray(string, this.headersIncludedForCopy)) || this.isStrInArray(string, this.headersExcludedForCopy)) continue;
                String string2 = hTTPResponse.getHeader(string);
                httpServletResponse.addHeader(string, string2);
            }
        }
    }

    private NVPair[] getHeaders(HttpServletRequest httpServletRequest, NameValuePair[] nameValuePairArray) {
        Object object;
        if (nameValuePairArray == null) {
            nameValuePairArray = new NameValuePair[]{};
        }
        Vector<NVPair> vector = new Vector<NVPair>(20, 20);
        if (this.copyHeadersFromOrigClient) {
            Enumeration enumeration = httpServletRequest.getHeaderNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (!(this.headersIncludedForCopy == null ? true : this.isStrInArray(string, this.headersIncludedForCopy)) || this.isStrInArray(string, this.headersExcludedForCopy)) continue;
                object = httpServletRequest.getHeaders(string);
                while (object.hasMoreElements()) {
                    String string2 = (String)object.nextElement();
                    NVPair nVPair = new NVPair(string, string2);
                    vector.addElement(nVPair);
                }
            }
        }
        int n = nameValuePairArray.length;
        int n2 = vector.size();
        object = new NVPair[n + n2];
        int n3 = 0;
        while (n3 < n) {
            object[n3] = nameValuePairArray[n3].convert();
            ++n3;
        }
        int n4 = 0;
        while (n4 < n2) {
            object[n + n4] = (NVPair)vector.elementAt(n4);
            ++n4;
        }
        return object;
    }

    private String convertPath(String string, boolean bl, HttpServletRequest httpServletRequest) {
        if (bl || !string.startsWith("/")) {
            if (!string.startsWith("/")) {
                throw new IllegalArgumentException(JspUtil.format(msgs.getString("path_start_root"), new Object[]{string}));
            }
            String string2 = JspUtil.getContextPath(httpServletRequest);
            string = String.valueOf(string2) + string;
            return string;
        }
        return string;
    }

    public String get(String string, NameValuePair[] nameValuePairArray, boolean bl, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        this.initCon(httpServletRequest);
        string = this.convertPath(string, bl, httpServletRequest);
        if (this.copyParameters) {
            string = OracleJspRuntime.addQueryStrFromParameters(string, httpServletRequest, OracleJspRuntime.getCharacterEncoding(httpServletRequest, httpServletResponse));
        }
        NVPair[] nVPairArray = this.getHeaders(httpServletRequest, nameValuePairArray);
        try {
            HTTPResponse hTTPResponse = this.con.Get(string, null, nVPairArray);
            this.copyHeadersToOrig(httpServletResponse, hTTPResponse);
            return ServerSideHttpClient.getBodyString(hTTPResponse);
        }
        catch (ModuleException moduleException) {
            throw new IllegalStateException(moduleException.toString());
        }
    }

    private static String[] getNames(NameValuePair[] nameValuePairArray) {
        String[] stringArray = new String[nameValuePairArray.length];
        int n = 0;
        while (n < nameValuePairArray.length) {
            stringArray[n] = nameValuePairArray[n].getName();
            ++n;
        }
        return stringArray;
    }

    private static String[] getValues(NameValuePair[] nameValuePairArray) {
        String[] stringArray = new String[nameValuePairArray.length];
        int n = 0;
        while (n < nameValuePairArray.length) {
            stringArray[n] = nameValuePairArray[n].getValue();
            ++n;
        }
        return stringArray;
    }

    public String post(String string, NameValuePair[] nameValuePairArray, NameValuePair[] nameValuePairArray2, boolean bl, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        NameValuePair[] nameValuePairArray3;
        this.initCon(httpServletRequest);
        string = this.convertPath(string, bl, httpServletRequest);
        String string2 = "?";
        String string3 = OracleJspRuntime.getCharacterEncoding(httpServletRequest, httpServletResponse);
        if (nameValuePairArray != null) {
            string2 = OracleJspRuntime.genPageUrl(string2, httpServletRequest, ServerSideHttpClient.getNames(nameValuePairArray), ServerSideHttpClient.getValues(nameValuePairArray), string3);
        }
        if (this.copyParameters) {
            string2 = OracleJspRuntime.addQueryStrFromParameters(string2, httpServletRequest, string3);
        }
        string2 = string2.substring(1);
        byte[] byArray = new byte[string2.length()];
        int n = 0;
        while (n < byArray.length) {
            byArray[n] = (byte)string2.charAt(n);
            ++n;
        }
        NameValuePair nameValuePair = new NameValuePair("Content-type", "application/x-www-form-urlencoded");
        if (nameValuePairArray2 == null) {
            nameValuePairArray3 = new NameValuePair[]{nameValuePair};
        } else {
            nameValuePairArray3 = new NameValuePair[nameValuePairArray2.length + 1];
            nameValuePairArray3[0] = nameValuePair;
            int n2 = 0;
            while (n2 < nameValuePairArray2.length) {
                nameValuePairArray3[n2 + 1] = nameValuePairArray2[n2];
                ++n2;
            }
        }
        NVPair[] nVPairArray = this.getHeaders(httpServletRequest, nameValuePairArray3);
        try {
            HTTPResponse hTTPResponse = this.con.Post(string, byArray, nVPairArray);
            this.copyHeadersToOrig(httpServletResponse, hTTPResponse);
            return ServerSideHttpClient.getBodyString(hTTPResponse);
        }
        catch (ModuleException moduleException) {
            throw new IllegalStateException(moduleException.toString());
        }
    }

    private static String getBodyString(HTTPResponse hTTPResponse) throws IOException, ModuleException {
        byte[] byArray = hTTPResponse.getData();
        String string = hTTPResponse.getHeader("Content-Type");
        String string2 = ServerSideHttpClient.getCharsetFromContentType(string);
        if (string2 == null) {
            string2 = "ISO-8859-1";
        }
        return new String(byArray, ServerSideHttpClient.aliasEncoding(string2));
    }

    private static String getCharsetFromContentType(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(";");
        if (n == -1) {
            return null;
        }
        String string2 = string.substring(n + 1);
        int n2 = string2.indexOf("charset=");
        if (n2 == -1) {
            return null;
        }
        String string3 = string2.substring(n2 + 8);
        String string4 = string3.trim();
        return string4;
    }

    private static String aliasEncoding(String string) {
        if (string != null) {
            String string2 = CharacterEncoding.aliasName((String)string.toUpperCase());
            if (string2 == null) {
                return string;
            }
            return string2;
        }
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

