/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.runtime;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import oracle.jsp.runtime.ByteArrayServletOutputStream;

public class BodyResponse
implements HttpServletResponse {
    private int headerChangesFlag;
    private HttpServletResponse origResponse;
    private ByteArrayServletOutputStream sos;
    private CharArrayWriter charBuf;
    private PrintWriter pw;
    private static final String MSG_FILE = "oracle.jsp.runtime.LocalStrings";
    private static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.runtime.LocalStrings");
    private static final String NOT_ALLOWED = msgs.getString("headers_not_allowed");
    public static final int ALLOW_HEADER_CHANGES = 0;
    public static final int IGNORE_HEADER_CHANGES = 1;
    public static final int FORBID_HEADER_CHANGES = 2;

    public BodyResponse(int n, HttpServletResponse httpServletResponse) {
        this.headerChangesFlag = n;
        this.origResponse = httpServletResponse;
    }

    public void addCookie(Cookie cookie) {
        if (this.headerChangesFlag == 1) {
            return;
        }
        if (this.headerChangesFlag == 2) {
            throw new IllegalStateException(NOT_ALLOWED);
        }
        this.origResponse.addCookie(cookie);
    }

    public boolean containsHeader(String string) {
        return this.origResponse.containsHeader(string);
    }

    public String encodeURL(String string) {
        return this.origResponse.encodeURL(string);
    }

    public String encodeRedirectURL(String string) {
        return this.origResponse.encodeRedirectURL(string);
    }

    public String encodeUrl(String string) {
        return this.origResponse.encodeUrl(string);
    }

    public String encodeRedirectUrl(String string) {
        return this.origResponse.encodeRedirectUrl(string);
    }

    public void sendError(int n, String string) throws IOException {
        if (this.headerChangesFlag == 1) {
            return;
        }
        if (this.headerChangesFlag == 2) {
            throw new IllegalStateException(NOT_ALLOWED);
        }
        this.origResponse.sendError(n, string);
    }

    public void sendError(int n) throws IOException {
        if (this.headerChangesFlag == 1) {
            return;
        }
        if (this.headerChangesFlag == 2) {
            throw new IllegalStateException(NOT_ALLOWED);
        }
        this.origResponse.sendError(n);
    }

    public void sendRedirect(String string) throws IOException {
        if (this.headerChangesFlag == 1) {
            return;
        }
        if (this.headerChangesFlag == 2) {
            throw new IllegalStateException(NOT_ALLOWED);
        }
        this.origResponse.sendRedirect(string);
    }

    public void setDateHeader(String string, long l) {
        if (this.headerChangesFlag == 1) {
            return;
        }
        if (this.headerChangesFlag == 2) {
            throw new IllegalStateException(NOT_ALLOWED);
        }
        this.origResponse.setDateHeader(string, l);
    }

    public void addDateHeader(String string, long l) {
        if (this.headerChangesFlag == 1) {
            return;
        }
        if (this.headerChangesFlag == 2) {
            throw new IllegalStateException(NOT_ALLOWED);
        }
        this.origResponse.addDateHeader(string, l);
    }

    public void setHeader(String string, String string2) {
        if (this.headerChangesFlag == 1) {
            return;
        }
        if (this.headerChangesFlag == 2) {
            throw new IllegalStateException(NOT_ALLOWED);
        }
        this.origResponse.setHeader(string, string2);
    }

    public void addHeader(String string, String string2) {
        if (this.headerChangesFlag == 1) {
            return;
        }
        if (this.headerChangesFlag == 2) {
            throw new IllegalStateException(NOT_ALLOWED);
        }
        this.origResponse.addHeader(string, string2);
    }

    public void setIntHeader(String string, int n) {
        if (this.headerChangesFlag == 1) {
            return;
        }
        if (this.headerChangesFlag == 2) {
            throw new IllegalStateException(NOT_ALLOWED);
        }
        this.origResponse.setIntHeader(string, n);
    }

    public void addIntHeader(String string, int n) {
        if (this.headerChangesFlag == 1) {
            return;
        }
        if (this.headerChangesFlag == 2) {
            throw new IllegalStateException(NOT_ALLOWED);
        }
        this.origResponse.addIntHeader(string, n);
    }

    public void setStatus(int n) {
        if (this.headerChangesFlag == 1) {
            return;
        }
        if (this.headerChangesFlag == 2) {
            throw new IllegalStateException(NOT_ALLOWED);
        }
        this.origResponse.setStatus(n);
    }

    public void setStatus(int n, String string) {
        if (this.headerChangesFlag == 1) {
            return;
        }
        if (this.headerChangesFlag == 2) {
            throw new IllegalStateException(NOT_ALLOWED);
        }
        this.origResponse.setStatus(n, string);
    }

    public String getCharacterEncoding() {
        return this.origResponse.getCharacterEncoding();
    }

    public ServletOutputStream getOutputStream() throws IOException {
        this.origResponse.getOutputStream();
        if (this.pw != null) {
            throw new IllegalStateException(msgs.getString("writer_obtained"));
        }
        if (this.sos == null) {
            this.sos = new ByteArrayServletOutputStream();
        }
        return this.sos;
    }

    public PrintWriter getWriter() throws IOException {
        this.origResponse.getWriter();
        if (this.sos != null) {
            throw new IllegalStateException("outputstream_obtained");
        }
        if (this.pw == null) {
            this.charBuf = new CharArrayWriter();
            this.pw = new PrintWriter(this.charBuf);
        }
        return this.pw;
    }

    public void setBufferSize(int n) {
    }

    public int getBufferSize() {
        return this.origResponse.getBufferSize();
    }

    public void flushBuffer() throws IOException {
    }

    public boolean isCommitted() {
        return false;
    }

    public void reset() {
        if (this.sos != null) {
            this.sos.reset();
        }
        if (this.charBuf != null) {
            this.charBuf.reset();
        }
    }

    public byte[] getByteBuffer() {
        if (this.sos == null) {
            return null;
        }
        return this.sos.toByteArray();
    }

    public char[] getCharBuffer() {
        if (this.charBuf == null) {
            return null;
        }
        return this.charBuf.toCharArray();
    }

    public void setContentLength(int n) {
        if (this.headerChangesFlag == 1) {
            return;
        }
        if (this.headerChangesFlag == 2) {
            throw new IllegalStateException(NOT_ALLOWED);
        }
        this.origResponse.setContentLength(n);
    }

    public void setContentType(String string) {
        if (this.headerChangesFlag == 1) {
            return;
        }
        if (this.headerChangesFlag == 2) {
            throw new IllegalStateException(NOT_ALLOWED);
        }
        this.origResponse.setContentType(string);
    }

    public void setLocale(Locale locale) {
        if (this.headerChangesFlag == 1) {
            return;
        }
        if (this.headerChangesFlag == 2) {
            throw new IllegalStateException(NOT_ALLOWED);
        }
        this.origResponse.setLocale(locale);
    }

    public Locale getLocale() {
        return this.origResponse.getLocale();
    }
}

