/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.runner;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.SingleThreadModel;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspFactory;
import oracle.jsp.runtime.OracleJspFactory;
import oracle.jsp.util.JspUtil;
import oracle.jsp.util.JspVersion;

public class JspRunner
extends HttpServlet {
    private static final String MESSAGE_FILE = "oracle.jsp.runner.LocalStrings";
    private static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.runner.LocalStrings");
    private Hashtable servlets;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        OracleJspFactory oracleJspFactory = new OracleJspFactory();
        JspFactory.setDefaultFactory((JspFactory)oracleJspFactory);
        ServletContext servletContext = servletConfig.getServletContext();
        if (JspVersion.getServletVersion(servletContext) == 1) {
            String string = msgs.getString("pre_2.1");
            servletContext.log(string);
            throw new ServletException(string);
        }
        if (JspVersion.getServletVersion(servletContext) > 1) {
            servletContext.setAttribute("oracle.jsp.versionNumber", (Object)"1.1.2.0");
        }
        this.servlets = new Hashtable();
    }

    public void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = JspUtil.getFullClassNameFromURL(JspUtil.getRequestURI(httpServletRequest));
        Servlet servlet = (Servlet)this.servlets.get(string);
        if (servlet == null) {
            servlet = this.loadServlet(string);
        }
        try {
            this.dispatch(servlet, httpServletRequest, httpServletResponse);
            return;
        }
        catch (ServletException servletException) {
            this.servlets.remove(string);
            throw servletException;
        }
        catch (IOException iOException) {
            this.servlets.remove(string);
            throw iOException;
        }
    }

    public void destroy() {
        Enumeration enumeration = this.servlets.elements();
        while (enumeration.hasMoreElements()) {
            Servlet servlet = (Servlet)enumeration.nextElement();
            servlet.destroy();
        }
    }

    private Servlet loadServlet(String string) throws ServletException {
        Servlet servlet;
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.getServletContext().log((Exception)classNotFoundException, MessageFormat.format(msgs.getString("cannot_load_class"), string));
            throw new ServletException(classNotFoundException.getLocalizedMessage());
        }
        try {
            servlet = (Servlet)clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            this.getServletContext().log((Exception)instantiationException, MessageFormat.format(msgs.getString("cannot_create_class"), string));
            throw new ServletException(instantiationException.getLocalizedMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            this.getServletContext().log((Exception)illegalAccessException, MessageFormat.format(msgs.getString("bad_class_access"), string));
            throw new ServletException(illegalAccessException.getLocalizedMessage());
        }
        servlet.init(this.getServletConfig());
        this.servlets.put(string, servlet);
        return servlet;
    }

    private void dispatch(Servlet servlet, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        if (servlet instanceof SingleThreadModel) {
            Servlet servlet2 = servlet;
            synchronized (servlet2) {
                servlet.service((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
                return;
            }
        }
        servlet.service((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
    }
}

