/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.provider;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.ResourceBundle;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import oracle.jsp.provider.JspResourceProvider;

public class JspFilesystemResource
implements JspResourceProvider {
    private static final String MESSAGE_FILE = "oracle.jsp.provider.LocalStrings";
    private static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.provider.LocalStrings");
    protected String repositoryRoot;
    protected String contextRoot;
    protected String appPath;
    protected String physicalRoot;
    protected String virtualRoot;
    protected int vLen;
    private boolean needsInit = true;

    public void init(String string, String string2, String string3, ServletContext servletContext, HttpServletRequest httpServletRequest, Hashtable hashtable) throws IllegalStateException {
        if (!this.needsInit) {
            return;
        }
        this.needsInit = false;
        if (string == null || string2 == null || string3 == null) {
            throw new IllegalStateException(msgs.getString("null_provider"));
        }
        this.setRoots(string, string2, string3);
        this.ensurePath("/");
    }

    public void init(JspResourceProvider jspResourceProvider, String string) throws IllegalStateException {
        if (!this.needsInit) {
            return;
        }
        this.needsInit = false;
        if (string == null) {
            throw new IllegalStateException(msgs.getString("null_provider"));
        }
        JspFilesystemResource jspFilesystemResource = (JspFilesystemResource)jspResourceProvider;
        if (string.equals("/")) {
            this.repositoryRoot = jspFilesystemResource.repositoryRoot;
            this.contextRoot = jspFilesystemResource.contextRoot;
            this.appPath = jspFilesystemResource.appPath;
            this.physicalRoot = jspFilesystemResource.physicalRoot;
            this.virtualRoot = jspFilesystemResource.virtualRoot;
            this.vLen = jspFilesystemResource.vLen;
        } else if (jspFilesystemResource.appPath.equals("/")) {
            this.setRoots(jspFilesystemResource.repositoryRoot, jspFilesystemResource.contextRoot, string);
        } else {
            this.setRoots(jspFilesystemResource.repositoryRoot, jspFilesystemResource.contextRoot, this.concatPaths(jspFilesystemResource.appPath, string, "/"));
        }
        this.ensurePath("/");
    }

    private void setRoots(String string, String string2, String string3) {
        if (string.charAt(string.length() - 1) != File.separatorChar) {
            string = String.valueOf(string) + File.separator;
        }
        this.repositoryRoot = string;
        this.contextRoot = this.normalizeRoot(string2, "/");
        this.appPath = this.normalizeRoot(string3, "/");
        this.virtualRoot = this.concatPaths(this.contextRoot, this.appPath, "/");
        this.vLen = this.virtualRoot.length();
        this.physicalRoot = this.concatPaths(this.repositoryRoot.replace('/', File.separatorChar), this.appPath.replace('/', File.separatorChar), File.separator);
    }

    public String getRepositoryRoot() {
        return this.repositoryRoot;
    }

    public String getContextRoot() {
        return this.contextRoot;
    }

    public String getAppRoot() {
        return this.appPath;
    }

    public InputStream fromStream(String string) throws FileNotFoundException, IOException {
        return new FileInputStream(this.translateToAbsolutePath(string));
    }

    public InputStreamReader fromReader(String string) throws FileNotFoundException, IOException {
        try {
            return this.fromReader(string, null);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IOException(msgs.getString("no_encoding"));
        }
    }

    public InputStreamReader fromReader(String string, String string2) throws FileNotFoundException, IOException, UnsupportedEncodingException {
        if (string2 != null) {
            return new InputStreamReader(this.fromStream(string), string2);
        }
        return new InputStreamReader(this.fromStream(string));
    }

    public OutputStream toStream(String string) throws FileNotFoundException, IOException {
        String string2 = this.translateToAbsolutePath(string);
        try {
            return new FileOutputStream(string2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.createPath(this.stripTarget(string2, File.separator));
            return new FileOutputStream(string2);
        }
    }

    public PrintWriter toPrintWriter(String string) throws FileNotFoundException, IOException {
        return new PrintWriter(this.toWriter(string));
    }

    public PrintWriter toPrintWriter(String string, String string2) throws FileNotFoundException, IOException, UnsupportedEncodingException {
        return new PrintWriter(this.toWriter(string, string2));
    }

    public OutputStreamWriter toWriter(String string) throws FileNotFoundException, IOException {
        try {
            return this.toWriter(string, null);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IOException(msgs.getString("no_encoding"));
        }
    }

    public OutputStreamWriter toWriter(String string, String string2) throws FileNotFoundException, IOException, UnsupportedEncodingException {
        if (string2 != null) {
            return new OutputStreamWriter(this.toStream(string), string2);
        }
        return new OutputStreamWriter(this.toStream(string));
    }

    protected void ensurePath(String string) {
        String string2 = this.translateToAbsolutePath(string);
        this.createPath(this.stripTarget(string2, File.separator));
    }

    public long getLastModified(String string) throws FileNotFoundException, IOException {
        File file = new File(this.translateToAbsolutePath(string));
        return file.lastModified();
    }

    public String getCanonicalPath(String string) {
        File file;
        try {
            file = new File(this.translateToAbsolutePath(string));
        }
        catch (Exception exception) {
            return null;
        }
        try {
            return file.getCanonicalPath();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String[] listClassRepositories(String string) {
        File file = string.charAt(0) == '/' ? new File(String.valueOf(this.physicalRoot) + string.replace('/', File.separatorChar).substring(1)) : new File(String.valueOf(this.physicalRoot) + string.replace('/', File.separatorChar));
        String[] stringArray = file.list();
        if (stringArray == null) {
            return null;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (stringArray[n2].endsWith(".jar")) {
                stringArray[n++] = stringArray[n2];
            }
            ++n2;
        }
        String[] stringArray2 = new String[n];
        int n3 = 0;
        while (n3 < n) {
            stringArray2[n3] = stringArray[n3];
            ++n3;
        }
        return stringArray2;
    }

    public String translateFromFullPath(String string) throws FileNotFoundException {
        if (string.regionMatches(false, 0, this.virtualRoot, 0, this.vLen - 1)) {
            if (string.length() > this.vLen) {
                return string.substring(this.vLen - 1);
            }
            return "/";
        }
        throw new FileNotFoundException(MessageFormat.format(msgs.getString("bad_root"), this.virtualRoot, string));
    }

    public String translateToFullPath(String string) {
        if (string.equals("/")) {
            if (this.vLen == 1) {
                return this.virtualRoot;
            }
            if (this.virtualRoot.charAt(this.vLen - 1) == '/') {
                return this.virtualRoot.substring(0, this.virtualRoot.length() - 1);
            }
            return this.virtualRoot;
        }
        if (string.charAt(0) != '/') {
            return String.valueOf(this.virtualRoot) + string;
        }
        return String.valueOf(this.virtualRoot) + string.substring(1);
    }

    public String translateToContextPath(String string) {
        if (string.charAt(0) == '/') {
            if (string.length() == 1) {
                int n = this.appPath.length();
                if (n == 1 || this.appPath.charAt(this.appPath.length() - 1) != '/') {
                    return this.appPath;
                }
                return this.appPath.substring(0, this.appPath.length() - 1);
            }
            return String.valueOf(this.appPath) + string.substring(1);
        }
        return String.valueOf(this.appPath) + string;
    }

    public String translateToAbsolutePath(String string) {
        return this.concatPaths(this.physicalRoot, string.replace('/', File.separatorChar), File.separator);
    }

    public String getAbsolutePath(String string) {
        return this.translateToAbsolutePath(string);
    }

    protected String concatPaths(String string, String string2, String string3) {
        boolean bl;
        int n = string.length();
        boolean bl2 = string.charAt(n - 1) == string3.charAt(0);
        boolean bl3 = bl = string2.charAt(0) == string3.charAt(0);
        if (n == 1 && bl2 && bl) {
            return string2;
        }
        if (bl2 && !bl || !bl2 && bl) {
            return String.valueOf(string) + string2;
        }
        if (!bl2 && !bl) {
            return String.valueOf(string) + string3 + string2;
        }
        return String.valueOf(string.substring(0, n - 1)) + string2;
    }

    protected String normalizeRoot(String string, String string2) {
        boolean bl;
        int n = string.length();
        boolean bl2 = string.charAt(0) == string2.charAt(0);
        boolean bl3 = bl = string.charAt(n - 1) == string2.charAt(0);
        if (bl2 && bl || bl2 && n == 1) {
            return string;
        }
        if (!bl2 && !bl) {
            return String.valueOf(string2) + string + string2;
        }
        if (!bl2 && bl) {
            return String.valueOf(string2) + string;
        }
        return String.valueOf(string) + string2;
    }

    protected String stripTarget(String string, String string2) {
        int n = string.lastIndexOf(string2);
        if (n <= 0) {
            return string2;
        }
        return string.substring(0, n);
    }

    protected void createPath(String string) {
        File file = new File(string);
        if (!file.exists()) {
            file.mkdirs();
        }
    }
}

