/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.provider;

import java.io.File;
import java.util.Hashtable;
import java.util.ResourceBundle;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import oracle.jsp.provider.JspFilesystemResource;
import oracle.jsp.provider.JspResourceProvider;
import oracle.jsp.util.JspUtil;
import oracle.jsp.util.JspVersion;

public class JspFSServletContextResource
extends JspFilesystemResource {
    private static final String MESSAGE_FILE = "oracle.jsp.provider.LocalStrings";
    private static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.provider.LocalStrings");
    protected ServletContext servletContext;
    private int servletVersion = 0;
    private boolean needsInit = true;
    private boolean repositoryProvided;

    public void init(String string, String string2, String string3, ServletContext servletContext, HttpServletRequest httpServletRequest, Hashtable hashtable) throws IllegalStateException {
        if (!this.needsInit) {
            return;
        }
        this.needsInit = false;
        this.servletContext = servletContext;
        this.appPath = this.normalizeRoot(string3, "/");
        if (string2 == null) {
            this.servletVersion = JspVersion.getServletVersion(servletContext);
            this.contextRoot = this.normalizeRoot(this.getContextRoot(servletContext, httpServletRequest, this.servletVersion), "/");
        } else {
            this.contextRoot = this.normalizeRoot(string2, "/");
        }
        this.virtualRoot = this.concatPaths(this.contextRoot, this.appPath, "/");
        this.vLen = this.virtualRoot.length();
        this.repositoryRoot = string;
        if (this.repositoryRoot == null) {
            this.servletVersion = JspVersion.getServletVersion(servletContext);
            this.repositoryRoot = this.getRepositoryRoot(servletContext, httpServletRequest, this.servletVersion);
            this.repositoryProvided = false;
        } else {
            this.repositoryProvided = true;
        }
        this.physicalRoot = this.concatPaths(this.repositoryRoot, this.appPath.replace('/', File.separatorChar), File.separator);
        this.ensurePath("/");
    }

    public void init(JspResourceProvider jspResourceProvider, String string) throws IllegalStateException {
        String string2;
        if (!this.needsInit) {
            return;
        }
        this.needsInit = false;
        JspFSServletContextResource jspFSServletContextResource = (JspFSServletContextResource)jspResourceProvider;
        this.servletContext = jspFSServletContextResource.servletContext;
        this.servletVersion = jspFSServletContextResource.servletVersion;
        this.repositoryProvided = jspFSServletContextResource.repositoryProvided;
        super.init(jspResourceProvider, string);
        if (this.servletVersion > 1 && !string.equals("/") && !this.repositoryProvided && (string2 = this.getServletContextRealPath(this.appPath).replace('/', File.separatorChar)) != null) {
            this.physicalRoot = string2;
            if (this.physicalRoot.charAt(this.physicalRoot.length() - 1) != File.separatorChar) {
                this.physicalRoot = String.valueOf(this.physicalRoot) + File.separatorChar;
            }
        }
        this.ensurePath("/");
    }

    public String translateToAbsolutePath(String string) {
        String string2 = null;
        if (this.servletVersion > 1 && !this.repositoryProvided) {
            string2 = this.getServletContextRealPath(this.translateToContextPath(string));
        }
        if (string2 == null) {
            return super.translateToAbsolutePath(string);
        }
        string2 = string2.replace('/', File.separatorChar);
        return string2;
    }

    protected String getServletContextRealPath(String string) {
        return this.servletContext.getRealPath(string);
    }

    private String getRepositoryRoot(ServletContext servletContext, HttpServletRequest httpServletRequest, int n) throws IllegalStateException {
        if (n == 1) {
            return httpServletRequest.getRealPath("/").replace('/', File.separatorChar);
        }
        String string = "/";
        if ((string = this.getServletContextRealPath(string)) == null && (string = httpServletRequest.getRealPath("/")) == null) {
            throw new IllegalStateException(msgs.getString("no_real_path"));
        }
        return string.replace('/', File.separatorChar);
    }

    private String getContextRoot(ServletContext servletContext, HttpServletRequest httpServletRequest, int n) throws IllegalStateException {
        if (n == 1) {
            return "/";
        }
        String string = JspUtil.stripProtocol(JspUtil.getRequestURI(httpServletRequest));
        int n2 = -1;
        String string2 = JspUtil.getServletPath(httpServletRequest);
        if (string2 != null && string2.length() > 0) {
            if (string2.charAt(0) != '/') {
                string2 = "/" + string2;
            }
            if ((n2 = string.indexOf(string2, 0)) == 0) {
                return "/";
            }
            if (n2 > 0) {
                return string.substring(0, n2 + 1);
            }
        }
        if ((string2 = JspUtil.getPathInfo(httpServletRequest)) != null && string2.length() > 0) {
            if (string2.charAt(0) != '/') {
                string2 = "/" + string2;
            }
            if ((n2 = string.indexOf(string2, 0)) == 0) {
                return "/";
            }
            if (n2 > 0) {
                return string.substring(0, n2 + 1);
            }
        }
        throw new IllegalStateException(msgs.getString("no_ctx_path"));
    }

    private String getRetranslatedRoot(ServletContext servletContext, HttpServletRequest httpServletRequest, int n) throws IllegalStateException {
        String string = httpServletRequest.getPathTranslated();
        String string2 = httpServletRequest.getRequestURI();
        String string3 = null;
        string3 = n == 1 ? httpServletRequest.getRealPath(string2) : servletContext.getRealPath(string2.substring(this.contextRoot.length() - 1));
        if (string3.equals(string)) {
            return this.getRepositoryRoot(servletContext, httpServletRequest, n);
        }
        return null;
    }
}

