/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.parse;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import oracle.jsp.parse.JspBeanInfo;
import oracle.jsp.parse.JspEmitException;
import oracle.jsp.parse.JspEmitState;
import oracle.jsp.parse.JspParseException;
import oracle.jsp.parse.JspParseState;
import oracle.jsp.parse.JspParseTag;
import oracle.jsp.parse.JspUtils;
import oracle.jsp.parse.OpenJspAVDesc;
import oracle.jsp.parse.OpenJspAVInfo;
import oracle.jsp.parse.OpenJspDefineItem;

public class OpenJspTagHandler
extends JspParseTag {
    private static final String MSG_FILE = "oracle.jsp.parse.LocalStrings";
    private static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.parse.LocalStrings");
    public String nameSpace;
    public String htmlTag;
    public boolean bodyIsText;
    private OpenJspAVInfo[] avInfo;
    public static final String[] validScopes = new String[]{"page", "request", "session", "application"};
    public static final OpenJspAVDesc idDesc = new OpenJspAVDesc("id", 4, true);
    public static final OpenJspAVDesc scopeDesc = new OpenJspAVDesc("scope", 1, false, true, validScopes);
    public static final String[] validJmlTypes = new String[]{"string", "boolean", "number", "fpnumber"};
    private int blockScope = 0;

    public OpenJspTagHandler() {
        super(7);
    }

    public boolean allowsBody() {
        return true;
    }

    public String toString() {
        String string = "<Custom Tag: ";
        string = string.concat(this.getTagName());
        string = string.concat(">");
        return string;
    }

    public String getTagName() {
        return this.htmlTag;
    }

    public void setTagString(String string) {
        super.setTagString(string);
        int n = string.indexOf(58);
        if (n == -1 || n + 1 >= string.length()) {
            this.nameSpace = "";
            return;
        }
        this.nameSpace = string.substring(0, n);
    }

    private void getAVInfo() {
        if (this.avInfo != null) {
            return;
        }
        OpenJspAVDesc[] openJspAVDescArray = this.getAVDescriptions();
        if (openJspAVDescArray == null || openJspAVDescArray.length == 0) {
            this.avInfo = new OpenJspAVInfo[0];
            return;
        }
        this.avInfo = new OpenJspAVInfo[openJspAVDescArray.length];
        int n = 0;
        while (n < openJspAVDescArray.length) {
            this.avInfo[n] = new OpenJspAVInfo(openJspAVDescArray[n]);
            ++n;
        }
    }

    public void processAttributeValue(JspParseState jspParseState, int n, String string, String string2) throws JspParseException {
        if (this.avInfo == null) {
            this.getAVInfo();
        }
        int n2 = 0;
        while (n2 < this.avInfo.length) {
            if (this.avInfo[n2].desc.name.equals(string)) {
                if (this.avInfo[n2].valueExists()) {
                    throw new JspParseException(jspParseState, MessageFormat.format(msgs.getString("same_attr"), string));
                }
                this.avInfo[n2].setValue(jspParseState, string2);
                return;
            }
            ++n2;
        }
        throw new JspParseException(jspParseState, MessageFormat.format(msgs.getString("bad_attr_name"), string));
    }

    protected boolean getScopeSensitive() {
        return true;
    }

    public void validateTagAttributes(JspParseState jspParseState) throws JspParseException {
        OpenJspAVInfo openJspAVInfo;
        if (this.avInfo == null) {
            this.getAVInfo();
        }
        int n = 0;
        while (n < this.avInfo.length) {
            if (this.avInfo[n].desc.required && !this.avInfo[n].valueExists()) {
                throw new JspParseException(jspParseState, MessageFormat.format(msgs.getString("need_attr"), this.avInfo[n].desc.name));
            }
            ++n;
        }
        String string = this.validateAttributeList(jspParseState, this.avInfo);
        if (string != null) {
            throw new JspParseException(jspParseState, MessageFormat.format(msgs.getString("bad_attr_list"), string));
        }
        this.blockScope = this.defineBeans(jspParseState, this.getDefinedObjects());
        if (this.getScopeSensitive() && (openJspAVInfo = this.findAV("scope")) != null && openJspAVInfo.valueExists()) {
            String string2 = openJspAVInfo.getStringValue();
            if (jspParseState.isGlobalsPage()) {
                if (!string2.equals("session") && !string2.equals("application")) {
                    throw new JspParseException(jspParseState, msgs.getString("bad_scope_in_globals"));
                }
            } else if (string2.equals("session") && !JspUtils.translateBoolean(jspParseState.getDirectiveAttrValue("page", "session"), true)) {
                throw new JspParseException(jspParseState, msgs.getString("bad_session_scope"));
            }
        }
    }

    private int defineBeans(JspParseState jspParseState) throws JspParseException {
        return this.defineBeans(jspParseState, this.getDefinedObjects());
    }

    private int defineAfterBeans(JspParseState jspParseState) throws JspParseException {
        return this.defineBeans(jspParseState, this.getDefinedAfterObjects());
    }

    private int defineBeans(JspParseState jspParseState, OpenJspDefineItem[] openJspDefineItemArray) throws JspParseException {
        boolean bl = false;
        int n = 10;
        if (openJspDefineItemArray != null && openJspDefineItemArray.length > 0) {
            int n2 = 0;
            while (n2 < openJspDefineItemArray.length) {
                int n3;
                if (openJspDefineItemArray[n2].getScope() != 0) {
                    if (jspParseState.beans.beanExists(openJspDefineItemArray[n2].name)) {
                        throw new JspParseException(jspParseState, MessageFormat.format(msgs.getString("seen_bean"), openJspDefineItemArray[n2].name));
                    }
                    n3 = openJspDefineItemArray[n2].getScope();
                } else {
                    if (!bl) {
                        n = jspParseState.beans.getNextBlockScope();
                        bl = true;
                    }
                    n3 = n;
                }
                JspBeanInfo jspBeanInfo = new JspBeanInfo(openJspDefineItemArray[n2].name, openJspDefineItemArray[n2].className, n3);
                if (!jspBeanInfo.loadBean(jspParseState)) {
                    throw new JspParseException(jspParseState, MessageFormat.format(msgs.getString("no_bean_class"), openJspDefineItemArray[n2].name, openJspDefineItemArray[n2].className));
                }
                jspParseState.beans.addBean(jspBeanInfo);
                openJspDefineItemArray[n2].bean = jspBeanInfo;
                ++n2;
            }
        }
        if (bl) {
            return n;
        }
        return 0;
    }

    private void registerHandlers(JspParseState jspParseState, String string, String string2) {
        String string3 = String.valueOf(this.nameSpace) + ":";
        if (string.charAt(0) == ':') {
            string = string.substring(1);
        } else {
            string3 = "";
        }
        String string4 = String.valueOf(string3) + string;
        jspParseState.registerTagHandler(string4, string2);
        string4 = string.toLowerCase();
        if (!string4.equals(string)) {
            jspParseState.registerTagHandler(String.valueOf(string3) + string4, string2);
        }
        if (!(string4 = string.toUpperCase()).equals(string)) {
            jspParseState.registerTagHandler(String.valueOf(string3) + string4, string2);
        }
    }

    private void unRegisterHandlers(JspParseState jspParseState, String string) {
        String string2 = String.valueOf(this.nameSpace) + ":";
        if (string.charAt(0) == ':') {
            string = string.substring(1);
        } else {
            string2 = "";
        }
        String string3 = String.valueOf(string2) + string;
        jspParseState.unRegisterTagHandler(string3);
        string3 = string.toLowerCase();
        if (!string3.equals(string)) {
            jspParseState.unRegisterTagHandler(String.valueOf(string2) + string3);
        }
        if (!(string3 = string.toUpperCase()).equals(string)) {
            jspParseState.unRegisterTagHandler(String.valueOf(string2) + string3);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void parseBody(JspParseState jspParseState) throws IOException, JspParseException {
        Throwable throwable2;
        int n;
        String[] stringArray;
        block11: {
            stringArray = this.getSubTags();
            if (stringArray != null && stringArray.length > 0) {
                n = 0;
                while (n < stringArray.length) {
                    this.registerHandlers(jspParseState, stringArray[n], stringArray[n + 1]);
                    n += 2;
                }
            }
            try {
                if (this.bodyIsText) {
                    String string = this.parseBodyAsText(jspParseState);
                    this.validateTextBody(jspParseState, string);
                } else {
                    super.parseBody(jspParseState);
                }
            }
            catch (Throwable throwable2) {
                Object var5_6 = null;
                if (stringArray == null) throw throwable2;
                if (stringArray.length <= 0) throw throwable2;
                n = 0;
                break block11;
            }
            Object var5_5 = null;
            if (stringArray == null) return;
            if (stringArray.length <= 0) return;
            n = 0;
            while (true) {
                if (n >= stringArray.length) {
                    return;
                }
                this.unRegisterHandlers(jspParseState, stringArray[n]);
                n += 2;
            }
        }
        while (true) {
            if (n >= stringArray.length) {
                throw throwable2;
            }
            this.unRegisterHandlers(jspParseState, stringArray[n]);
            n += 2;
        }
    }

    public String parseBodyAsText(JspParseState jspParseState) throws IOException, JspParseException {
        String string = null;
        if (jspParseState.getLine() == null || jspParseState.getLine().length() == 0) {
            jspParseState.ReadLine();
        }
        String string2 = "</" + this.tagString + ">";
        while (jspParseState.getLine() != null) {
            int n = jspParseState.getLine().indexOf(string2);
            if (n != -1) {
                if (n > 0) {
                    string = string != null ? String.valueOf(string) + jspParseState.getLine().substring(0, n) : jspParseState.getLine().substring(0, n);
                }
                this.endLineNumber = jspParseState.position.lineNum;
                this.endColumnNumber = jspParseState.getColNum() + n + string2.length();
                if (n + string2.length() >= jspParseState.getLine().length()) {
                    jspParseState.clearLine();
                } else {
                    jspParseState.advLine(n + string2.length());
                }
                return string;
            }
            string = string != null ? String.valueOf(string) + jspParseState.getLine() : jspParseState.getLine();
            jspParseState.clearLine();
            if (jspParseState.getLine() != null && jspParseState.getLine().length() != 0) continue;
            jspParseState.ReadLine();
        }
        throw new JspParseException(jspParseState, MessageFormat.format(msgs.getString("no_end_tag"), string2));
    }

    protected boolean containsTag(String string) {
        return this.findTagInBody(string) != null;
    }

    protected void parse(JspParseState jspParseState) throws IOException, JspParseException {
        int n;
        super.parse(jspParseState);
        if (this.blockScope > 0) {
            jspParseState.beans.killBlockScope(this.blockScope);
        }
        if ((n = this.defineBeans(jspParseState, this.getDefinedAfterObjects())) > 0) {
            jspParseState.beans.killBlockScope(n);
        }
    }

    public void emitTagStart(JspEmitState jspEmitState) throws JspEmitException {
        try {
            this.emitStart(jspEmitState);
            return;
        }
        catch (Throwable throwable) {
            throw new JspEmitException(MessageFormat.format(msgs.getString("emit_error"), this.htmlTag, throwable.getMessage()));
        }
    }

    public void emitTagEnd(JspEmitState jspEmitState) throws JspEmitException {
        try {
            this.emitEnd(jspEmitState);
            return;
        }
        catch (Throwable throwable) {
            throw new JspEmitException(MessageFormat.format(msgs.getString("emit_end_error"), this.htmlTag, throwable.getMessage()));
        }
    }

    public OpenJspAVInfo getAV(int n) {
        if (this.avInfo == null) {
            this.getAVInfo();
        }
        if (n < 0 || n >= this.avInfo.length) {
            return null;
        }
        return this.avInfo[n];
    }

    public OpenJspAVInfo findAV(String string) {
        if (this.avInfo == null) {
            this.getAVInfo();
        }
        int n = 0;
        while (n < this.avInfo.length) {
            if (this.avInfo[n].desc.name.equals(string)) {
                return this.avInfo[n];
            }
            ++n;
        }
        return null;
    }

    public OpenJspAVDesc[] getAVDescriptions() {
        return null;
    }

    public OpenJspDefineItem[] getDefinedObjects() {
        return null;
    }

    public OpenJspDefineItem[] getDefinedAfterObjects() {
        return null;
    }

    public String validateAttributeList(JspParseState jspParseState, OpenJspAVInfo[] openJspAVInfoArray) {
        return null;
    }

    public void validateTextBody(JspParseState jspParseState, String string) throws JspParseException {
    }

    public String[] getSubTags() {
        return null;
    }

    public void emitStart(JspEmitState jspEmitState) {
    }

    public void emitEnd(JspEmitState jspEmitState) {
    }
}

