/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.parse;

import java.io.PrintStream;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.Vector;
import oracle.jsp.parse.JspBeanInfo;
import oracle.jsp.parse.JspBeanMethodInfo;
import oracle.jsp.parse.JspBeanPropertyInfo;
import oracle.jsp.parse.JspParseException;
import oracle.jsp.parse.JspParseState;

class OpenJspBeanExpression {
    private static final String MSG_FILE = "oracle.jsp.parse.LocalStrings";
    private static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.parse.LocalStrings");
    private JspParseState parseState;
    private String expression;
    public JspBeanPropertyInfo expressionType;
    private static final int PLAIN = 0;
    private static final int MULTIVALUE = 1;

    public OpenJspBeanExpression(JspParseState jspParseState) {
        this.parseState = jspParseState;
    }

    public OpenJspBeanExpression(JspParseState jspParseState, String string) {
        this.expression = string;
        this.parseState = jspParseState;
    }

    private int findQuoteEnd(String string, int n) {
        int n2 = string.length();
        ++n;
        while (n != -1 && n < n2) {
            char c = string.charAt(n);
            if (c == '\"') {
                return n + 1;
            }
            if (c == '\\') {
                n += 2;
                continue;
            }
            ++n;
        }
        return -1;
    }

    private int findParenEnd(String string, int n, ParamCount paramCount) {
        int n2 = string.length();
        ++n;
        while (n < n2 && Character.isWhitespace(string.charAt(n))) {
            ++n;
        }
        if (n >= n2) {
            return -1;
        }
        if (string.charAt(n) == ')') {
            return n + 1;
        }
        ++paramCount.count;
        while (n != -1 && n < n2) {
            char c = string.charAt(n);
            if (c == ')') {
                return n + 1;
            }
            if (c == '(') {
                n = this.findParenEnd(string, n, new ParamCount());
                continue;
            }
            if (c == '\"') {
                n = this.findQuoteEnd(string, n);
                continue;
            }
            if (c == ',') {
                ++paramCount.count;
            }
            ++n;
        }
        return -1;
    }

    private int findBracketEnd(String string, int n) {
        int n2 = string.length();
        ++n;
        while (n != -1 && n < n2) {
            char c = string.charAt(n);
            if (c == ']') {
                return n + 1;
            }
            if (c == '[') {
                n = this.findBracketEnd(string, n);
                continue;
            }
            if (c == '\"') {
                n = this.findQuoteEnd(string, n);
                continue;
            }
            ++n;
        }
        return -1;
    }

    private String getToken(String string, TokenPosition tokenPosition) throws JspParseException {
        int n = string.length();
        if (tokenPosition.start >= n) {
            throw new JspParseException(this.parseState, MessageFormat.format(msgs.getString("bad_expr_end"), string));
        }
        tokenPosition.end = tokenPosition.start;
        char c = string.charAt(tokenPosition.start);
        if (!Character.isJavaIdentifierStart(c)) {
            throw new JspParseException(this.parseState, MessageFormat.format(msgs.getString("bad_char_in_expr"), string.substring(0, tokenPosition.start)));
        }
        ++tokenPosition.end;
        while (tokenPosition.end < n) {
            c = string.charAt(tokenPosition.end);
            if (!Character.isJavaIdentifierPart(c)) break;
            ++tokenPosition.end;
        }
        if (tokenPosition.end < n) {
            return string.substring(tokenPosition.start, tokenPosition.end);
        }
        return string.substring(tokenPosition.start);
    }

    /*
     * Unable to fully structure code
     */
    public int parseExpression(String var1_1, boolean var2_2, Vector var3_3) throws JspParseException {
        var4_4 = new TokenPosition();
        var6_5 = null;
        if (var1_1.length() == 0) {
            throw new JspParseException(this.parseState, OpenJspBeanExpression.msgs.getString("need_expr"));
        }
        if (Character.isJavaIdentifierStart(var1_1.charAt(0))) ** GOTO lbl45
        throw new JspParseException(this.parseState, MessageFormat.format(OpenJspBeanExpression.msgs.getString("bad_expr_start"), new Object[]{var1_1}));
lbl-1000:
        // 1 sources

        {
            block12: {
                block13: {
                    block11: {
                        if (var4_4.start == 0 || var1_1.charAt(var4_4.start) != '(') break block11;
                        var4_4.end = this.scanMultivalue(var1_1, var4_4.start, "", var3_3);
                        var6_5 = (ExprPiece)var3_3.lastElement();
                        break block12;
                    }
                    if (var4_4.start > 0) {
                        if (var1_1.charAt(var4_4.start) != '.') {
                            throw new JspParseException(this.parseState, MessageFormat.format(OpenJspBeanExpression.msgs.getString("need_dot"), new Object[]{new Character(var1_1.charAt(var4_4.start))}));
                        }
                        var4_4.end = ++var4_4.start;
                    }
                    var5_6 = this.getToken(var1_1, var4_4);
                    if (var4_4.end >= var1_1.length()) break block13;
                    var7_7 = var1_1.charAt(var4_4.end);
                    if (var7_7 != '[' && var7_7 != '(' && var7_7 != '.' && var7_7 != ']') {
                        throw new JspParseException(this.parseState, MessageFormat.format(OpenJspBeanExpression.msgs.getString("bad_char_in_expr"), new Object[]{new Character(var7_7)}));
                    }
                    if (var7_7 != ']') ** GOTO lbl27
                    if (var2_2) {
                        var6_5 = new ExprPiece(0, var5_6);
                        var3_3.addElement(var6_5);
                    } else {
                        throw new JspParseException(this.parseState, MessageFormat.format(OpenJspBeanExpression.msgs.getString("bad_char_in_expr"), new Object[]{new Character(var7_7)}));
lbl27:
                        // 1 sources

                        if (var7_7 == '[' || var7_7 == '.') {
                            var6_5 = new ExprPiece(0, var5_6);
                            var3_3.addElement(var6_5);
                            if (var7_7 == '[') {
                                var4_4.end = var8_8 = this.scanDimensions(var1_1, var4_4.end, var6_5);
                            }
                        } else {
                            var4_4.end = this.scanMultivalue(var1_1, var4_4.end, var5_6, var3_3);
                            var6_5 = (ExprPiece)var3_3.lastElement();
                        }
                    }
                    break block12;
                }
                var6_5 = new ExprPiece(0, var5_6);
                var3_3.addElement(var6_5);
            }
            if (var2_2 && var4_4.end < var1_1.length() && var1_1.charAt(var4_4.end) == ']' || !var2_2 && var4_4.end == var1_1.length()) {
                var6_5.isLast = true;
                this.printExpression(var1_1, var3_3);
                return var4_4.end;
            }
            var4_4.start = var4_4.end;
lbl45:
            // 2 sources

            ** while (var4_4.start < var1_1.length())
        }
lbl46:
        // 1 sources

        throw new JspParseException(this.parseState, MessageFormat.format(OpenJspBeanExpression.msgs.getString("bad_expr_end"), new Object[]{var1_1}));
    }

    private void printExpression(String string, Vector vector) throws JspParseException {
        int n = vector.size();
        this.parseState.dbgPrintln("-------------------------");
        this.parseState.dbgPrintln("Expression: " + string);
        int n2 = 0;
        while (n2 < n) {
            ExprPiece exprPiece = (ExprPiece)vector.elementAt(n2);
            this.parseState.dbgPrint("Expresison #" + Integer.toString(n2) + " ");
            if (exprPiece.type == 0) {
                this.parseState.dbgPrintln("PLAIN");
            } else {
                this.parseState.dbgPrintln("MULTIVALUE");
            }
            this.parseState.dbgPrintln("\tReference: " + exprPiece.reference);
            if (exprPiece.params != null) {
                this.parseState.dbgPrintln("\tParams: " + exprPiece.params);
            }
            this.parseState.dbgPrintln("\tParam count: " + Integer.toString(exprPiece.paramCount));
            if (exprPiece.dimensionData != null) {
                this.parseState.dbgPrintln("\tDimensionsData: " + exprPiece.dimensionData);
            }
            this.parseState.dbgPrintln("\tDimensions: " + Integer.toString(exprPiece.dimensions));
            if (exprPiece.isLast) {
                this.parseState.dbgPrintln("\tisLast: TRUE");
            } else {
                this.parseState.dbgPrintln("\tisLast: FALSE");
            }
            ++n2;
        }
        this.parseState.dbgPrintln("-------------------------");
    }

    private void printExpression(PrintStream printStream, String string, Vector vector) throws JspParseException {
        int n = vector.size();
        printStream.println("-------------------------");
        printStream.println("Expression: " + string);
        int n2 = 0;
        while (n2 < n) {
            ExprPiece exprPiece = (ExprPiece)vector.elementAt(n2);
            printStream.print("Expression #" + Integer.toString(n2) + " ");
            if (exprPiece.type == 0) {
                printStream.println("PLAIN");
            } else {
                printStream.println("MULTIVALUE");
            }
            printStream.println("\tReference: " + exprPiece.reference);
            printStream.println("\tExpression: " + exprPiece.expression);
            if (exprPiece.params != null) {
                printStream.println("\tParams: " + exprPiece.params);
            }
            printStream.println("\tParam count: " + Integer.toString(exprPiece.paramCount));
            if (exprPiece.dimensionData != null) {
                printStream.println("\tDimensionsData: " + exprPiece.dimensionData);
            }
            printStream.println("\tDimensions: " + Integer.toString(exprPiece.dimensions));
            if (exprPiece.isLast) {
                printStream.println("\tisLast: TRUE");
            } else {
                printStream.println("\tisLast: FALSE");
            }
            ++n2;
        }
        printStream.println("-------------------------");
    }

    private int scanDimensions(String string, int n, ExprPiece exprPiece) throws JspParseException {
        int n2 = 0;
        int n3 = n;
        while (n < string.length() && string.charAt(n) == '[') {
            ++n2;
            if ((n = this.findBracketEnd(string, n)) != -1) continue;
            throw new JspParseException(this.parseState, MessageFormat.format(msgs.getString("need_bracket_in_expr"), string));
        }
        exprPiece.dimensions = n2;
        exprPiece.dimensionData = string.substring(n3, n);
        return n;
    }

    private int scanMultivalue(String string, int n, String string2, Vector vector) throws JspParseException {
        ParamCount paramCount = new ParamCount();
        paramCount.count = 0;
        int n2 = this.findParenEnd(string, n, paramCount);
        if (n2 == -1) {
            throw new JspParseException(this.parseState, MessageFormat.format(msgs.getString("need_paren_in_expr"), string));
        }
        ExprPiece exprPiece = new ExprPiece(1, string2);
        exprPiece.params = string.substring(n, n2);
        exprPiece.paramCount = paramCount.count;
        vector.addElement(exprPiece);
        if (n2 < string.length() && string.charAt(n2) == '[') {
            n2 = this.scanDimensions(string, n2, exprPiece);
        }
        return n2;
    }

    private JspBeanPropertyInfo evaluateMethodToken(JspBeanInfo jspBeanInfo, ExprPiece exprPiece) throws JspParseException {
        JspBeanPropertyInfo jspBeanPropertyInfo = null;
        JspBeanInfo jspBeanInfo2 = jspBeanInfo == null ? this.parseState.getThisBean() : jspBeanInfo;
        if (exprPiece.params == null) {
            throw new JspParseException(this.parseState, MessageFormat.format(msgs.getString("need_param_in_method"), exprPiece.reference));
        }
        if (exprPiece.dimensions > 0) {
            throw new JspParseException(this.parseState, MessageFormat.format(msgs.getString("bad_array_in_method"), exprPiece.reference));
        }
        if (exprPiece.reference.length() == 0) {
            throw new JspParseException(this.parseState, msgs.getString("no_method_name"));
        }
        Method method = jspBeanInfo2.findMethodByName(exprPiece.reference);
        if (method != null) {
            Class<?> clazz = method.getReturnType();
            if (!clazz.equals(Void.TYPE)) {
                throw new JspParseException(this.parseState, MessageFormat.format(msgs.getString("non_void_method"), exprPiece.reference));
            }
            jspBeanPropertyInfo = new JspBeanMethodInfo(method, clazz);
            if (exprPiece.params == null) {
                throw new JspParseException(this.parseState, MessageFormat.format(msgs.getString("need_param_in_method"), exprPiece.reference));
            }
        } else {
            jspBeanPropertyInfo = jspBeanInfo2.getDefaultGetProperty(this.parseState.beans, true);
            if (jspBeanPropertyInfo != null && !jspBeanPropertyInfo.type.isPrimitive() && !jspBeanPropertyInfo.type.isArray()) {
                JspBeanInfo jspBeanInfo3 = new JspBeanInfo(jspBeanPropertyInfo.getName(), jspBeanPropertyInfo.type);
                JspBeanPropertyInfo jspBeanPropertyInfo2 = this.evaluateMethodToken(jspBeanInfo3, exprPiece);
                if (exprPiece.expression == null) {
                    exprPiece.expression = "";
                }
                exprPiece.expression = jspBeanPropertyInfo.isMethod() ? String.valueOf(jspBeanPropertyInfo.getName()) + "()." + exprPiece.expression : String.valueOf(jspBeanPropertyInfo.getName()) + "." + exprPiece.expression;
                return jspBeanPropertyInfo2;
            }
        }
        if (jspBeanPropertyInfo == null) {
            throw new JspParseException(this.parseState, MessageFormat.format(msgs.getString("no_method"), exprPiece.reference));
        }
        exprPiece.reference = jspBeanPropertyInfo.getName();
        return jspBeanPropertyInfo;
    }

    private JspBeanPropertyInfo evaluateSetToken(JspBeanInfo jspBeanInfo, ExprPiece exprPiece) throws JspParseException {
        JspBeanInfo jspBeanInfo2;
        JspBeanPropertyInfo jspBeanPropertyInfo = null;
        if (jspBeanInfo == null) {
            jspBeanInfo2 = this.parseState.beans.getBeanInfo(exprPiece.reference);
            if (jspBeanInfo2 == null) {
                jspBeanInfo2 = this.parseState.getThisBean();
            } else {
                exprPiece.expression = String.valueOf(exprPiece.reference) + ".";
                exprPiece.reference = "";
                jspBeanPropertyInfo = null;
            }
        } else {
            jspBeanInfo2 = jspBeanInfo;
        }
        if (jspBeanPropertyInfo == null) {
            if (exprPiece.reference.length() == 0) {
                jspBeanPropertyInfo = jspBeanInfo2.getDefaultSetProperty(this.parseState.beans, true);
            } else {
                jspBeanPropertyInfo = jspBeanInfo2.getSetProperty(exprPiece.reference, true);
                if (jspBeanPropertyInfo == null) {
                    jspBeanPropertyInfo = jspBeanInfo2.getDefaultGetProperty(this.parseState.beans, true);
                    if (jspBeanPropertyInfo != null && !jspBeanPropertyInfo.type.isPrimitive() && !jspBeanPropertyInfo.type.isArray()) {
                        JspBeanInfo jspBeanInfo3 = new JspBeanInfo(jspBeanPropertyInfo.getName(), jspBeanPropertyInfo.type);
                        JspBeanPropertyInfo jspBeanPropertyInfo2 = this.evaluateSetToken(jspBeanInfo3, exprPiece);
                        if (exprPiece.expression == null) {
                            exprPiece.expression = "";
                        }
                        exprPiece.expression = jspBeanPropertyInfo.isMethod() ? String.valueOf(jspBeanPropertyInfo.getName()) + "()." + exprPiece.expression : String.valueOf(jspBeanPropertyInfo.getName()) + "." + exprPiece.expression;
                        return jspBeanPropertyInfo2;
                    }
                    jspBeanPropertyInfo = null;
                }
            }
        }
        if (jspBeanPropertyInfo == null) {
            if (exprPiece.reference.length() == 0) {
                throw new JspParseException(this.parseState, MessageFormat.format(msgs.getString("no_default_prop"), jspBeanInfo2.name));
            }
            throw new JspParseException(this.parseState, MessageFormat.format(msgs.getString("not_found"), exprPiece.reference));
        }
        if (exprPiece.params != null) {
            if (!jspBeanPropertyInfo.isMultiValue) {
                ExprPiece exprPiece2 = new ExprPiece(0, "");
                exprPiece2.params = exprPiece.params;
                exprPiece2.paramCount = exprPiece.paramCount;
                exprPiece2.dimensionData = exprPiece.dimensionData;
                exprPiece2.dimensions = exprPiece.dimensions;
                exprPiece2.isLast = exprPiece.isLast;
                if (jspBeanPropertyInfo.type.isPrimitive() || jspBeanPropertyInfo.type.isArray()) {
                    throw new JspParseException(this.parseState, MessageFormat.format(msgs.getString("need_mv_prop"), jspBeanPropertyInfo.getName()));
                }
                JspBeanInfo jspBeanInfo4 = new JspBeanInfo(jspBeanPropertyInfo.getName(), jspBeanPropertyInfo.type);
                JspBeanPropertyInfo jspBeanPropertyInfo3 = this.evaluateSetToken(jspBeanInfo4, exprPiece2);
                if (exprPiece.expression == null) {
                    exprPiece.expression = "";
                }
                exprPiece.expression = jspBeanPropertyInfo.isMethod() ? String.valueOf(jspBeanPropertyInfo.getName()) + "()." + exprPiece.expression : String.valueOf(jspBeanPropertyInfo.getName()) + "." + exprPiece.expression;
                return jspBeanPropertyInfo3;
            }
        } else {
            if (jspBeanPropertyInfo.isMultiValue) {
                throw new JspParseException(this.parseState, MessageFormat.format(msgs.getString("need_index_prop"), jspBeanPropertyInfo.getName()));
            }
            if (jspBeanPropertyInfo.isMethod()) {
                exprPiece.params = "()";
            }
        }
        exprPiece.reference = jspBeanPropertyInfo.getName();
        if (exprPiece.dimensions > 0) {
            int n = 0;
            Class<?> clazz = jspBeanPropertyInfo.type;
            while (clazz.isArray()) {
                ++n;
                clazz = clazz.getComponentType();
            }
            if (n != exprPiece.dimensions) {
                throw new JspParseException(this.parseState, MessageFormat.format(msgs.getString("bad_array_dim"), exprPiece.reference));
            }
        }
        return jspBeanPropertyInfo;
    }

    private JspBeanPropertyInfo evaluateGetToken(JspBeanInfo jspBeanInfo, ExprPiece exprPiece) throws JspParseException {
        Class<?> clazz;
        Object object;
        JspBeanInfo jspBeanInfo2;
        JspBeanPropertyInfo jspBeanPropertyInfo = null;
        if (jspBeanInfo == null) {
            jspBeanInfo2 = this.parseState.beans.getBeanInfo(exprPiece.reference);
            if (jspBeanInfo2 == null) {
                jspBeanInfo2 = this.parseState.getThisBean();
            } else {
                jspBeanPropertyInfo = new JspBeanPropertyInfo(exprPiece.reference, jspBeanInfo2.bean);
            }
        } else {
            jspBeanInfo2 = jspBeanInfo;
        }
        if (jspBeanPropertyInfo == null) {
            if (exprPiece.reference.length() == 0) {
                jspBeanPropertyInfo = jspBeanInfo2.getDefaultGetProperty(this.parseState.beans, true);
            } else {
                object = jspBeanInfo2.findMethodByName(exprPiece.reference);
                if (object != null) {
                    clazz = ((Method)object).getReturnType();
                    if (clazz.equals(Void.TYPE)) {
                        throw new JspParseException(this.parseState, MessageFormat.format(msgs.getString("void_method"), exprPiece.reference));
                    }
                    jspBeanPropertyInfo = new JspBeanMethodInfo((Method)object, (Class)clazz);
                    if (exprPiece.params == null) {
                        throw new JspParseException(this.parseState, MessageFormat.format(msgs.getString("need_param_in_method"), exprPiece.reference));
                    }
                } else {
                    jspBeanPropertyInfo = jspBeanInfo2.getGetProperty(exprPiece.reference, true);
                    if (jspBeanPropertyInfo == null) {
                        jspBeanPropertyInfo = jspBeanInfo2.getDefaultGetProperty(this.parseState.beans, true);
                        if (jspBeanPropertyInfo != null && !jspBeanPropertyInfo.type.isPrimitive() && !jspBeanPropertyInfo.type.isArray()) {
                            JspBeanInfo jspBeanInfo3 = new JspBeanInfo(jspBeanPropertyInfo.getName(), jspBeanPropertyInfo.type);
                            JspBeanPropertyInfo jspBeanPropertyInfo2 = this.evaluateGetToken(jspBeanInfo3, exprPiece);
                            if (exprPiece.expression == null) {
                                exprPiece.expression = "";
                            }
                            exprPiece.expression = jspBeanPropertyInfo.isMethod() ? String.valueOf(jspBeanPropertyInfo.getName()) + "()." + exprPiece.expression : String.valueOf(jspBeanPropertyInfo.getName()) + "." + exprPiece.expression;
                            return jspBeanPropertyInfo2;
                        }
                        jspBeanPropertyInfo = null;
                    }
                }
            }
        }
        if (jspBeanPropertyInfo == null) {
            if (exprPiece.reference.length() == 0) {
                throw new JspParseException(this.parseState, MessageFormat.format(msgs.getString("no_default_prop"), jspBeanInfo2.name));
            }
            throw new JspParseException(this.parseState, MessageFormat.format(msgs.getString("not_found"), exprPiece.reference));
        }
        if (exprPiece.params != null) {
            if (!jspBeanPropertyInfo.isMultiValue) {
                if (exprPiece.expression == null) {
                    exprPiece.expression = "";
                }
                if (jspBeanPropertyInfo.type.isPrimitive() || jspBeanPropertyInfo.type.isArray()) {
                    throw new JspParseException(this.parseState, MessageFormat.format(msgs.getString("need_mv_prop"), jspBeanPropertyInfo.getName()));
                }
                object = new JspBeanInfo(jspBeanPropertyInfo.getName(), jspBeanPropertyInfo.type);
                exprPiece.reference = "";
                clazz = this.evaluateGetToken((JspBeanInfo)object, exprPiece);
                exprPiece.expression = jspBeanPropertyInfo.isMethod() ? String.valueOf(exprPiece.expression) + jspBeanPropertyInfo.getName() + "()." : String.valueOf(exprPiece.expression) + jspBeanPropertyInfo.getName() + ".";
                return clazz;
            }
        } else {
            if (jspBeanPropertyInfo.isMultiValue) {
                throw new JspParseException(this.parseState, MessageFormat.format(msgs.getString("need_index_prop"), jspBeanPropertyInfo.getName()));
            }
            if (jspBeanPropertyInfo.isMethod()) {
                exprPiece.params = "()";
            }
        }
        exprPiece.reference = jspBeanPropertyInfo.getName();
        if (exprPiece.dimensions > 0) {
            int n = 0;
            clazz = jspBeanPropertyInfo.type;
            while (clazz.isArray()) {
                ++n;
                clazz = clazz.getComponentType();
            }
            if (n != exprPiece.dimensions) {
                throw new JspParseException(this.parseState, MessageFormat.format(msgs.getString("bad_array_dim"), exprPiece.reference));
            }
        }
        return jspBeanPropertyInfo;
    }

    JspBeanInfo removeThis(Vector vector) {
        ExprPiece exprPiece = (ExprPiece)vector.elementAt(0);
        if (exprPiece.reference.equals("this")) {
            vector.removeElementAt(0);
            return this.parseState.getThisBean();
        }
        return null;
    }

    private String evaluateGetExpression(Vector vector, JspBeanInfo jspBeanInfo) throws JspParseException {
        ExprPiece exprPiece;
        int n;
        JspBeanPropertyInfo jspBeanPropertyInfo = null;
        JspBeanInfo jspBeanInfo2 = jspBeanInfo;
        jspBeanInfo = this.removeThis(vector);
        if (jspBeanInfo != null) {
            jspBeanInfo2 = jspBeanInfo;
        }
        if ((n = vector.size()) == 1 && jspBeanInfo2 == null) {
            exprPiece = (ExprPiece)vector.elementAt(0);
            if (exprPiece.isLast && exprPiece.params == null && exprPiece.reference != null && (jspBeanInfo2 = this.parseState.beans.getBeanInfo(exprPiece.reference)) != null) {
                ExprPiece exprPiece2 = new ExprPiece(0, "");
                exprPiece2.dimensions = exprPiece.dimensions;
                exprPiece2.dimensionData = exprPiece.dimensionData;
                exprPiece2.isLast = true;
                exprPiece.isLast = false;
                exprPiece.dimensionData = null;
                exprPiece.dimensions = 0;
                vector.addElement(exprPiece2);
                n = 2;
                jspBeanInfo2 = null;
            }
        }
        int n2 = 0;
        while (n2 < n) {
            exprPiece = (ExprPiece)vector.elementAt(n2);
            jspBeanPropertyInfo = this.evaluateGetToken(jspBeanInfo2, exprPiece);
            if (!exprPiece.isLast) {
                Class<?> clazz = jspBeanPropertyInfo.type;
                if (clazz.isArray()) {
                    if (exprPiece.dimensions > 0) {
                        while (clazz.isArray()) {
                            clazz = clazz.getComponentType();
                        }
                    } else {
                        throw new JspParseException(this.parseState, MessageFormat.format(msgs.getString("bad_array_in_expr"), jspBeanPropertyInfo.getName()));
                    }
                }
                if (jspBeanPropertyInfo.type.isPrimitive()) {
                    throw new JspParseException(this.parseState, MessageFormat.format(msgs.getString("bad_prim_in_expr"), jspBeanPropertyInfo.getName()));
                }
                jspBeanInfo2 = new JspBeanInfo(jspBeanPropertyInfo.getName(), clazz);
            }
            ++n2;
        }
        this.expressionType = jspBeanPropertyInfo;
        String string = "";
        int n3 = 0;
        while (n3 < n) {
            exprPiece = (ExprPiece)vector.elementAt(n3);
            if (exprPiece.expression != null) {
                string = string.concat(exprPiece.expression);
            }
            if (exprPiece.reference != null) {
                string = string.concat(exprPiece.reference);
            }
            if (exprPiece.params != null) {
                string = string.concat(exprPiece.params);
            }
            if (exprPiece.dimensionData != null) {
                string = string.concat(exprPiece.dimensionData);
            }
            if (!exprPiece.isLast) {
                string = string.concat(".");
            }
            ++n3;
        }
        return string;
    }

    private String evaluateSetExpression(Vector vector) throws JspParseException {
        JspBeanPropertyInfo jspBeanPropertyInfo;
        JspBeanInfo jspBeanInfo = this.removeThis(vector);
        ExprPiece exprPiece = (ExprPiece)vector.lastElement();
        String string = "";
        if (vector.size() > 1) {
            vector.removeElementAt(vector.size() - 1);
            string = this.evaluateGetExpression(vector, jspBeanInfo);
            jspBeanPropertyInfo = this.expressionType;
            if (jspBeanPropertyInfo.type.isPrimitive() || jspBeanPropertyInfo.type.isArray()) {
                throw new JspParseException(this.parseState, MessageFormat.format(msgs.getString("bad_prim_array_in_expr"), jspBeanPropertyInfo.getName()));
            }
            jspBeanInfo = new JspBeanInfo(jspBeanPropertyInfo.getName(), jspBeanPropertyInfo.type);
        }
        jspBeanPropertyInfo = this.evaluateSetToken(jspBeanInfo, exprPiece);
        if (exprPiece.expression != null) {
            string = string.concat(exprPiece.expression);
        }
        if (exprPiece.reference != null) {
            string = string.concat(exprPiece.reference);
        }
        if (exprPiece.params != null) {
            string = string.concat(exprPiece.params);
        }
        if (exprPiece.dimensionData != null) {
            string = string.concat(exprPiece.dimensionData);
        }
        if (jspBeanPropertyInfo.isMethod()) {
            int n = string.lastIndexOf(41);
            if (n != -1) {
                if (jspBeanPropertyInfo.isMultiValue) {
                    string = String.valueOf(string.substring(0, n)) + ", ";
                } else {
                    n = string.lastIndexOf(40);
                    if (n != -1) {
                        string = String.valueOf(string.substring(0, n)) + "( ";
                    }
                }
            }
        } else {
            string = string.concat(" = ");
        }
        this.expressionType = jspBeanPropertyInfo;
        return string;
    }

    private String evaluateMethodExpression(Vector vector) throws JspParseException {
        JspBeanPropertyInfo jspBeanPropertyInfo;
        JspBeanInfo jspBeanInfo = this.removeThis(vector);
        ExprPiece exprPiece = (ExprPiece)vector.lastElement();
        String string = "";
        if (vector.size() > 1) {
            vector.removeElementAt(vector.size() - 1);
            string = this.evaluateGetExpression(vector, jspBeanInfo);
            jspBeanPropertyInfo = this.expressionType;
            if (jspBeanPropertyInfo.type.isPrimitive() || jspBeanPropertyInfo.type.isArray()) {
                throw new JspParseException(this.parseState, MessageFormat.format(msgs.getString("bad_prim_array_in_expr"), jspBeanPropertyInfo.getName()));
            }
            jspBeanInfo = new JspBeanInfo(jspBeanPropertyInfo.getName(), jspBeanPropertyInfo.type);
        }
        jspBeanPropertyInfo = this.evaluateMethodToken(jspBeanInfo, exprPiece);
        if (exprPiece.expression != null) {
            string = string.concat(exprPiece.expression);
        }
        if (exprPiece.reference != null) {
            string = string.concat(exprPiece.reference);
        }
        if (exprPiece.params != null) {
            string = string.concat(exprPiece.params);
        }
        if (exprPiece.dimensionData != null) {
            string = string.concat(exprPiece.dimensionData);
        }
        this.expressionType = jspBeanPropertyInfo;
        return string;
    }

    public String translateJavaGetExpression(String string) throws JspParseException {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c == '\"') {
                if ((n2 = this.findQuoteEnd(string, n2)) == -1) {
                    throw new JspParseException(this.parseState, MessageFormat.format(msgs.getString("bad_bslash_in_expr"), string));
                }
            } else if (c == '$' && n2 + 1 < n && string.charAt(n2 + 1) == '[') {
                if (n2 + 2 >= n) {
                    throw new JspParseException(this.parseState, MessageFormat.format(msgs.getString("bad_expr_end_after_$"), string));
                }
                Vector vector = new Vector();
                int n3 = this.parseExpression(string.substring(n2 + 2), true, vector);
                String string2 = this.evaluateGetExpression(vector, null);
                String string3 = String.valueOf(string.substring(0, n2)) + string2;
                string = n2 + 3 + n3 < n ? String.valueOf(string3) + string.substring(n2 + 3 + n3) : string3;
                n2 = string3.length();
                n = string.length();
            }
            ++n2;
        }
        this.expressionType = null;
        return string;
    }

    public String translateGetReference(String string) throws JspParseException {
        Vector vector = new Vector();
        this.parseExpression(string, false, vector);
        String string2 = this.evaluateGetExpression(vector, null);
        return string2;
    }

    public String translateSetReference(String string) throws JspParseException {
        Vector vector = new Vector();
        this.parseExpression(string, false, vector);
        String string2 = this.evaluateSetExpression(vector);
        return string2;
    }

    public String translateMethodReference(String string) throws JspParseException {
        Vector vector = new Vector();
        this.parseExpression(string, false, vector);
        String string2 = this.evaluateMethodExpression(vector);
        return string2;
    }

    private class ParamCount {
        public int count = 0;

        public ParamCount() {
            OpenJspBeanExpression.this = OpenJspBeanExpression.this;
        }
    }

    private class TokenPosition {
        public int start = 0;
        public int end = 0;

        public TokenPosition() {
            OpenJspBeanExpression.this = OpenJspBeanExpression.this;
        }
    }

    public class ExprPiece {
        public String reference;
        public int type;
        public String params;
        public int paramCount;
        public String dimensionData;
        public int dimensions;
        public boolean isLast;
        public String expression;

        public ExprPiece(int n, String string) {
            OpenJspBeanExpression.this = OpenJspBeanExpression.this;
            this.reference = string;
            this.type = n;
            this.isLast = false;
        }
    }
}

