/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.parse;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import oracle.jsp.parse.JspParseException;
import oracle.jsp.parse.JspParseState;
import oracle.jsp.parse.JspParseTag;
import oracle.jsp.parse.JspUtils;
import oracle.jsp.parse.OpenJspAVDesc;
import oracle.jsp.parse.OpenJspBeanExpression;

public class OpenJspAVInfo {
    private static final String MSG_FILE = "oracle.jsp.parse.LocalStrings";
    private static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.parse.LocalStrings");
    public OpenJspAVDesc desc;
    private String stringValue;
    private OpenJspBeanExpression expr;
    private Class valueClass;
    private boolean amExpression;

    public OpenJspAVInfo(OpenJspAVDesc openJspAVDesc) {
        this.desc = openJspAVDesc;
    }

    public boolean valueExists() {
        return this.stringValue != null;
    }

    public String getQuotedValue() {
        return "\"" + JspParseTag.sanitizeQuotedString(this.stringValue) + "\"";
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public void setStringValue(String string) {
        this.stringValue = string;
    }

    public String getExpression() {
        return this.stringValue;
    }

    public Class getValueType() {
        return this.valueClass;
    }

    public boolean isExpression() {
        return this.amExpression;
    }

    private String removeJavaExpressionSyntax(String string) {
        if (string.startsWith("<%=") && string.endsWith("%>")) {
            if (string.length() > 5) {
                return string.substring(3, string.length() - 2);
            }
            return "";
        }
        return string;
    }

    private String removePropertyReferenceSyntax(String string) {
        if (string.startsWith("$[") && string.endsWith("]")) {
            if (string.length() > 3) {
                return string.substring(2, string.length() - 1);
            }
            return "";
        }
        return string;
    }

    private String removeGetExpressionSyntax(String string) {
        if (string.startsWith("<%=") && string.endsWith("%>")) {
            if (string.length() > 5) {
                return string.substring(3, string.length() - 2);
            }
            return "";
        }
        if (string.startsWith("$") && !string.startsWith("$[")) {
            return string.substring(1);
        }
        return string;
    }

    public static String decodeEscapes(String string) {
        int n = string.indexOf("<\\%");
        while (n != -1) {
            string = String.valueOf(string.substring(0, n + 1)) + string.substring(n + 2);
            n = string.indexOf("<\\%", n + 1);
        }
        n = string.indexOf("%\\>");
        while (n != -1) {
            string = String.valueOf(string.substring(0, n + 1)) + string.substring(n + 2);
            n = string.indexOf("%\\>", n + 1);
        }
        return string;
    }

    public void setValue(JspParseState jspParseState, String string) throws JspParseException {
        this.stringValue = this.desc.caseSens ? string : string.toLowerCase();
        switch (this.desc.type) {
            case 1: {
                if (this.stringValue.startsWith("\\$")) {
                    this.stringValue = this.stringValue.substring(1);
                }
                this.stringValue = OpenJspAVInfo.decodeEscapes(this.stringValue);
                if (this.desc.validValues != null && this.desc.validValues.length > 0) {
                    int n = 0;
                    while (n < this.desc.validValues.length) {
                        if (this.stringValue.equals(this.desc.validValues[n])) break;
                        ++n;
                    }
                    if (n == this.desc.validValues.length) {
                        throw new JspParseException(jspParseState, MessageFormat.format(msgs.getString("bad_attr_value"), string, this.desc.name));
                    }
                }
                return;
            }
            case 2: {
                if (JspUtils.isBoolean(string)) {
                    this.stringValue = string.toLowerCase().trim();
                    return;
                }
                throw new JspParseException(jspParseState, MessageFormat.format(msgs.getString("bad_bool_attr"), this.desc.name, string));
            }
            case 3: {
                this.stringValue = string.trim();
                if (this.stringValue.charAt(0) == '-' ? JspUtils.allNumbers(this.stringValue.substring(1).trim()) : JspUtils.allNumbers(this.stringValue)) {
                    return;
                }
                throw new JspParseException(jspParseState, MessageFormat.format(msgs.getString("bad_num_attr"), this.desc.name));
            }
            case 4: {
                if (this.desc.validValues != null && this.desc.validValues.length > 0) {
                    int n = 0;
                    while (n < this.desc.validValues.length) {
                        if (string.equals(this.desc.validValues[n])) {
                            return;
                        }
                        ++n;
                    }
                }
                this.stringValue = string.trim();
                if (this.stringValue.length() == 0) {
                    throw new JspParseException(jspParseState, MessageFormat.format(msgs.getString("empty_value"), this.desc.name));
                }
                char c = this.stringValue.charAt(0);
                if (!Character.isJavaIdentifierStart(c)) {
                    throw new JspParseException(jspParseState, MessageFormat.format(msgs.getString("bad_id"), this.desc.name));
                }
                int n = this.stringValue.length();
                for (int i = 1; i < n; ++i) {
                    c = this.stringValue.charAt(i);
                    if (Character.isJavaIdentifierPart(c)) {
                        continue;
                    }
                    throw new JspParseException(jspParseState, MessageFormat.format(msgs.getString("bad_char"), new Character(c), this.desc.name));
                }
                return;
            }
            case 5: {
                this.amExpression = true;
                if (string.startsWith("\\$")) {
                    string = string.substring(1);
                }
                this.stringValue = this.removeJavaExpressionSyntax(string).trim();
                if (this.stringValue.length() == 0) {
                    throw new JspParseException(jspParseState, MessageFormat.format(msgs.getString("empty_attr_expr"), this.desc.name));
                }
                this.stringValue = OpenJspAVInfo.decodeEscapes(this.stringValue);
                return;
            }
            case 6: {
                if (this.stringValue.startsWith("\\$")) {
                    this.stringValue = this.stringValue.substring(1);
                }
                this.stringValue = OpenJspAVInfo.decodeEscapes(this.stringValue);
                return;
            }
            case 7: {
                this.amExpression = true;
                this.expr = new OpenJspBeanExpression(jspParseState);
                this.stringValue = this.removeGetExpressionSyntax(string).trim();
                this.stringValue = OpenJspAVInfo.decodeEscapes(this.stringValue);
                this.stringValue = this.expr.translateJavaGetExpression(this.stringValue);
                this.expr = null;
                return;
            }
            case 8: {
                this.amExpression = true;
                this.expr = new OpenJspBeanExpression(jspParseState);
                string = this.removePropertyReferenceSyntax(string);
                this.stringValue = this.expr.translateGetReference(OpenJspAVInfo.decodeEscapes(string.trim()));
                this.valueClass = this.expr.expressionType.type;
                return;
            }
            case 9: {
                this.amExpression = true;
                this.expr = new OpenJspBeanExpression(jspParseState);
                string = this.removePropertyReferenceSyntax(string);
                this.stringValue = this.expr.translateSetReference(OpenJspAVInfo.decodeEscapes(string.trim()));
                this.valueClass = this.expr.expressionType.type;
                return;
            }
            case 10: {
                this.amExpression = true;
                this.expr = new OpenJspBeanExpression(jspParseState);
                string = this.removePropertyReferenceSyntax(string);
                this.stringValue = this.expr.translateMethodReference(OpenJspAVInfo.decodeEscapes(string.trim()));
                this.valueClass = this.expr.expressionType.type;
                return;
            }
            case 11: {
                this.stringValue = string;
                if (this.stringValue.startsWith("<%=") && this.stringValue.endsWith("%>")) {
                    this.stringValue = this.stringValue.length() > 5 ? this.stringValue.substring(3, this.stringValue.length() - 2).trim() : "";
                    if (this.stringValue.length() == 0) {
                        throw new JspParseException(jspParseState, msgs.getString("empty_expr"));
                    }
                    this.amExpression = true;
                    this.stringValue = OpenJspAVInfo.decodeEscapes(this.stringValue);
                    return;
                }
                this.stringValue = "\"" + JspParseTag.sanitizeQuotedString(OpenJspAVInfo.decodeEscapes(this.stringValue)) + "\"";
                return;
            }
            case 12: {
                this.stringValue = string;
                if (this.stringValue.startsWith("<%=") && this.stringValue.endsWith("%>")) {
                    this.stringValue = this.stringValue.length() > 5 ? this.stringValue.substring(3, this.stringValue.length() - 2).trim() : "";
                    if (this.stringValue.length() == 0) {
                        throw new JspParseException(jspParseState, msgs.getString("empty_expr"));
                    }
                    this.expr = new OpenJspBeanExpression(jspParseState);
                    this.stringValue = this.expr.translateJavaGetExpression(OpenJspAVInfo.decodeEscapes(this.stringValue));
                    this.expr = null;
                    this.amExpression = true;
                    return;
                }
                if (this.stringValue.startsWith("$[")) {
                    this.expr = new OpenJspBeanExpression(jspParseState);
                    this.stringValue = this.expr.translateJavaGetExpression(OpenJspAVInfo.decodeEscapes(this.stringValue.trim()));
                    this.expr = null;
                    this.amExpression = true;
                    return;
                }
                if (this.stringValue.startsWith("$")) {
                    this.stringValue = this.stringValue.substring(1).trim();
                    if (this.stringValue.length() == 0) {
                        throw new JspParseException(jspParseState, msgs.getString("empty_expr"));
                    }
                    this.expr = new OpenJspBeanExpression(jspParseState);
                    this.stringValue = this.expr.translateJavaGetExpression(OpenJspAVInfo.decodeEscapes(this.stringValue));
                    this.expr = null;
                    this.amExpression = true;
                    return;
                }
                if (this.stringValue.startsWith("\\$")) {
                    this.stringValue = this.stringValue.substring(1);
                }
                this.stringValue = "\"" + JspParseTag.sanitizeQuotedString(OpenJspAVInfo.decodeEscapes(this.stringValue)) + "\"";
                return;
            }
        }
        throw new JspParseException(jspParseState, MessageFormat.format(msgs.getString("bad_attr_val_type"), this.desc.name));
    }
}

