/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.parse;

import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;
import oracle.jsp.parse.JspDirective;
import oracle.jsp.parse.JspEmitState;
import oracle.jsp.parse.JspParseState;
import oracle.jsp.parse.JspParseTag;
import oracle.jsp.util.JspUtil;

public class JspUtils {
    private static final String MSG_FILE = "oracle.jsp.parse.LocalStrings";
    private static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.parse.LocalStrings");
    static /* synthetic */ Class class$oracle$jsp$parse$JspParseTagText;
    static /* synthetic */ Class class$oracle$jsp$parse$OracleJsp2Java;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$String;

    public static boolean allNumbers(String string) {
        if (string == null) {
            return false;
        }
        if ((string = string.trim()).length() == 0) {
            return false;
        }
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c < '0' || c > '9') {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean translateBoolean(String string, boolean bl) {
        if (string == null) {
            return bl;
        }
        if ((string = string.trim()).equalsIgnoreCase("true")) {
            return true;
        }
        if (string.equalsIgnoreCase("false")) {
            return false;
        }
        return bl;
    }

    public static boolean isBoolean(String string) {
        if (string == null) {
            return false;
        }
        if ((string = string.trim()).equalsIgnoreCase("true")) {
            return true;
        }
        return string.equalsIgnoreCase("false");
    }

    public static boolean isTagWhitespace(JspParseTag jspParseTag) {
        if ((class$oracle$jsp$parse$JspParseTagText != null ? class$oracle$jsp$parse$JspParseTagText : (class$oracle$jsp$parse$JspParseTagText = JspUtils.class$("oracle.jsp.parse.JspParseTagText"))).isInstance(jspParseTag)) {
            String string = jspParseTag.toString();
            return (string = string.trim()).length() == 0;
        }
        return false;
    }

    public static String trimBeginningWhite(String string) {
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            if (!Character.isWhitespace(string.charAt(n))) {
                if (n > 0) {
                    return string.substring(n);
                }
                return string;
            }
            ++n;
        }
        return "";
    }

    public static String extractContentType(String string) {
        if (string == null || string.length() == 0) {
            return "text/html";
        }
        int n = string.indexOf(59);
        if (n != -1) {
            return string.substring(0, n);
        }
        return string;
    }

    public static String extractEncoding(String string) {
        int n;
        if (string != null && (n = string.indexOf(59)) != -1 && n + 1 < string.length()) {
            string = string.substring(n + 1);
            if ((string = string.trim()).startsWith("charset") && (string = string.substring(7).trim()).charAt(0) == '=' && (string = string.substring(1).trim()).length() > 0) {
                return string;
            }
        }
        return "ISO-8859-1";
    }

    public static Class loadClass(String string, JspParseState jspParseState) {
        if (System.getProperty("oracle.jserver.version") != null) {
            return JspUtils.loadClassServer(string, jspParseState);
        }
        return JspUtils.loadClassJDK(string, jspParseState);
    }

    private static Class loadClassJDK(String string, JspParseState jspParseState) {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
            if (clazz != null) {
                if (jspParseState != null) {
                    jspParseState.dbgPrintln(MessageFormat.format(msgs.getString("dbg_class_load"), string));
                    jspParseState.addBeanDependency(clazz.getName());
                }
                return clazz;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            clazz = null;
        }
        ClassLoader classLoader = (class$oracle$jsp$parse$OracleJsp2Java != null ? class$oracle$jsp$parse$OracleJsp2Java : (class$oracle$jsp$parse$OracleJsp2Java = JspUtils.class$("oracle.jsp.parse.OracleJsp2Java"))).getClassLoader();
        if (classLoader != null) {
            if (jspParseState != null) {
                jspParseState.dbgPrintln(MessageFormat.format(msgs.getString("dbg_try_class_load"), string));
            }
            try {
                clazz = classLoader.loadClass(string);
                if (clazz != null) {
                    if (jspParseState != null) {
                        jspParseState.dbgPrintln(MessageFormat.format(msgs.getString("dbg_class_loaded"), string));
                        jspParseState.addBeanDependency(clazz.getName());
                    }
                    return clazz;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                clazz = null;
            }
        }
        if (jspParseState != null && jspParseState.parms.classLoader != null) {
            jspParseState.dbgPrintln(MessageFormat.format(msgs.getString("dbg_try_class_load2"), string));
            try {
                clazz = jspParseState.parms.classLoader.loadClass(string);
                if (clazz != null) {
                    jspParseState.dbgPrintln(MessageFormat.format(msgs.getString("dbg_class_loaded2"), string));
                    jspParseState.addBeanDependency(clazz.getName());
                    return clazz;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                clazz = null;
            }
        }
        return null;
    }

    private static Class loadClassServer(String string, JspParseState jspParseState) {
        Class<?> clazz;
        if (jspParseState != null && jspParseState.parms.classLoader != null) {
            jspParseState.dbgPrintln(MessageFormat.format(msgs.getString("dbg_try_class_load2"), string));
            try {
                clazz = jspParseState.parms.classLoader.loadClass(string);
                if (clazz != null) {
                    jspParseState.dbgPrintln(MessageFormat.format(msgs.getString("dbg_class_loaded2"), string));
                    jspParseState.addBeanDependency(clazz.getName());
                    return clazz;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                clazz = null;
            }
        }
        try {
            clazz = Class.forName(string);
            if (clazz != null) {
                if (jspParseState != null) {
                    jspParseState.dbgPrintln(MessageFormat.format(msgs.getString("dbg_class_load"), string));
                    jspParseState.addBeanDependency(clazz.getName());
                }
                return clazz;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            clazz = null;
        }
        ClassLoader classLoader = (class$oracle$jsp$parse$OracleJsp2Java != null ? class$oracle$jsp$parse$OracleJsp2Java : (class$oracle$jsp$parse$OracleJsp2Java = JspUtils.class$("oracle.jsp.parse.OracleJsp2Java"))).getClassLoader();
        if (classLoader != null) {
            if (jspParseState != null) {
                jspParseState.dbgPrintln(MessageFormat.format(msgs.getString("dbg_try_class_load"), string));
            }
            try {
                clazz = classLoader.loadClass(string);
                if (clazz != null) {
                    if (jspParseState != null) {
                        jspParseState.dbgPrintln(MessageFormat.format(msgs.getString("dbg_class_loaded"), string));
                        jspParseState.addBeanDependency(clazz.getName());
                    }
                    return clazz;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                clazz = null;
            }
        }
        return null;
    }

    public static final Hashtable cloneDirectives(Hashtable hashtable) {
        if (hashtable == null) {
            return null;
        }
        Hashtable hashtable2 = new Hashtable();
        Enumeration enumeration = hashtable.keys();
        try {
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                JspDirective jspDirective = (JspDirective)hashtable.get(k);
                hashtable2.put(k, jspDirective.clone());
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
        return hashtable2;
    }

    public static Object convertConstant(String string, Class clazz) {
        try {
            String string2 = string.substring(1, string.length() - 1);
            if (clazz.equals(Boolean.TYPE) || clazz.equals(class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = JspUtils.class$("java.lang.Boolean")))) {
                return Boolean.valueOf(string2);
            }
            if (clazz.equals(Byte.TYPE) || clazz.equals(class$java$lang$Byte != null ? class$java$lang$Byte : (class$java$lang$Byte = JspUtils.class$("java.lang.Byte")))) {
                return Byte.valueOf(string2);
            }
            if (clazz.equals(Character.TYPE) || clazz.equals(class$java$lang$Character != null ? class$java$lang$Character : (class$java$lang$Character = JspUtils.class$("java.lang.Character")))) {
                if (string2.length() > 1) {
                    return null;
                }
                return new Character(string2.charAt(0));
            }
            if (clazz.equals(Double.TYPE) || clazz.equals(class$java$lang$Double != null ? class$java$lang$Double : (class$java$lang$Double = JspUtils.class$("java.lang.Double")))) {
                return Double.valueOf(string2);
            }
            if (clazz.equals(Integer.TYPE) || clazz.equals(class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = JspUtils.class$("java.lang.Integer")))) {
                return Integer.valueOf(string2);
            }
            if (clazz.equals(Float.TYPE) || clazz.equals(class$java$lang$Float != null ? class$java$lang$Float : (class$java$lang$Float = JspUtils.class$("java.lang.Float")))) {
                return Float.valueOf(string2);
            }
            if (clazz.equals(Long.TYPE) || clazz.equals(class$java$lang$Long != null ? class$java$lang$Long : (class$java$lang$Long = JspUtils.class$("java.lang.Long")))) {
                return Long.valueOf(string2);
            }
            if (clazz.equals(Short.TYPE) || clazz.equals(class$java$lang$Short != null ? class$java$lang$Short : (class$java$lang$Short = JspUtils.class$("java.lang.Short")))) {
                return Short.valueOf(string2);
            }
            if ((class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = JspUtils.class$("java.lang.String"))).isAssignableFrom(clazz)) {
                return string;
            }
            return null;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static String convertExpression(String string, Class clazz) {
        String string2 = clazz.equals(Integer.TYPE) ? "OracleJspRuntime.toInt( " + string + ")" : (clazz.equals(class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = JspUtils.class$("java.lang.Integer"))) ? "OracleJspRuntime.toIntObject( toInt( " + string + "))" : (clazz.equals(class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = JspUtils.class$("java.lang.String"))) ? "OracleJspRuntime.toStr( " + string + ")" : (clazz.equals(Boolean.TYPE) ? "OracleJspRuntime.toBoolean( " + string + ")" : (clazz.equals(class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = JspUtils.class$("java.lang.Boolean"))) ? "OracleJspRuntime.toBooleanObject( toBoolean( " + string + "))" : (clazz.equals(Byte.TYPE) ? "OracleJspRuntime.toByte( " + string + ")" : (clazz.equals(class$java$lang$Byte != null ? class$java$lang$Byte : (class$java$lang$Byte = JspUtils.class$("java.lang.Byte"))) ? "OracleJspRuntime.toByteObject( toByte( " + string + "))" : (clazz.equals(Character.TYPE) ? "OracleJspRuntime.toCharacter( " + string + ")" : (clazz.equals(class$java$lang$Character != null ? class$java$lang$Character : (class$java$lang$Character = JspUtils.class$("java.lang.Character"))) ? "OracleJspRuntime.toCharacterObject( toCharacter( " + string + "))" : (clazz.equals(Short.TYPE) ? "OracleJspRuntime.toShort( " + string + ")" : (clazz.equals(class$java$lang$Short != null ? class$java$lang$Short : (class$java$lang$Short = JspUtils.class$("java.lang.Short"))) ? "OracleJspRuntime.toShortObject( toShort( " + string + "))" : (clazz.equals(Double.TYPE) ? "OracleJspRuntime.toDouble( " + string + ")" : (clazz.equals(class$java$lang$Double != null ? class$java$lang$Double : (class$java$lang$Double = JspUtils.class$("java.lang.Double"))) ? "OracleJspRuntime.toDoubleObject( toDouble( " + string + "))" : (clazz.equals(Float.TYPE) ? "OracleJspRuntime.toFloat( " + string + ")" : (clazz.equals(class$java$lang$Float != null ? class$java$lang$Float : (class$java$lang$Float = JspUtils.class$("java.lang.Float"))) ? "OracleJspRuntime.toFloatObject( toFloat( " + string + "))" : (clazz.equals(Long.TYPE) ? "OracleJspRuntime.toLong( " + string + ")" : (clazz.equals(class$java$lang$Long != null ? class$java$lang$Long : (class$java$lang$Long = JspUtils.class$("java.lang.Long"))) ? "OracleJspRuntime.toLongObject( toLong( " + string + "))" : string))))))))))))))));
        return string2;
    }

    public static String getJmlClassFromType(String string) {
        string = string.trim();
        String string2 = (string = string.toLowerCase()).equals("string") ? "oracle.jsp.jml.JmlString" : (string.equals("boolean") ? "oracle.jsp.jml.JmlBoolean" : (string.equals("number") ? "oracle.jsp.jml.JmlNumber" : (string.equals("fpnumber") ? "oracle.jsp.jml.JmlFPNumber" : null)));
        return string2;
    }

    public static boolean valueIsQuoted(String string) {
        if (string.startsWith("\"") && string.endsWith("\"") && string.length() >= 2) {
            int n = 1;
            int n2 = string.length() - 1;
            while (n < n2) {
                if (string.charAt(n) == '\"') {
                    return false;
                }
                if (string.charAt(n) == '\\') {
                    ++n;
                }
                ++n;
            }
            return n == n2;
        }
        return false;
    }

    public static String decodeQuotes(String string) {
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = string.length();
        boolean bl = false;
        while (n < n2) {
            char c = string.charAt(n);
            if (!bl) {
                if (c == '\\') {
                    bl = true;
                } else {
                    stringBuffer.append(c);
                    bl = false;
                }
            } else {
                stringBuffer.append(c);
                bl = false;
            }
            ++n;
        }
        string = stringBuffer.toString();
        return string;
    }

    public static String getBooleanString(boolean bl) {
        if (bl) {
            return "true";
        }
        return "false";
    }

    public static int translateBufferSize(String string) {
        int n;
        if (string == null) {
            return -2;
        }
        boolean bl = false;
        string = string.trim();
        if ((string = string.toLowerCase()).equals("none")) {
            return 0;
        }
        if (string.endsWith("kb")) {
            if (string.length() < 3) {
                return -1;
            }
            string = string.substring(0, string.length() - 2).trim();
            bl = true;
        }
        if (string.endsWith("k")) {
            if (string.length() < 2) {
                return -1;
            }
            string = string.substring(0, string.length() - 1).trim();
            bl = true;
        }
        if (string.length() == 0) {
            return -1;
        }
        try {
            n = Integer.valueOf(string);
            if (bl) {
                n *= 1024;
            } else if (n < 128) {
                n *= 1024;
            }
        }
        catch (NumberFormatException numberFormatException) {
            n = -1;
        }
        return n;
    }

    public static String scopeStrToPageContextStr(String string) {
        if (string.equalsIgnoreCase("request")) {
            return "PageContext.REQUEST_SCOPE";
        }
        if (string.equalsIgnoreCase("session")) {
            return "PageContext.SESSION_SCOPE";
        }
        if (string.equalsIgnoreCase("application")) {
            return "PageContext.APPLICATION_SCOPE";
        }
        return "PageContext.PAGE_SCOPE";
    }

    public static void emitDeclaration(JspEmitState jspEmitState, String string, String string2, String string3, String string4, String string5) {
        jspEmitState.iprintln(String.valueOf(string3) + " " + string + ";");
        jspEmitState.iprintln("if ((" + string + " = (" + string3 + ") pageContext.getAttribute( \"" + string + "\", " + (string2.equalsIgnoreCase("request") ? "PageContext.REQUEST_SCOPE" : (string2.equalsIgnoreCase("session") ? "PageContext.SESSION_SCOPE" : (string2.equalsIgnoreCase("application") ? "PageContext.APPLICATION_SCOPE" : "PageContext.PAGE_SCOPE"))) + ")) == null) {");
        jspEmitState.indent();
        if (string4 != null) {
            jspEmitState.iprintln(String.valueOf(string) + " = (" + string3 + ") new " + string4 + "();");
        } else {
            jspEmitState.iprintln(String.valueOf(string) + " = (" + string3 + ") Beans.instantiate( this.getClass().getClassLoader(), " + string5 + ");");
        }
        jspEmitState.iprintln("pageContext.setAttribute( \"" + string + "\", " + string + ", " + (string2.equalsIgnoreCase("request") ? "PageContext.REQUEST_SCOPE" : (string2.equalsIgnoreCase("session") ? "PageContext.SESSION_SCOPE" : (string2.equalsIgnoreCase("application") ? "PageContext.APPLICATION_SCOPE" : "PageContext.PAGE_SCOPE"))) + ");");
    }

    public static void emitEndDeclaration(JspEmitState jspEmitState) {
        jspEmitState.undent();
        jspEmitState.iprintln("}");
    }

    public static void addImport(String string, JspParseState jspParseState) {
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        String[] stringArray = new String[]{};
        if (jspParseState.parms.imports != null) {
            n = jspParseState.parms.imports.length;
            int n3 = 0;
            while (n3 < n) {
                if (string.equals(jspParseState.parms.imports[n3])) {
                    bl = true;
                }
                ++n3;
            }
            if (bl) {
                return;
            }
            stringArray = new String[n + 1];
            int n4 = 0;
            while (n4 < n) {
                stringArray[n4] = jspParseState.parms.imports[n4];
                ++n4;
            }
            n2 = n;
        } else {
            stringArray = new String[1];
        }
        stringArray[n2] = string;
        jspParseState.parms.imports = stringArray;
    }

    public static String handlePagePath(String string, String string2) {
        if (!string2.startsWith("/") && string != null) {
            string2 = string.endsWith("/") ? String.valueOf(string) + string2 : String.valueOf(string) + "/" + string2;
        }
        string2 = JspUtil.handleDotsInPath(string2, '/');
        return string2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

