/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.parse;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import oracle.jsp.parse.JspDirective;
import oracle.jsp.parse.JspDirectiveInclude;
import oracle.jsp.parse.JspEmitException;
import oracle.jsp.parse.JspEmitState;
import oracle.jsp.parse.JspParseException;
import oracle.jsp.parse.JspParsePosition;
import oracle.jsp.parse.JspParseState;
import oracle.jsp.parse.JspParseTag;
import oracle.jsp.parse.JspParseTagFile;
import oracle.jsp.parse.JspUtils;
import oracle.jsp.provider.JspReqResourceException;
import oracle.jsp.provider.JspReqResourceProvider;

public class JspParseTagDirective
extends JspParseTag {
    private static final String MSG_FILE = "oracle.jsp.parse.LocalStrings";
    private static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.parse.LocalStrings");
    private JspDirective directive;
    private JspParsePosition startPos;
    private String directiveName;
    static /* synthetic */ Class class$oracle$jsp$parse$JspDirectiveInclude;

    public JspParseTagDirective() {
        super(2);
    }

    public String getTagName() {
        return "directive";
    }

    public String toString() {
        String string = "<%@ Directive ";
        if (this.directive != null) {
            string = string.concat(this.directive.getName());
        }
        string = string.concat(" %>");
        return string;
    }

    protected void setTagString(String string) {
        super.setTagString(string);
        if (string.startsWith("jsp:directive.")) {
            this.directiveName = string.substring(14);
        }
    }

    protected boolean isEndTag(String string) {
        return false;
    }

    protected boolean isEndAVTag(JspParseState jspParseState, String string) {
        if (string.equals("%>") && this.directiveName == null) {
            jspParseState.tagHasBody = false;
            return true;
        }
        if (string.equals("/>") && this.directiveName != null) {
            jspParseState.tagHasBody = false;
            return true;
        }
        if (string.equals(">")) {
            jspParseState.tagHasBody = true;
            return true;
        }
        return false;
    }

    public void validateTagAttributes(JspParseState jspParseState) throws JspParseException {
        if (this.directive == null) {
            throw new JspParseException(jspParseState, msgs.getString("no_direct_name"));
        }
        this.directive.validateAttributes(jspParseState);
        jspParseState.directives.put(this.directive.getName(), this.directive);
    }

    public void processAttributeValue(JspParseState jspParseState, int n, String string, String string2) throws JspParseException {
        if (n == 1 && this.directiveName == null) {
            this.directive = jspParseState.getDirectiveHandler(string);
            if (this.directive == null) {
                throw new JspParseException(jspParseState, MessageFormat.format(msgs.getString("undef_direct"), string));
            }
            this.directive.setValue(string2);
            return;
        }
        if (this.directive == null) {
            throw new JspParseException(jspParseState, msgs.getString("no_direct"));
        }
        if (string.equals(this.directive.getName())) {
            this.directive.setValue(string2);
            return;
        }
        this.directive.addAttribute(jspParseState, string, string2);
    }

    private JspParseTag findRootParent() {
        JspParseTag jspParseTag;
        JspParseTag jspParseTag2 = this.parent;
        if (jspParseTag2 == null || !(jspParseTag2 instanceof JspParseTagFile)) {
            return jspParseTag2;
        }
        while ((jspParseTag = jspParseTag2.parent) != null && jspParseTag instanceof JspParseTagFile) {
            jspParseTag2 = jspParseTag;
        }
        return jspParseTag2;
    }

    protected void parse(JspParseState jspParseState) throws IOException, JspParseException {
        if (this.directiveName != null) {
            this.directive = jspParseState.getDirectiveHandler(this.directiveName);
            if (this.directive == null) {
                throw new JspParseException(jspParseState, MessageFormat.format(msgs.getString("undef_direct"), this.directiveName));
            }
        }
        this.startPos = jspParseState.getPosition();
        super.parse(jspParseState);
        this.startPos = null;
        if (this.directive != null && this.directive.getClass() == (class$oracle$jsp$parse$JspDirectiveInclude != null ? class$oracle$jsp$parse$JspDirectiveInclude : (class$oracle$jsp$parse$JspDirectiveInclude = JspParseTagDirective.class$("oracle.jsp.parse.JspDirectiveInclude")))) {
            String string = ((JspDirectiveInclude)this.directive).file;
            string = JspUtils.handlePagePath(jspParseState.parms.pagePath, string);
            if (jspParseState.parms.resourceProvider != null) {
                try {
                    InputStreamReader inputStreamReader;
                    Object object;
                    if (jspParseState.parms.resourceProvider instanceof JspReqResourceProvider) {
                        object = (JspReqResourceProvider)jspParseState.parms.resourceProvider;
                        inputStreamReader = jspParseState.parms.encoding != null ? object.fromReader(string, jspParseState.parms.encoding, jspParseState.parms.compileHttpReq) : object.fromReader(string, jspParseState.parms.compileHttpReq);
                    } else {
                        inputStreamReader = jspParseState.parms.encoding != null ? jspParseState.parms.resourceProvider.fromReader(string, jspParseState.parms.encoding) : jspParseState.parms.resourceProvider.fromReader(string);
                    }
                    if (inputStreamReader == null) {
                        throw new JspParseException(jspParseState, MessageFormat.format(msgs.getString("no_includef"), string));
                    }
                    jspParseState.addIncludeDependency(string);
                    object = new BufferedReader(inputStreamReader);
                    JspParseTagFile jspParseTagFile = new JspParseTagFile((BufferedReader)object);
                    jspParseTagFile.setFileName(string);
                    String string2 = jspParseState.currentSourceFile;
                    jspParseState.currentSourceFile = string;
                    JspParseTag jspParseTag = this.findRootParent();
                    jspParseTag.addTagToBody(jspParseState, this);
                    jspParseTagFile.setParent(jspParseTag);
                    jspParseTagFile.parse(jspParseState);
                    jspParseState.currentSourceFile = string2;
                    JspParseTag cfr_ignored_0 = (JspParseTag)jspParseTag.body.lastElement();
                    return;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw new JspParseException(jspParseState, MessageFormat.format(msgs.getString("no_includef"), string));
                }
                catch (IOException iOException) {
                    throw new JspParseException(jspParseState, MessageFormat.format(msgs.getString("include_io_ex"), string));
                }
                catch (JspReqResourceException jspReqResourceException) {
                    throw new JspParseException(jspParseState, jspReqResourceException.toString());
                }
            }
            throw new JspParseException(jspParseState, MessageFormat.format(msgs.getString("cannot_include"), string));
        }
    }

    public JspDirective getDirective() {
        return this.directive;
    }

    public void emitTagBody(JspEmitState jspEmitState) throws JspEmitException {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

