/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.parse;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import oracle.jsp.parse.JspParsePosition;
import oracle.jsp.parse.JspParseState;

public class JspParseException
extends Exception {
    private static final String MSG_FILE = "oracle.jsp.parse.LocalStrings";
    private static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.parse.LocalStrings");
    public int lineNum;
    public String errorLine;

    public JspParseException(JspParseState jspParseState, String string) {
        super(string);
        this.lineNum = jspParseState.position.lineNum;
        this.errorLine = jspParseState.position.line;
    }

    public JspParseException(int n, String string, String string2) {
        super(string2);
        this.lineNum = n;
        this.errorLine = string;
    }

    public JspParseException(JspParsePosition jspParsePosition, String string) {
        super(string);
        this.lineNum = jspParsePosition.lineNum;
        this.errorLine = jspParsePosition.line;
    }

    public int getLineNumber() {
        return this.lineNum;
    }

    public String getErrorLine() {
        if (this.errorLine == null) {
            return "";
        }
        String string = this.errorLine;
        if (string.endsWith("\r\n")) {
            string = string.substring(0, string.length() - 2);
        } else if (string.endsWith("\n")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public String getErrorMessage() {
        return super.getMessage();
    }

    public String getMessage() {
        return String.valueOf(MessageFormat.format(msgs.getString("error_line_hdr"), Integer.toString(this.lineNum), this.getErrorLine())) + "\n" + msgs.getString("error_hdr") + super.getMessage();
    }

    public String getParentMsg() {
        return super.getMessage();
    }
}

