/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.parse;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import oracle.jsp.parse.JspBeanInfo;
import oracle.jsp.parse.JspBeanPropertyInfo;

public class JspBeanDictionary
implements Cloneable,
Serializable {
    private Hashtable dictionary = new Hashtable();
    private int blockScope = 10;
    private Hashtable defaultProperties;

    public JspBeanDictionary() {
        this.addDefaultProperty("oracle.jsp.jml.JmlBoolean", "value");
        this.addDefaultProperty("oracle.jsp.jml.JmlString", "value");
        this.addDefaultProperty("oracle.jsp.jml.JmlNumber", "value");
        this.addDefaultProperty("javax.servlet.ServletContext", "attribute");
        this.addDefaultProperty("javax.servlet.http.HttpSession", "value");
        this.addDefaultProperty("javax.servlet.http.HttpServletRequest", "parameter");
        this.addDefaultProperty("javax.servlet.jsp.PageContext", "attribute");
    }

    protected Object clone() throws CloneNotSupportedException, OutOfMemoryError {
        JspBeanDictionary jspBeanDictionary = (JspBeanDictionary)super.clone();
        jspBeanDictionary.dictionary = (Hashtable)this.dictionary.clone();
        if (this.defaultProperties != null) {
            jspBeanDictionary.defaultProperties = (Hashtable)this.defaultProperties.clone();
        }
        return jspBeanDictionary;
    }

    public boolean beanExists(String string) {
        return this.dictionary.get(string) != null;
    }

    public JspBeanInfo getBeanInfo(String string) {
        JspBeanInfo jspBeanInfo = (JspBeanInfo)this.dictionary.get(string);
        return jspBeanInfo;
    }

    public Enumeration getAllBeans() {
        return this.dictionary.elements();
    }

    public Class getBean(String string) {
        JspBeanInfo jspBeanInfo = this.getBeanInfo(string);
        if (jspBeanInfo != null) {
            return jspBeanInfo.bean;
        }
        return null;
    }

    public void addBean(JspBeanInfo jspBeanInfo) {
        JspBeanInfo jspBeanInfo2 = this.dictionary.put(jspBeanInfo.name, jspBeanInfo);
        if (jspBeanInfo2 != null) {
            jspBeanInfo.hides = jspBeanInfo2;
        }
    }

    public int getNextBlockScope() {
        ++this.blockScope;
        return this.blockScope;
    }

    public void killBlockScope(int n) {
        this.blockScope = n - 1;
        if (this.blockScope < 10) {
            return;
        }
        Enumeration enumeration = this.dictionary.elements();
        while (enumeration.hasMoreElements()) {
            JspBeanInfo jspBeanInfo = (JspBeanInfo)enumeration.nextElement();
            if (jspBeanInfo.scope < n) continue;
            if (jspBeanInfo.hides != null) {
                this.dictionary.put(jspBeanInfo.name, jspBeanInfo.hides);
                continue;
            }
            this.dictionary.remove(jspBeanInfo.name);
        }
    }

    public JspBeanPropertyInfo getGetPropertyInfo(String string, String string2) {
        JspBeanInfo jspBeanInfo = this.getBeanInfo(string);
        if (jspBeanInfo != null) {
            return jspBeanInfo.getGetProperty(string2);
        }
        return null;
    }

    public JspBeanPropertyInfo getSetPropertyInfo(String string, String string2) {
        JspBeanInfo jspBeanInfo = this.getBeanInfo(string);
        if (jspBeanInfo != null) {
            return jspBeanInfo.getSetProperty(string2);
        }
        return null;
    }

    public String getDefaultProperty(String string) {
        if (this.defaultProperties == null) {
            return null;
        }
        return (String)this.defaultProperties.get(string);
    }

    public void addDefaultProperty(String string, String string2) {
        if (this.defaultProperties == null) {
            this.defaultProperties = new Hashtable();
        }
        this.defaultProperties.put(string, string2);
    }
}

