/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspFactory;
import oracle.jsp.app.JspAppLoader;
import oracle.jsp.app.JspApplication;
import oracle.jsp.app.JspReloadException;
import oracle.jsp.app.JspRequestContext;
import oracle.jsp.parse.JspParseException;
import oracle.jsp.provider.JspCompileException;
import oracle.jsp.provider.JspReqResourceException;
import oracle.jsp.runtime.JspHttpRequest;
import oracle.jsp.runtime.OracleJspFactory;
import oracle.jsp.runtime.OracleJspWriter;
import oracle.jsp.util.JspUtil;
import oracle.jsp.util.JspVersion;

public class JspServlet
extends HttpServlet {
    private JspAppLoader appLoader;
    private boolean debug = true;
    private static final String MSG_FILE = "oracle.jsp.LocalStrings";
    private static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.LocalStrings");
    private boolean translateParams = false;
    private boolean unsafeReload = false;
    private String defaultErrorEncoding;

    public void init(ServletConfig servletConfig) throws ServletException {
        ServletContext servletContext;
        String string;
        String string2;
        super.init(servletConfig);
        OracleJspFactory oracleJspFactory = new OracleJspFactory();
        JspFactory.setDefaultFactory((JspFactory)oracleJspFactory);
        this.appLoader = new JspAppLoader(this.readProperties(servletConfig));
        String string3 = servletConfig.getInitParameter("debug_mode");
        if (string3 != null) {
            this.debug = Boolean.valueOf(string3);
        }
        if ((string2 = servletConfig.getInitParameter("translate_params")) != null) {
            this.translateParams = Boolean.valueOf(string2);
        }
        if ((string = servletConfig.getInitParameter("unsafe_reload")) != null) {
            this.unsafeReload = Boolean.valueOf(string);
        }
        this.defaultErrorEncoding = servletConfig.getInitParameter("default_error_encoding");
        if (this.defaultErrorEncoding == null) {
            this.defaultErrorEncoding = "UTF-8";
        }
        if (JspVersion.getServletVersion(servletContext = servletConfig.getServletContext()) > 1) {
            servletContext.setAttribute("oracle.jsp.versionNumber", (Object)"1.1.2.0");
        }
    }

    public void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        try {
            this.internalService(httpServletRequest, httpServletResponse);
            return;
        }
        catch (Throwable throwable) {
            this.reportException(throwable, httpServletRequest, httpServletResponse);
            return;
        }
    }

    public void internalService(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException, JspReqResourceException {
        JspUtil.setDefaultContentType(httpServletRequest, httpServletResponse);
        boolean bl = false;
        JspRequestContext jspRequestContext = new JspRequestContext(this.getServletConfig(), this.getServletContext(), httpServletRequest, httpServletResponse);
        while (!bl) {
            try {
                this.doDispatch(jspRequestContext);
                bl = true;
            }
            catch (JspReloadException jspReloadException) {
            }
            catch (JspParseException jspParseException) {
                this.reportException(jspParseException, httpServletRequest, httpServletResponse);
                return;
            }
            catch (JspCompileException jspCompileException) {
                this.reportException(jspCompileException, httpServletRequest, httpServletResponse);
                return;
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.reportException(fileNotFoundException, httpServletRequest, httpServletResponse);
                return;
            }
        }
    }

    public void destroy() {
        this.appLoader.destroy();
        this.appLoader = null;
    }

    private void doDispatch(JspRequestContext jspRequestContext) throws ServletException, IOException, JspReloadException, JspCompileException, JspParseException, JspReqResourceException {
        JspApplication jspApplication = null;
        HttpServletRequest httpServletRequest = null;
        HttpServletResponse httpServletResponse = null;
        jspApplication = this.appLoader.getApplication(jspRequestContext);
        try {
            try {
                httpServletRequest = jspRequestContext.getRequest();
                httpServletResponse = jspRequestContext.getResponse();
                if (!(httpServletRequest instanceof JspHttpRequest)) {
                    httpServletRequest = this.appLoader.getRequestProvider().getRequest(httpServletRequest, httpServletResponse, jspApplication.getServletContext(), this.translateParams);
                }
                if (JspVersion.getServletVersion(jspRequestContext.getServletContext()) == 1 && httpServletRequest instanceof JspHttpRequest) {
                    ((JspHttpRequest)httpServletRequest).setAttribute("oracle.jsp.JspServlet", (Object)this);
                }
                jspApplication.dispatchRequest(httpServletRequest, httpServletResponse);
            }
            catch (JspReloadException jspReloadException) {
                if (this.unsafeReload) {
                    throw jspReloadException;
                }
                Integer n = (Integer)httpServletRequest.getAttribute("oracle.jsp.requestRefCount");
                if (n != null && n > 0) {
                    throw new ServletException(MessageFormat.format(msgs.getString("cannot_reload_page"), JspUtil.getRequestURI(httpServletRequest)));
                }
                throw jspReloadException;
            }
            Object var6_7 = null;
            jspApplication.decrementRefCount();
            return;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            jspApplication.decrementRefCount();
            throw throwable;
        }
    }

    private Hashtable readProperties(ServletConfig servletConfig) throws ServletException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Enumeration enumeration = servletConfig.getInitParameterNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            hashtable.put(string.toLowerCase(), servletConfig.getInitParameter(string));
        }
        return hashtable;
    }

    private void reportException(Throwable throwable, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        PrintWriter printWriter;
        if (msgs == null) {
            this.logException("No resource file!", new Exception(), this.getServletContext());
        }
        this.logException(msgs.getString("cannot_dispatch_page"), throwable, this.getServletContext());
        if ((throwable instanceof JspParseException || throwable instanceof JspCompileException) && JspUtil.needToSendError(this.getServletConfig())) {
            try {
                httpServletResponse.sendError(500, "OracleJSP: " + throwable.toString());
                return;
            }
            catch (IOException iOException) {}
        }
        if (throwable instanceof FileNotFoundException) {
            if (JspUtil.needToSendError(this.getServletConfig())) {
                try {
                    httpServletResponse.sendError(404, "OracleJSP: " + throwable.toString());
                    return;
                }
                catch (IOException iOException) {}
            } else if (this.defaultErrorEncoding != null) {
                httpServletResponse.setContentType("text/html;charset=" + this.defaultErrorEncoding);
            }
        }
        try {
            printWriter = OracleJspWriter.acquireHTMLReportWriter((ServletResponse)httpServletResponse);
        }
        catch (Exception exception) {
            return;
        }
        printWriter.println("<HTML><BODY>");
        printWriter.println("<P> <H2  ALIGN=CENTER>" + msgs.getString("jspError_hdr") + "</H2> <HR  ALIGN=CENTER> <P>");
        printWriter.println("<P><H3>" + msgs.getString("requestURI_hdr") + httpServletRequest.getRequestURI() + "</H3><P>");
        if (this.debug) {
            printWriter.println("<BR><H3>" + msgs.getString("exception_hdr") + "</H3><PRE>");
            throwable.printStackTrace(printWriter);
            printWriter.println("</PRE>");
        } else {
            printWriter.println("<H3>" + msgs.getString("exception_hdr") + "</H3>" + throwable.toString());
        }
        printWriter.println("<P><P><HR ALIGN=CENTER>");
        printWriter.println("</HTML></BODY>");
        printWriter.close();
    }

    private void logException(String string, Throwable throwable, ServletContext servletContext) {
        if (this.debug) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            throwable.printStackTrace(printWriter);
            servletContext.log(String.valueOf(string) + stringWriter.toString());
            return;
        }
        servletContext.log(String.valueOf(string) + msgs.getString("exception_hdr") + throwable.toString());
    }
}

