<?xml version="1.0" encoding="ISO8859-1"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:template match="/">
<xsl:output method="html" indent="no"/>

<html>
<head>
<script>

function modify(id){
	formx=document.forms.submitForm; 
	dataform=document.forms["data"+id];	
	formx.ID.value=dataform.ID.value;
	formx.modello.value=dataform.modello.value;
	formx.type.value=dataform.type.value;
	formx.prezzo.value=dataform.prezzo.value;
	formx.disponibilita.value=dataform.disponibilita.value;
	if(dataform.anno!=null)
		formx.anno.value=dataform.anno.value;
}


  function submitModify(form){
  	form.azione.value="MODIFY";
	alert("modifica");
  	form.submit();
  }
	
  function submitInsert(form){

  	form.azione.value="INSERT";
	alert("insert")
  	form.submit();
  }



</script>


</head>


<body>

<h1>Computer Store</h1>

<xsl:apply-templates select="/ROOT/CATALOGO" />
<xsl:apply-templates select="/ROOT/ERROR" />

</body>


</html>
</xsl:template>



<xsl:template match="/ROOT/CATALOGO" >

<xsl:if test="/ROOT/VIEW_CATALOG='HW'" >
<h2> Lista dei Prodotti Hardware</h2>
<table border="1" width="70%">
<tr>
<td> Modello </td>
<td> Prezzo </td>
<td> Disp</td>
</tr>
<xsl:apply-templates select="HARDWARE" />
</table>
</xsl:if>
<xsl:if test="/ROOT/VIEW_CATALOG='SW'" >
<h2> Lista dei Prodotti Software</h2>
<table border="1" width="70%">
<tr>
<td> Modello </td>
<td> Prezzo </td>
<td> Disp</td>
</tr>
<xsl:apply-templates select="SOFTWARE" />
</table>
</xsl:if>
<hr/>


<form name="submitForm" action="storestatic.jsp" method="post">
<table border="1" width="70%">
<tr>
<td>ID</td>
<td><input type="text" name="ID" /></td>
</tr>
<tr>
<td>Modello</td>
<td><input type="text" name="modello" /></td>
</tr>
<tr>
<td> Prezzo</td>
<td> <input type="text" name="prezzo" /></td>
</tr>
<tr>
<td>Tipo</td>
<td><input type="text" name="type" /></td>
</tr>
<tr>
<td>Disponibilit</td>
<td><input type="text" name="disponibilita" /></td>
</tr>

<xsl:if test="/ROOT/VIEW_CATALOG='SW'" >
<tr>
<td>Anno </td>
<td><input type="text" name="anno" /></td>
</tr>
</xsl:if>
</table>



<input type="button" onclick="submitInsert(this.form)" value="Inserisci"> </input>
<input type="button" onclick="submitModify(this.form)" value="Aggiorna Dsiponibilit"> </input>


<input type="hidden" name="azione" value="VIEW"></input>
</form>


</xsl:template>


<xsl:template match="HARDWARE" >
<tr>
	<td> <xsl:value-of select="MODELLO" /></td>
	<td> <xsl:value-of select="PREZZO" /></td>
	<td> <a href="javascript:modify('{ID}')"> <xsl:value-of select="DISPONIBILITA" /></a> </td>
</tr>
<!-- form hidden per la manipolazione in ajavascript -->
<form name="data{ID}">
<input type="hidden" name="ID" value="{ID}" />
<input type="hidden" name="modello" value="{MODELLO}" />
<input type="hidden" name="type" value="{@TYPE}" />
<input type="hidden" name="prezzo" value="{PREZZO}" />
<input type="hidden" name="disponibilita" value="{DISPONIBILITA}" />


</form>


</xsl:template>

<xsl:template match="SOFTWARE" >
<tr>
	<td> <xsl:value-of select="MODELLO" /></td>
	<td> <xsl:value-of select="PREZZO" /></td>
	<td> <a href="javascript:modify('{ID}')"> <xsl:value-of select="DISPONIBILITA" /></a> </td>
</tr>
<!-- form hidden per la manipolazione in ajavascript -->
<form name="data{ID}">
<input type="hidden" name="ID" value="{ID}" />
<input type="hidden" name="modello" value="{MODELLO}" />
<input type="hidden" name="type" value="{@TYPE}" />
<input type="hidden" name="prezzo" value="{PREZZO}" />
<input type="hidden" name="anno" value="{ANNO}" />
<input type="hidden" name="disponibilita" value="{DISPONIBILITA}" />
</form>

</xsl:template>


<xsl:template match="/ROOT/ERROR">
<script >
alert("{.}");
</script>


</xsl:template>

</xsl:stylesheet> 

