/*
 * Conversion.java
 *
 *
 * This class is a set of useful (and static :-) methods!
 */

package appss.util;

import appss.global.*;
import java.util.*;
import java.text.*;
import java.io.*;
import java.sql.*;


/**
 *
 * @author  webeng
 * @version 1.0
 */
public class Conversion {

  
  /** Useful for conversion from "S" or "N" to the related boolean*/
  public static boolean getBoolean(String string) {

    if (string.equals("s") | string.equals("S"))
      return true;
    return false;

  }

  /** Useful for conversion from boolean to the related String */
  public static String getString(boolean b) {

    return (b ? "S": "N");

  }


  public static Vector tokenizeString(String toTokenize,String separator) {

    StringTokenizer tokenizer;
    Vector result=new Vector();

    if (toTokenize!=null) {
      tokenizer=new StringTokenizer(toTokenize,separator);
      while (tokenizer.hasMoreTokens())
        result.add((String)tokenizer.nextToken());
    }

    return result;

  }



  public static String replaceAll (String sTxt, String sOldTag, String sNewTag) {

    /* il doppio passaggio serve per evitare loop infiniti per sostituzioni tipo & --> &amp */


    String newText = "";
    int pos=0;
    int lastpos=0;


    while ( (pos=sTxt.indexOf(sOldTag,lastpos))!=-1) {
    newText += sTxt.substring(lastpos,pos)+sNewTag;
    lastpos = pos+sOldTag.length();
    }

    newText += sTxt.substring(lastpos,sTxt.length());
    return newText.toString();

  }


  public static String[] split(String sText, int dim, int maxlen) {

    String[] result = new String[maxlen];
    for (int i=0; i<maxlen; i++) {
        int ix=i*dim;
        int fx=ix+dim;
        if (ix>sText.length()) ix = -1;
        if (fx>sText.length()) fx = sText.length();
        if(ix!=-1)
          result[i]=sText.substring(ix,fx);
        else
          result[i]="";
    }
    return result;
  }


  public static String getTaggedString (String s, String openTag, String closeTag) {

    String res = "";
    int i = s.indexOf(openTag);
    int f = s.indexOf(closeTag);

    if (i!=-1 && f!=-1)
      res = s.substring(i+openTag.length(), f);

    return res;
  }


 
  /** From ' to '' for Oracle insert, update and delete queries */
  public static String getOracleString(String inputString) {

    if (inputString == null)
      return "-";


    inputString = replaceAll (inputString, "'", "`");
    inputString = replaceAll (inputString, "\"", "`");

    return inputString;

  }
    
    public static String getOracleDate(Calendar c) {

    String s = "#"
                + c.get(Calendar.DAY_OF_MONTH) + "/"
                + (c.get(Calendar.MONTH)+1) + "/"
                + c.get(Calendar.YEAR) + "#";
    return s;

    }

}

