/*
 * SessionException.java
 *

 */
 
package appss.services.sessionservice.exception;

/** 

 * @version 
 */

import appss.services.errorservice.*;
import appss.services.databaseservice.*;
import appss.services.logservice.*;

import appss.global.*;

import java.io.*;

public class SessionException extends SException implements FatalError {
  
  
  /** Creates new SessionException - Esegue una rollback implicita sul Database che ha provocato l'errore
      @param mgs Messaggio di errore correlato all'eccezione
	  @param oDatabase Oggetto Database correlato all'errore 
  */
    public SessionException(String msg) {
    
    super("Session Error: "+msg);
       
    this.logMessage="Session Error\n"+msg+"\n";
    
    ByteArrayOutputStream stackTrace=new ByteArrayOutputStream();
    this.printStackTrace(new PrintWriter(stackTrace,true));        
    
    this.logMessage=this.logMessage+stackTrace.toString();        
    
  }    

 
 /** Ritorna il messaggio di Errore corrispondente al Fatal Error **/   
  public String getLogMessage() {
    
    return logMessage;
    
  }
   
 /** Chiamata di RollBack (implementazione classe Astratta FatalError) **/   
  public void makeRollBack() {    
      
      
  }
  

  
  
    
}