/*
 * SException.java
 *

 */

package appss.services.sessionservice.exception;

import appss.services.sessionservice.*;
import appss.services.logservice.*;

/** 
 * Errore del Session service.
 * <p>
 * Superclasse per tutte le eccezioni del Session Service.
 *

 *
 *
 */

public class SException extends Exception {
  
  
  
  /** 
   * Messaggio di errore.
   * <p>
   * Contiene il messaggio di errore da scivere sul file di log.
   *
   */      
  
  protected String logMessage;

  /** 
   * Costruttore.
   * <p>
   * Costruttore senza parametri.
   *
   */
  
  public SException() {
  }
  
  /** 
   * Costruttore con messagio di errore e mail gateway.
   * <p>
   * Viene istanziato l'errore del mail service specificando il messaggio
   * di errore e il mail gateway interessato.
   * <p>
   * @param msg Messaggio di errore
   * @param sSMTPGate Mail gateway interessato dall'errore.
   *
   */        
  
  public SException(String msg) {
    super(msg);
    logMessage= msg;
    log();
  }
  
  /** 
   * Aggiorna il file di log degli errori del Mail Service.
   * <p> 
   * 
   * @see services.logservice.ErrorLog
   *
   */        
  
  public void log() {
    ErrorLog.generalErrorLog(logMessage);    
  }  
  
}

