/*
 * Session.java
*/

package appss.services.sessionservice;

import javax.servlet.http.*;
import java.util.*;

import appss.util.*;
import appss.services.errorservice.*;
import appss.services.sessionservice.exception.*;


/**
 * Manages cookies session related
 * @version 1.1
 */



 public class Session extends Object {

  public Session() {
  }


 
 
   /**
    * Crea una lista di cookies in base alle specifiche fornite.
    * @param sName Lista dei Nomi dei cookie da creare
    * @param sValue Lista dei valori da associare ai nomi
    * @exception Exception
    */

   public static Cookie[] createCookie(String[] sName, String[] sValue) throws Exception {

   /**
    * Create a Cookie
    **/
    Cookie[] oCookie;
   
    try{

      // creo il cookie
      oCookie=new Cookie[sName.length];
      Cookie oCtmp;
      for (int i=0; i<sName.length; i++) {
        oCtmp=new Cookie(sName[i],sValue[i]);
        oCookie[i]=oCtmp;
      }

      for (int i=0; i<oCookie.length; i++) {
        oCookie[i].setPath("/");
      }

      
    } catch (Exception e) {
      oCookie=null;
      e.printStackTrace();
    }

    showCookies(oCookie);
    return oCookie;
  }




 

   /**
    * Estrae dalla lista dei cookies quello specificato.
    * @param sName Nome del Cookie da estrarre
    * @param oCookies Lista dei Cookies
    * @exception Exception("Corrupted Cookie");
    */

  public static String getCookieValue(Cookie oCookies[], String sName)
  throws Exception {

    int i;

    for (i=0;i< oCookies.length;i++)
      if (oCookies[i].getName().equals(sName))
        return oCookies[i].getValue();

    throw new SessionException("Corrupted Cookie");

  }

 
 /**
  * Visualizza la lista dei Cookies sul system output
  * @param oCookies Lista dei Cookies
  * @exception Exception("Corrupted Cookie");
  */


 public static void showCookies(Cookie[] oCookies){

    
    Debug.println("Cookie presenti:" + oCookies.length);
    int i;
    for (i=0;i< oCookies.length;i++)
      Debug.println("Nome:" + oCookies[i].getName() + " Valore:" +oCookies[i].getValue()+" Path:"+oCookies[i].getPath());
  }



 

  }