/*
 * ResultSetDBException.java
 *
 * Created on May 5, 2000, 3:17 PM
 */
 
package appss.services.databaseservice.exception;

/** 
 *
 * @author 
 * @version 
 */

import appss.services.errorservice.*;
import appss.services.databaseservice.*;
import appss.services.logservice.*;

import java.io.*;

public class ResultSetDBException extends DBException implements GeneralError {
  
  
  /** Creates new ResultSetDBException - Esegue una rollback implicita sul Database che ha provocato l'errore
      @param mgs Messaggio di errore correlato all'eccezione
	  @param oDatabase Oggetto Database correlato all'errore 
  */
  public ResultSetDBException(String msg,DataBase oDataBase) {
    
    super("General Error: "+msg);
    this.oDataBase=oDataBase;
       
    this.logMessage="General\n"+msg+"\n";       
    
  }    
  
  /** Creates new ResultSetDBException - NON Esegue una rollback implicita 
      @param mgs Messaggio di errore correlato all'eccezione
  */
  public ResultSetDBException(String msg) {
    
    this(msg,null);        
    
  }  
  
   /** Ritorna il messaggio di Errore corrispondente al General Error **/   
  public String getLogMessage() {
    
    return logMessage;
    
  }

 /** Chiamata di RollBack (implementazione classe Astratta GeneralError) **/       
  public void makeRollBack() {
    
    if (oDataBase!=null) this.oDataBase.rollBack();
       
  }

}