/*
 * NotFoundDBException.java
 *
 */
 
package appss.services.databaseservice.exception;

/** 
 *
 * @author  Administrator
 * @version 
 */

import appss.services.errorservice.*;
import appss.services.databaseservice.*;
import appss.services.logservice.*;
import appss.global.*;

import java.io.*;

public class NotFoundDBException extends DBException implements FatalError {
  
  
  /** Creates new NotFoundDBException - Esegue una rollback implicita sul Database che ha provocato l'errore
      @param mgs Messaggio di errore correlato all'eccezione
	  @param oDatabase Oggetto Database correlato all'errore 
  */
  public NotFoundDBException(String msg,DataBase oDataBase) {
    
    super("Fatal Error: "+msg);
    this.oDataBase=oDataBase;
       
    this.logMessage="Fatal Error\n"+msg+"\n";
    
    ByteArrayOutputStream stackTrace=new ByteArrayOutputStream();
    this.printStackTrace(new PrintWriter(stackTrace,true));        
    
    this.logMessage=this.logMessage+stackTrace.toString();        
    
  }    

  /** Creates new NotFoundDBException - NON Esegue una rollback implicita 
      @param mgs Messaggio di errore correlato all'eccezione
  */
  
  public NotFoundDBException(String msg) {
    
    this(msg,null);        
    
  }  
 
 /** Ritorna il messaggio di Errore corrispondente al Fatal Error **/   
  public String getLogMessage() {
    
    return logMessage;
    
  }
   
 /** Chiamata di RollBack (implementazione classe Astratta FatalError) **/   
  public void makeRollBack() {    
      
    if (oDataBase!=null) this.oDataBase.rollBack();     
      
  }
  
/** Chiamata di invio Mail (implementazione classe Astratta FatalError) */  
  public void mailError() {
                                   
  }

}