/*
 * DBException.java
 *
 */

package appss.services.databaseservice.exception;

/** 
 *
 * @author  webeng  
 * @version 1.0
 */

import appss.services.databaseservice.*;
import appss.services.logservice.*;

public class DBException extends Exception {

    protected DataBase oDataBase=null;
    protected String logMessage;
  
  /**
   * Creates new <code>DBException</code> without detail message.
   */
  public DBException() {
  }
  

  /**
   * Constructs an <code>DBException</code> with the specified detail message.
   * @param msg the detail message.
   */
  public DBException(String msg) {
    this(msg,null);
  }
  
  /**
   * Constructs an <code>DBException</code> with the specified detail message and
   * the specified DataBase.
   * @param msg the detail message.
   * @param oDatabase the DataBase
   */
  
  public DBException (String msg,DataBase oDataBase) {
    
    super(msg);
    this.oDataBase=oDataBase;
    logMessage="Created Exception: "+ msg;
    log();
  }
   
  public void log() {
    
    ErrorLog.databaseErrorLog(logMessage);
    
  }  
}

