/*
 * DBService.java
 */
package appss.services.databaseservice;


import java.sql.*;
import javax.sql.*;
import java.net.URL;

import appss.util.*;
import appss.global.*;
import appss.services.databaseservice.exception.*;

/**
 * Service to get DataBase Object
 * @see DataBase
 */
public class DBService extends Object {

  

/**
 * Connection Monitoring (Debug purpose)
 */  
  public static int nConnections=0;
/**
 * Connection Monitoring (Debug purpose)
 */  
  public static int maxConnections=0;
/**
 * Connection Monitoring (Debug purpose)
 */  
  public static int nDBObject=0;

/**
 * Class constructor (not used)
 */  
  public DBService() {
  }

  /**
   * Returns a DataBase object with an opened connection to database
   *
   * @param DBName database name
   * @param Pool if true activate connection pool
   * @return database object with an opened connection
   * @throws NotFoundDBException Throw when it finds problem with database connection. The problem type is specified by exception message.
   * @see DataBase
 */
  public static synchronized DataBase getDataBase() throws NotFoundDBException {

     try{
        Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");//Loading Sun's JDBC ODBC Driver        
        Connection theConnection = DriverManager.getConnection(Constants.DB_CONNECTION_STRING, Constants.DB_USER_NAME, Constants.DB_PASSWORD); //Connect to  Data source
               
        return new DataBase(theConnection);
      } catch (Exception e) {
        throw new NotFoundDBException("DBService: Impossibile creare la Connessione singola al DataBase: " + e);
      }
    }

    


}