/*
 * UserService.java
 *
 */
 
package appss.blogics.accountmanager;

import java.util.*;
import java.sql.*;
import appss.services.databaseservice.*;
import appss.services.databaseservice.exception.*;
import appss.services.errorservice.*;
import appss.util.*;

/** 
 * Servizi per la gestione degli utenti
 * <p>
 * Questa Classe offre una serie di servizi relativa
 * alla gestione degli utenti.
 * <p>
 *
 * @author  webeng
 * 
 * @see apps.blogics.accountmanager
 * @see User
 *
 */
public class UserService extends Object {

  /** 
   * Costruttore.
   * <p>
   * Non utilizzato in quanto i metodi della classe sono statici.
   *
   */  
  public UserService() {}
  

  /**
   * Restituisce un utente dato il suo codice utente.
   * <p>
   * 
   * Passando al metodo il database e il codice utente si ottiene l'oggetto
   * User corrispondente.
   *
   * @param oDataBase Il Database.
   * @param sCdUser Codice Utente.
   *
   * @return L'utente con codice dato
   *
   * @exception NotFoundDBException Si  verificato un errore nell'acceso al DB.
   * @exception ResultSetDBException Si  verificato un errore di lettura dei dati.
   * dal Database.
   * 
   * @see User
   *
   */    
  public static User getUser(DataBase oDataBase,String sCdUser) 
    throws NotFoundDBException,ResultSetDBException {

    User oUser;

    String sSQL=" SELECT *" +
                " FROM "+
                "   AUTENTI "+
                " WHERE " +
                "   CD_USER= '" + Conversion.getOracleString(sCdUser)+"'";

    Debug.println(">: UserService: getUser:"+sSQL);
    ResultSet rResultSet=oDataBase.select(sSQL);
    
    try {

      if (rResultSet.next()) {
        oUser=new User(rResultSet);
      } else {
        rResultSet.close();  
        return null;
      }
        rResultSet.close();
    } catch (SQLException ex) {
      throw new ResultSetDBException("UserService: getUser():  Errore nel ResultSet: "+ex.getMessage(),oDataBase);
    }
    
    return oUser;

  }



  
  

  
}