/*
 * User.java
 *
 */
 
package appss.blogics.accountmanager;

import java.util.*;
import java.sql.*;
import java.io.*;

import appss.services.databaseservice.*;
import appss.services.databaseservice.exception.*;

import appss.util.*;

/** 
 * Utente
 * <p>
 * Questa classe rappresenta  un utente dell'agenda. <br> Viene mappata la Tabella
 * AUTENTI.
 * <p>
 *
 * @author webeng  
 * 
 */

public class User  {

  /** 
   * Codice Utente (UserName).
   * <p>
   * Mappa il campo CD_USER
   */  
  public String sCdUser=null;
  
  
  /** 
   * Nome dell'utente.
   * <p>
   * Mappa il campo NOME
   */       
  public String sName="";
  
  /** 
   * Cognome dell'utente.
   * <p>
   * Mappa il campo COGNOME
   */   
  public String sSurname="";
  
  
  
  /** 
   * Password dell'utente.
   * <p>
   * Mappa il campo PWD
   */        
  public String sPassword="";
  
  
  /** 
   * Timestamp
   * <p>
   * Mappa il campo TIMESTAMP
   */   
  public Timestamp oTimestamp;  
  

  /**
   * Crea un nuovo Utente con i parametri passati.
   * <p>
   * Questo costruttore  utilizzato per creare un nuovo
   * oggetto User da inserire in tabella.
   *
   * @param sCdUser odice Utente (UserName).
   * @param sName Nome dell'utente.
   * @param sSurname Cognome dell'utente.
   * @param sEMail E-mail dell'utente.
   * @param sPassword Password dell'utente.
   */

  public User(String sCdUser,     
              String sName,       
              String sSurname,                  
              String sPassword) 
  
  {
                  
    super();

    if (sCdUser!=null) this.sCdUser=sCdUser;
    if (sName!=null) this.sName=sName;
    if (sSurname!=null) this.sSurname=sSurname;
    if (sPassword!=null) this.sPassword=sPassword;
    
  }


  /**
   * Crea un nuovo Utente a partire da un Result Set
   * <p>
   * @param rs Il Result Set
   *
   * @exception SQLException Impossibile trovare il campo sul Result Set
   *
   */

  public User(ResultSet rs) throws SQLException {

    super();
    sCdUser=rs.getString("CD_USER");
    sName=rs.getString("NOME");
    sSurname=rs.getString("COGNOME");
    sPassword=rs.getString("PWD");
    oTimestamp=rs.getTimestamp("TIMESTAMP");
  } 
  }