/*
 * PersonService.java
 *
 */
 
package appss.blogics.accountmanager;

import java.util.*;
import java.sql.*;
import appss.services.databaseservice.*;
import appss.services.databaseservice.exception.*;
import appss.services.errorservice.*;
import appss.util.*;

/** 
 * Servizi per la gestione dei contatti del agenda
 * <p>
 * Questa Classe offre una serie di servizi relativa
 * alla gestione dei contatti.
 * <p>
 *
 * @author  webeng
 * 
 * 
 * @see Person
 *
 */
public class PersonService extends Object {

  /** 
   * Costruttore.
   * <p>
   * Non utilizzato in quanto i metodi della classe sono statici.
   *
   */  
  public PersonService() {}
  
  /**
   * Crea un nuovo conatto con i parametri passati.
   * <p>
   * Questo metodo  utilizzato per creare un nuovo
   * oggetto Person e inserirlo nel DB. non committa.
   *
   * @param oDataBase Il Database.
   * @param cdUser odice contatto (UserName).
   * @param cdClient Codice Cliente.
   * @param name Nome del contatto.
   * @param surname Cognome del contatto.
   * @param street Indirizzo del contatto.
   * @param city Citt del contatto.
   * @param phone Recapito Telefonico del contatto.
   * @param eMail E-mail del contatto.
   * @param active Stato del contatto.
   * @param sSex Sesso del contatto.
   *
   * @return il contatto appena creato.
   *
   * @see Person
   *
   */  
  public static Person insertNewPerson(DataBase oDataBase,
                            String cdUser,
                            String name,String surname,String street,
                            String city,String phone,
                            String eMail,String sSex)

                            throws NotFoundDBException,DuplicatedRecordDBException,ResultSetDBException {

   Person oPerson;

   oPerson=new Person(null,cdUser,name,surname,street,
                  city,phone,
                  eMail,sSex);

   oPerson.insert(oDataBase);

   return oPerson;

  }

  /**
   * Restituisce un contatto dato il suo codice contatto e codice proprietario.
   * <p>
   * 
   * Passando al metodo il database e il codice contatto si ottiene l'oggetto
   * person corrispondente.
   *
   * @param oDataBase Il Database.
   * @param oCdPerson Codice contatto.
   * @param cdUser cduser dell'utente proprietario del contatto
   *
   * @return contatto con codice dato
   *
   * @exception NotFoundDBException Si  verificato un errore nell'acceso al DB.
   * @exception ResultSetDBException Si  verificato un errore di lettura dei dati.
   * dal Database.
   * 
   * @see Person
   *
   */    
  public static Person getPerson(DataBase oDataBase,String cdUser, Long oCdPerson) 
    throws NotFoundDBException,ResultSetDBException {

    Person oPerson;

    String sSQL=" SELECT *" +
                " FROM "+
                "   ACONTATTI "+
                " WHERE " +
                "   cd_user = '"+cdUser+"' and ID= " + oCdPerson+ " and fl_active='S'";

    ResultSet rResultSet=oDataBase.select(sSQL);
    Debug.println(">: PersonService: getPerson:"+sSQL);

    try {

      if (rResultSet.next()) {
        oPerson=new Person(rResultSet);
      } else {
        return null;
      }

    } catch (SQLException ex) {
      throw new ResultSetDBException("personService: getperson():  Errore nel ResultSet: "+ex.getMessage(),oDataBase);
    }

    return oPerson;

  }


  /**
   * Restituisce una lista di contatti dato un filtro.
   * <p>
   * la ricerca su un dato parametro si avvale della funzione proprietaria access long instr (string1,string2)
   * @param oDataBase Il Database.
   * @return Lista di Person
   *
   * @exception NotFoundDBException Si  verificato un errore nell'acceso al DB.
   * @exception ResultSetDBException Si  verificato un errore di lettura dei dati.
   * dal Database.
   * 
   * @see Person
   *
   */    
  public static Person[] findPerson(DataBase oDataBase,String cdUser, String nome, String cognome, 
    String indirizzo, String citta, String telefono, String email, String sex) 
    throws NotFoundDBException,ResultSetDBException {

    Person oPerson = null;
    Vector oV = new Vector();
    Person[] oPersonList = null;
    String sSQL ="";
    
    sSQL = "select * from acontatti where ";
    sSQL+= "cd_user ='"+cdUser+"' ";
    sSQL+= " and fl_Active='S' ";
    if (!nome.equals("-"))
        sSQL+= " and instr(nome,'"+nome+"')>0 ";
    if (!cognome.equals("-"))
        sSQL+= " and instr(cognome,'"+cognome+"')>0 ";
    if (!indirizzo.equals("-"))
        sSQL+= " and instr(via,'"+indirizzo+"')>0 ";
    if (!citta.equals("-"))
        sSQL+= " and instr(citta,'"+citta+"')>0 ";
    if (!telefono.equals("-"))
        sSQL+= " and instr(tel,'"+telefono+"')>0 ";
    if (!email.equals("-"))
        sSQL+= " and instr(email,'"+email+"')>0 ";
    if (!sex.equals("-"))
        sSQL+= " and instr(sex,'"+sex+"')>0 ";
    
    sSQL += "order by cognome, nome, email";
    
    
    ResultSet rResultSet=oDataBase.select(sSQL);
    Debug.println(">: PersonService: findPerson:"+sSQL);
    
    
    try {

      while (rResultSet.next()) {
        oPerson=new Person(rResultSet);
        oV.add(oPerson);
      } 
      
      oPersonList = new Person[oV.size()];
      oV.copyInto(oPersonList);
      
    } catch (SQLException ex) {
      throw new ResultSetDBException("personService: getperson():  Errore nel ResultSet: "+ex.getMessage(),oDataBase);
    }

    return oPersonList;

  }

  
  
  /**
   * Cancella dal DB un contatto dato il suo codice contatto.
   * <p>
   * Passando al metodo il database e un codice contatto
   * il record corrispondente viene cancellato. eliminazione LOGICA.
   *
   * @param oDataBase Il Database.
   * @param sCdUser Il Codice contatto.
   *
   * @exception NotFoundDBException Si  verificato un errore nell'acceso al DB.
   * @exception ResultSetDBException Si  verficato un errore di lettura dei dati
   * dal Database.
   * 
   * @see person
   *
   */    
  public static void deletePerson(DataBase oDataBase,Long oCdPerson) throws NotFoundDBException,ResultSetDBException {

    Person oPerson;

    oPerson=new Person(oCdPerson, 
            null,null,null,
            null,null,null,
            null,null);
    oPerson.delete(oDataBase);
    

  }


  
}