/*
 * Person.java
 *
 */
 
package appss.blogics.accountmanager;

import java.util.*;
import java.sql.*;
import java.io.*;

import appss.services.databaseservice.*;
import appss.services.databaseservice.exception.*;

import appss.util.*;

/** 
 * contatto
 * <p>
 * Questa classe rappresenta  un contatto del agenda. <br> Viene mappata la Tabella
 * ACONTATTI.
 * <p>
 *
 * @author webeng  
 * 
 */

public class Person  {
 
  /** chiave primaria di un contatto. mappa ID  */   
  public Long oCdPerson = null;
  
  /** 
   * Codice contatto (personName). proprietario di questo contatto
   * <p>
   * Mappa il campo CD_USER
   */  
  public String sCdUser=null;
  
  
  /** 
   * Nome del contatto.
   * <p>
   * Mappa il campo NOME
   */       
  public String sName="";
  
  /** 
   * Cognome del contatto.
   * <p>
   * Mappa il campo COGNOME
   */   
  public String sSurname="";
  
  /** 
   * Indirizzo del contatto.
   * <p>
   * Mappa il campo VIA
   */       
  public String sStreet="";
  
  /** 
   * Citt del contatto.
   * <p>
   * Mappa il campo CITTA
   */      
  public String sCity="";
  
  /** 
   * Recapito Telefonico del contatto.
   * <p>
   * Mappa il campo TEL
   */      
  public String sPhone="";
  
  
  /** 
   * E-mail del contatto.
   * <p>
   * Mappa il campo EMAIL
   */    
  public String sEMail="";
  
  
  /** 
   * Stato del contatto.
   * <p>
   * Indica se un contatto  attivo o disattivo.
   * <p>
   * Mappa il campo FL_ACTIVE
   */   
  public String sActive="S";

  /** 
   * Sesso del contatto.
   * <p>
   * Mappa il campo SEX
   */    
  public String sSex="";

  
  /** 
   * Timestamp
   * <p>
   * Mappa il campo TIMESTAMP
   */   
  public Timestamp oTimestamp;  
  

  /**
   * Crea un nuovo contatto con i parametri passati.
   * <p>
   * Questo costruttore  utilizzato per creare un nuovo
   * oggetto person da inserire in tabella.
   *
   * @param sCdUser odice contatto (UserName).
   * @param sName Nome del contatto.
   * @param sSurname Cognome del contatto.
   * @param sStreet Indirizzo del contatto.
   * @param sCity Citt del contatto.
   * @param sPhone Recapito Telefonico del contatto.
   * @param sEMail E-mail del contatto.
   * @param sActive Stato del contatto.
   * @param sSex Sesso del contatto.
   */

  public Person (Long oCdPerson, String sCdUser,     
              String sName,       String sSurname,    String sStreet,
              String sCity,       String sPhone,  
              String sEMail,
              String sSex) 
  
  {
                  
    super();

    if (oCdPerson!=null) this.oCdPerson=oCdPerson;
    if (sCdUser!=null) this.sCdUser=sCdUser;
    if (sName!=null) this.sName=sName;
    if (sSurname!=null) this.sSurname=sSurname;
    if (sStreet!=null) this.sStreet=sStreet;
    if (sCity!=null) this.sCity=sCity;
    if (sPhone!=null) this.sPhone=sPhone;
    if (sEMail!=null) this.sEMail=sEMail;
    if (sSex!=null) this.sSex=sSex;
    
  }


  /**
   * Crea un nuovo contatto a partire da un Result Set
   * <p>
   * @param rs Il Result Set
   *
   * @exception SQLException Impossibile trovare il campo sul Result Set
   *
   */

  public Person(ResultSet rs) throws SQLException {

    super();


    oCdPerson=new Long(rs.getLong("ID"));
    
    sCdUser=rs.getString("CD_USER");
    sName=rs.getString("NOME");
    sSurname=rs.getString("COGNOME");

    sStreet=rs.getString("VIA");
    sCity=rs.getString("CITTA");
    sPhone=rs.getString("TEL");
    sEMail=rs.getString("EMAIL");

    sActive=rs.getString("FL_ACTIVE");
    oTimestamp=rs.getTimestamp("TIMESTAMP");
    
    sSex=rs.getString("SEX");

   
  }

  /**
   * inserimento nuovo contatto.
   * check di unicit su chiave logica: nome,cognome,email
   * @param oDataBase Il Database su cui rendere effettive le modifiche.
   *
   * @exception NotFoundDBException Si  verificato un errore nell'acceso al DB.
   * @exception DuplicatedRecordDBException Si  verificato un tentativo di 
   * inserire un codice contatto (username) gi presente.
   * @exception ResultSetDBException Si  verficato un errore di lettura dei dati
   * dal Database.
   *
   */


  public void insert(DataBase oDataBase) throws NotFoundDBException,DuplicatedRecordDBException,ResultSetDBException {
    String sSQL="";
    
    
    /* check di unicit */
      sSQL += "select CD_USER from acontatti ";
      sSQL += " where " ;
      sSQL += " fl_Active='S' and ";
      sSQL += " nome='" + Conversion.getOracleString(sName.toLowerCase()) +  "' and ";
      sSQL += " cognome='"+Conversion.getOracleString(sSurname.toLowerCase()) +  "' and ";
      sSQL += " email='"+Conversion.getOracleString(sEMail.toLowerCase()) +  "' ";

      ResultSet rs=oDataBase.select(sSQL);

      boolean exist=false;

      try {

        exist=rs.next();
        rs.close();

      } catch (SQLException e) {

        throw new ResultSetDBException("Person: save(): Errore sul ResultSet --> Impossibile Verificare "+
                                     "l'eventuale presenza di record duplicati.");
      }

      if (exist) {
          throw new DuplicatedRecordDBException("person: save(): Tentativo di inserimento di "+
                "un codice contatto gi esistente nella tabella utenti. CdUser: "+sCdUser);
      }
      
      /* generazione ID */
      
      sSQL="select max(ID) as n from acontatti";
      
      try {
        rs=oDataBase.select(sSQL);

         if (rs.next()) 
            oCdPerson = new Long(rs.getLong("N")+1);
         else
            oCdPerson = new Long(1);
      
         rs.close();
      
        } catch (SQLException e) {
        throw new ResultSetDBException("Person: save(): Errore sul ResultSet --> impossibile calcolare ID.");
      }

      
      /*  inserimento nuovo contatto */
            
      sSQL="INSERT INTO acontatti " +
           "(ID, CD_USER," +
           " NOME,COGNOME," +
           " VIA,CITTA," +
           " TEL,"+
           " EMAIL," +
           " FL_ACTIVE, "+
           " SEX "+
           " ) " +
           " VALUES ("+
           oCdPerson+
           ",'"+Conversion.getOracleString(sCdUser)+"'"+
           ",'"+Conversion.getOracleString(sName.toLowerCase())+
           "','"+Conversion.getOracleString(sSurname.toLowerCase())+
           "','"+Conversion.getOracleString(sStreet.toLowerCase())+
           "','"+Conversion.getOracleString(sCity.toLowerCase())+
            "','"+Conversion.getOracleString(sPhone.toLowerCase())+
           "','"+Conversion.getOracleString(sEMail.toLowerCase())+
           "','S',"+
           "'"+Conversion.getOracleString(sSex)+"' "+
           ")";

      oDataBase.modify(sSQL);

  }
  

  /**
   * update contatto.<br/>
   * check di unicit su chiave logica: nome, cognome, email
   * @param oDataBase Il Database su cui rendere effettive le modifiche.
   *
   * @exception NotFoundDBException Si  verificato un errore nell'acceso al DB.
   * @exception DuplicatedRecordDBException Si  verificato un tentativo di 
   * inserire un codice contatto (username) gi presente.
   * @exception ResultSetDBException Si  verficato un errore di lettura dei dati
   * dal Database.
   *
   */

  
public void update(DataBase oDataBase) throws NotFoundDBException,ResultSetDBException,DuplicatedRecordDBException {
    String sSQL="";


        /* check di unicit */
      sSQL += "select CD_USER from acontatti ";
      sSQL += " where " ;
      sSQL += " fl_Active='S' and ";
      sSQL += " nome='" + Conversion.getOracleString(sName.toLowerCase()) +  "' and ";
      sSQL += " cognome='"+Conversion.getOracleString(sSurname.toLowerCase()) +  "' and ";
      sSQL += " email='"+Conversion.getOracleString(sEMail.toLowerCase()) +  "' and ";
      sSQL += " id<>"+oCdPerson;

      ResultSet rs=oDataBase.select(sSQL);

      boolean exist=false;

      try {

        exist=rs.next();
        rs.close();

      } catch (SQLException e) {

        throw new ResultSetDBException("Person: save(): Errore sul ResultSet --> Impossibile Verificare "+
                                     "l'eventuale presenza di record duplicati.");
      }

      if (exist) {
          throw new DuplicatedRecordDBException("person: save(): Tentativo di inserimento di "+
                "un codice contatto gi esistente nella tabella utenti. CdUser: "+sCdUser);
      }

    
      sSQL=" UPDATE acontatti "+
           " SET NOME = '"+Conversion.getOracleString(sName.toLowerCase())+"', "+
           " COGNOME = '"+Conversion.getOracleString(sSurname.toLowerCase())+"', "+
           " VIA = '"+Conversion.getOracleString(sStreet.toLowerCase())+"', "+
           " CITTA = '"+Conversion.getOracleString(sCity.toLowerCase())+"', "+
           " TEL = '"+Conversion.getOracleString(sPhone)+"', "+
           " EMAIL = '"+Conversion.getOracleString(sEMail.toLowerCase())+"', "+      
           " FL_ACTIVE = '"+Conversion.getOracleString(sActive)+"', "+
           " SEX= '"+Conversion.getOracleString(sSex)+"'"+
         
           " WHERE "+
           " ID = "+oCdPerson+" ";

      Debug.println("-->upddate person:"+sSQL);     
      oDataBase.modify(sSQL);
  
  
  }
  
  /**
   * eliminazione logica.
   * l'eliminazione avviene settando il flag attivo a "N"
   * @param oDataBase Il Database su cui rendere effettive le modifiche.
   *
   * @exception NotFoundDBException Si  verificato un errore nell'acceso al DB.
   * @exception DuplicatedRecordDBException Si  verificato un tentativo di 
   * inserire un codice contatto (username) gi presente.
   * @exception ResultSetDBException Si  verficato un errore di lettura dei dati
   * dal Database.
   *
   */
  
  public void delete(DataBase oDataBase) throws NotFoundDBException,ResultSetDBException {

    String sSQL="";

      sSQL=" UPDATE acontatti "+
           " set fl_active='N' where "+
           " ID = "+oCdPerson+"";

      oDataBase.modify(sSQL);

  
  
  }
  
  }