/*
 * Login.java
 *
 */

package appss.bflows;

import java.beans.*;

import appss.services.databaseservice.*;
import appss.services.databaseservice.exception.*;
import appss.services.errorservice.*;
import appss.services.sessionservice.*;
import appss.services.sessionservice.exception.*;
import appss.services.logservice.*;
import appss.blogics.accountmanager.*;

import appss.util.*;
import java.io.*;
import java.util.*;
import javax.servlet.http.*;


/**
 *
 * @author  webeng
 * @version
 */
public class Login extends Object implements java.io.Serializable {
    
    private static final String PROP_SAMPLE_PROPERTY = "SampleProperty";
    
    private String sampleProperty;
    
    private PropertyChangeSupport propertySupport;
    
    /** Holds value of property cdUser. */
    private String cdUser;
    
    /** Holds value of property password. */
    private String password;
    
    /** Holds value of property result. */
    private int result;
    
    
    public boolean isAuthenticated = false;
 
    public Cookie[] oCookies;
    
    /** Creates new Login */
    public Login() {
        propertySupport = new PropertyChangeSupport( this );
    }
    
    
    public void authenticate(){
        DataBase oDataBase;
        
        
        try{
            
            oDataBase=DBService.getDataBase();
            
            User oUser = UserService.getUser (oDataBase,cdUser);
            if (oUser != null && oUser.sPassword.equals(password)) {
                /* utente autenticato */
                isAuthenticated = true;
                
                String[] attribs = {"cdUser","nome","cognome"};
                String[] values  = {oUser.sCdUser,oUser.sName,oUser.sSurname};
                oCookies = Session.createCookie (attribs, values);
                
            } else {
                /* log fallito */             
            } 
            
            Debug.println("close connection login bean");
            oDataBase.commit();
            oDataBase.close();
        } catch (NotFoundDBException ex) {
            EService.logAndRecover(ex);
            setResult(EService.UNRECOVERABLE_ERROR);
            return ;
            
        } catch (ResultSetDBException ex) {
            EService.logAndRecover(ex);
            setResult(EService.UNRECOVERABLE_ERROR);
            return ;
            
        }
        catch (Exception ex) {
            
            setResult(EService.UNRECOVERABLE_ERROR);
            return ;
            
        }
        
        
    }
    
    
    
    
    public String getSampleProperty() {
        return sampleProperty;
    }
    
    public void setSampleProperty(String value) {
        String oldValue = sampleProperty;
        sampleProperty = value;
        propertySupport.firePropertyChange(PROP_SAMPLE_PROPERTY, oldValue, sampleProperty);
    }
    
    
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        propertySupport.addPropertyChangeListener(listener);
    }
    
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        propertySupport.removePropertyChangeListener(listener);
    }
    
    /** Getter for property cdUser.
     * @return Value of property cdUser.
     */
    public String getCdUser() {
        return cdUser;
    }
    
    /** Setter for property cdUser.
     * @param cdUser New value of property cdUser.
     */
    public void setCdUser(String cdUser) {
        this.cdUser = cdUser;
    }
    
    /** Getter for property password.
     * @return Value of property password.
     */
    public String getPassword() {
        return password;
    }
    
    /** Setter for property password.
     * @param password New value of property password.
     */
    public void setPassword(String password) {
        this.password = password;
    }
    
    /** Getter for property result.
     * @return Value of property result.
     */
    public int getResult() {
        return result;
    }
    
    /** Setter for property result.
     * @param result New value of property result.
     */
    public void setResult(int result) {
        this.result = result;
    }
    
}
