/*
 * Agenda.java
 *
 * Created on 8 marzo 2002, 11.03
 */

package appss.bflows;

import java.beans.*;


import appss.services.databaseservice.*;
import appss.services.databaseservice.exception.*;
import appss.services.errorservice.*;
import appss.services.sessionservice.*;
import appss.services.sessionservice.exception.*;
import appss.services.logservice.*;
import appss.blogics.accountmanager.*;

import appss.util.*;
import java.io.*;
import java.util.*;
import javax.servlet.http.*;

/**
 *
 * @author  Aravani
 * @version 
 */
public class Agenda extends Object implements java.io.Serializable {

    private static final String PROP_SAMPLE_PROPERTY = "SampleProperty";

    private String sampleProperty;

    private PropertyChangeSupport propertySupport;

    /** Holds value of property nome. */
    private String nome="-";
    
    /** Holds value of property cognome. */
    private String cognome="-";
    
    /** Holds value of property email. */
    private String email="-";
    
    /** Holds value of property citta. */
    private String citta="-";
    
    /** Holds value of property telefono. */
    private String telefono="-";
    
    /** Holds value of property sex. */
    private String sex="-";
    
    /** Holds value of property indirizzo. */
    private String indirizzo="-";

    
    /** Holds value of property result. */
    private int result;    
    
    /** Holds value of property cdUser. */
    private String cdUser;
    
    /** Creates new Agenda */
    public Agenda() {
        propertySupport = new PropertyChangeSupport ( this );
    }

    public String getSampleProperty () {
        return sampleProperty;
    }

    public void setSampleProperty (String value) {
        String oldValue = sampleProperty;
        sampleProperty = value;
        propertySupport.firePropertyChange (PROP_SAMPLE_PROPERTY, oldValue, sampleProperty);
    }


    public void addPropertyChangeListener (PropertyChangeListener listener) {
        propertySupport.addPropertyChangeListener (listener);
    }

    public void removePropertyChangeListener (PropertyChangeListener listener) {
        propertySupport.removePropertyChangeListener (listener);
    }
    
    
    
    

    /** Getter for property nome.
     * @return Value of property nome.
     */
    public String getNome() {
        return nome;
    }
    
    /** Setter for property nome.
     * @param nome New value of property nome.
     */
    public void setNome(String nome) {
        this.nome = nome;
    }
    
    /** Getter for property cognome.
     * @return Value of property cognome.
     */
    public String getCognome() {
        return cognome;
    }
    
    /** Setter for property cognome.
     * @param cognome New value of property cognome.
     */
    public void setCognome(String cognome) {
        this.cognome = cognome;
    }
    
    /** Getter for property email.
     * @return Value of property email.
     */
    public String getEmail() {
        return email;
    }
    
    /** Setter for property email.
     * @param email New value of property email.
     */
    public void setEmail(String email) {
        this.email = email;
    }
    
    /** Getter for property citta.
     * @return Value of property citta.
     */
    public String getCitta() {
        return citta;
    }
    
    /** Setter for property citta.
     * @param citta New value of property citta.
     */
    public void setCitta(String citta) {
        this.citta = citta;
    }
    
    /** Getter for property telefono.
     * @return Value of property telefono.
     */
    public String getTelefono() {
        return telefono;
    }
    
    /** Setter for property telefono.
     * @param telefono New value of property telefono.
     */
    public void setTelefono(String telefono) {
        this.telefono = telefono;
    }
    
    /** Getter for property sex.
     * @return Value of property sex.
     */
    public String getSex() {
        return sex;
    }
    
    /** Setter for property sex.
     * @param sex New value of property sex.
     */
    public void setSex(String sex) {
        this.sex = sex;
    }
    
    

    
    /** array di Person: risultato della ricerca */
    public Person  oPersonList[];
    /** oggetto Person pubblico: risultato della ricerca in modifica e cancella  */
    public Person  oPerson=null;
    
    /** Holds value of property cdPerson. */
    private Long cdPerson = new Long(0);
    
    /** 
     * aggiunge un contatto.
     *
     *
     *
     */
    
    public void addPerson(){
        DataBase oDataBase;
        
        
        try{
            
            oDataBase=DBService.getDataBase();
            
            PersonService.insertNewPerson (oDataBase,cdUser,nome,cognome,indirizzo,citta,telefono,email,sex);
            
            oDataBase.commit();
            oDataBase.close();
        } catch (NotFoundDBException ex) {
            EService.logAndRecover(ex);
            setResult(EService.UNRECOVERABLE_ERROR);
            return ;
            
        } catch (ResultSetDBException ex) {
            EService.logAndRecover(ex);
            setResult(EService.UNRECOVERABLE_ERROR);
            return ;
            
        } catch (DuplicatedRecordDBException ex) {
            EService.logAndRecover(ex);
            setResult(101);
            return ;
            
        }
        
    }
    

    public void findPerson(){
        DataBase oDataBase;
        
        
        try{
            
            oDataBase=DBService.getDataBase();
            
            oPersonList = PersonService.findPerson (oDataBase,cdUser,nome,cognome,indirizzo,citta,telefono,email,sex);
            
            oDataBase.commit();
            oDataBase.close();
        } catch (NotFoundDBException ex) {
            EService.logAndRecover(ex);
            setResult(EService.UNRECOVERABLE_ERROR);
            return ;
            
        } catch (ResultSetDBException ex) {
            EService.logAndRecover(ex);
            setResult(EService.UNRECOVERABLE_ERROR);
            return ;
            
        } 
        
    }
    
    

    public void deletePerson(){
        DataBase oDataBase;
        
        
        try{
            
            oDataBase=DBService.getDataBase();
            
            PersonService.deletePerson (oDataBase,cdPerson);
            cdPerson = new Long(0);
            
            oDataBase.commit();
            oDataBase.close();
        } catch (NotFoundDBException ex) {
            EService.logAndRecover(ex);
            setResult(EService.UNRECOVERABLE_ERROR);
            return ;
            
        } catch (ResultSetDBException ex) {
            EService.logAndRecover(ex);
            setResult(EService.UNRECOVERABLE_ERROR);
            return ;
            
        }
    }
    


    public void modifyPerson(){
        DataBase oDataBase;
        
        
        try{
            
            oDataBase=DBService.getDataBase();
            
            Person oPerson = new Person (cdPerson,cdUser,nome,cognome,indirizzo,citta,telefono,email,sex);
            oPerson.update(oDataBase);

            oDataBase.commit();
            oDataBase.close();
        } catch (NotFoundDBException ex) {
            EService.logAndRecover(ex);
            setResult(EService.UNRECOVERABLE_ERROR);
            return ;
            
        } catch (ResultSetDBException ex) {
            EService.logAndRecover(ex);
            setResult(EService.UNRECOVERABLE_ERROR);
            return ;
            
        }catch (DuplicatedRecordDBException ex) {
            EService.logAndRecover(ex);
            setResult(101);
            return ;
            
        }
    }
    
    
    
    public void getPerson(){
        DataBase oDataBase;
        
        
        try{
            
            oDataBase=DBService.getDataBase();
            
            oPerson = PersonService.getPerson (oDataBase,cdUser,cdPerson);
            
            oDataBase.commit();
            oDataBase.close();
        } catch (NotFoundDBException ex) {
            EService.logAndRecover(ex);
            setResult(EService.UNRECOVERABLE_ERROR);
            return ;
            
        } catch (ResultSetDBException ex) {
            EService.logAndRecover(ex);
            setResult(EService.UNRECOVERABLE_ERROR);
            return ;
            
        }
    }
   

    /** Getter for property result.
     * @return Value of property result.
     */
    public int getResult() {
        return result;
    }    
    
    /** Setter for property result.
     * @param result New value of property result.
     */
    public void setResult(int result) {
        this.result = result;
    }    
    
    /** Getter for property indirizzo.
     * @return Value of property indirizzo.
     */
    public String getIndirizzo() {
        return indirizzo;
    }
    
    /** Setter for property indirizzo.
     * @param indirizzo New value of property indirizzo.
     */
    public void setIndirizzo(String indirizzo) {
        this.indirizzo = indirizzo;
    }
    
    /** Getter for property cdUser.
     * @return Value of property cdUser.
     */
    public String getCdUser() {
        return cdUser;
    }
    
    /** Setter for property cdUser.
     * @param cdUser New value of property cdUser.
     */
    public void setCdUser(String cdUser) {
        this.cdUser = cdUser;
    }
    
    /** Getter for property cdPerson.
     * @return Value of property cdPerson.
     */
    public Long getCdPerson() {
        return cdPerson;
    }
    
    /** Setter for property cdPerson.
     * @param cdPerson New value of property cdPerson.
     */
    public void setCdPerson(Long cdPerson) {
        this.cdPerson = cdPerson;
    }
    
}