//: version "1.8.5"
//: property useExtBars = 0
//: property discardChanges = 1

module main;    //: root_module
wire w6;    //: /sn:0 {0}(789,343)(717,343){1}
wire w7;    //: /sn:0 {0}(691,277)(659,277){1}
//: {2}(657,275)(657,257)(627,257){3}
//: {4}(625,255)(625,244){5}
//: {6}(623,257)(610,257){7}
//: {8}(657,279)(657,340)(696,340){9}
wire w3;    //: /sn:0 {0}(726,242)(746,242){1}
//: {2}(748,240)(748,231){3}
//: {4}(748,244)(748,273){5}
//: {6}(750,275)(788,275){7}
//: {8}(748,277)(748,301){9}
wire w0;    //: /sn:0 {0}(789,338)(746,338)(746,322){1}
wire w1;    //: /sn:0 {0}(788,280)(745,280){1}
//: {2}(741,280)(712,280){3}
//: {4}(743,282)(743,301){5}
wire w8;    //: /sn:0 {0}(610,305)(624,305){1}
//: {2}(628,305)(646,305){3}
//: {4}(648,303)(648,282)(691,282){5}
//: {6}(648,307)(648,345)(696,345){7}
//: {8}(626,303)(626,293){9}
wire C;    //: /dp:1 {0}(837,329)(837,341)(810,341){1}
wire S;    //: {0}(809,278)(834,278)(834,268){1}
//: enddecls

  //: comment g61 /dolink:1 /link:"@C/edwire_tut.v" @(630,100) /sn:0 /anc:1
  //: /line:"Collegamenti"
  //: /end
  //: joint g37 (w3) @(748, 275) /w:[ 6 5 -1 8 ]
  //: switch g34 (w8) @(593,305) /sn:0 /w:[ 0 ] /st:1
  //: comment g13 /dolink:0 /link:"" @(25,45) /anc:1
  //: /line:"1) Clicca sull'icona del \"Logic analyzer\" nella barra di strumenti,"
  //: /line:"o seleziona \"Begin Simulation\" nel menu \"Simulate\". Dovrebbe "
  //: /line:"apparire la finestra di visualizzazione del timing dei segnali."
  //: /line:""
  //: /line:"2) Aggancia una sonda di misura sui segnali \"S\" e \"C\""
  //: /line:"e sui collegamenti che escono dagli interruttori: fai doppio click"
  //: /line:"sui collegamenti. Nel visualizzatore di timing apparir una traccia"
  //: /line:"per ogni segnale."
  //: /line:""
  //: /line:"3) Pigia pi volte sulla barra di spazio (tastiera) per far avanzare"
  //: /line:"il tempo di simulazione."
  //: /line:"Ad ogni spazio il tempo avanza di una \"epoca\". "
  //: /line:"Nella terminologia di TkGate una \"epoca\"  la risoluzione del simulatore."
  //: /line:""
  //: /line:"4) Scegli \"Options...\" dal menu \"File\" e clicca sulla selezione"
  //: /line:"\"Simulator\". Inserisci \"5\" nel campo \"Epoch Step Size\"; \"OK\"."
  //: /line:"Ora inserisci di nuovo degli spazi: ad ogni spazio la simulazione "
  //: /line:"avanza di 5 unit di risoluzione (epoche)."
  //: /line:""
  //: /line:"5) Clicca su uno degli interruttori per cambiarne il valore e fai"
  //: /line:"avanzare la simulazione (spazi)."
  //: /line:"I risultati di simulazione appaiono nella finestra dei timing."
  //: /line:""
  //: /line:"6) Clicca e tieni premuto il tasto sinistro del mouse su qualsiasi "
  //: /line:"collegamento interno. Il valore trasportato dal collegamento viene"
  //: /line:"visualizzato in formato \"Verilog\"."
  //: /line:"Il primo numero indica la cardinalit del collegamento (numero di bit);"
  //: /line:"la lettera indica la base di numerazione (radix) e l'ultimo numero indica"
  //: /line:"il valore del segnale."
  //: /line:"Per esempio, la cifra \"1\" in \"1'b0\" indica che si tratta di un segnale "
  //: /line:"di un bit, la lettera \"b\" indica che il valore  dato in binario, e"
  //: /line:"\"0\" indica il valore del segnale."
  //: /line:""
  //: /line:"7) Clicca sull'icona \"Play\" nella barra degli strumenti o seleziona \"Run\""
  //: /line:"dal menu \"Simulate\".  Il simulatore entra in modalit di simulazione "
  //: /line:"continua. Prova a cliccare sugli interruttori del circuito."
  //: /line:"Ogni volta che commuti, il simulatore ricalcola il circuito finch le "
  //: /line:"uscite ritornano stabili."
  //: /line:"L'icona \"Pause\" rimette il simulatore in modalit \"single step\"."
  //: /line:""
  //: /line:"8) Per terminare la simulazione seleziona \"Stop\" nella barra degli strumenti "
  //: /line:"o \"End Simulation\" nel \"Simulate\"."
  //: /end
  nand g16 (.I0(w0), .I1(w6), .Z(C));   //: @(800,341) /sn:0 /w:[ 0 0 1 ]
  //: switch g32 (w3) @(709,242) /sn:0 /w:[ 0 ] /st:1
  xor g19 (.I0(w7), .I1(w8), .Z(w1));   //: @(702,280) /sn:0 /w:[ 0 5 3 ]
  //: joint g38 (w3) @(748, 242) /w:[ -1 2 1 4 ]
  //: frame g15 @(600,25) /sn:0 /anc:1 /wi:213 /ht:149 /tx:"Tutorials"
  //: comment g20 /dolink:1 /link:"@C/create_tut.v" @(630,55) /sn:0 /anc:1
  //: /line:"Creare un circuito"
  //: /end
  //: joint g39 (w8) @(648, 305) /w:[ -1 4 3 6 ]
  led g48 (.I(S));   //: @(834,261) /sn:0 /w:[ 1 ] /type:0
  led g43 (.I(w8));   //: @(626,286) /sn:0 /w:[ 9 ] /type:0
  //: comment g17 /dolink:0 /link:"@T/sim_tut.v" @(630,116) /sn:0
  //: /line:"Simulazione combinatoria"
  //: /end
  //: joint g42 (w7) @(625, 257) /w:[ 3 4 6 -1 ]
  //: comment g14 /dolink:1 /link:"@C/edit1_tut.v" @(630,70) /sn:0 /anc:1
  //: /line:"Manipolazioni base"
  //: /end
  //: switch g47 (w7) @(593,257) /sn:0 /w:[ 7 ] /st:1
  led g44 (.I(C));   //: @(837,322) /sn:0 /w:[ 0 ] /type:0
  led g36 (.I(w7));   //: @(625,237) /sn:0 /w:[ 5 ] /type:0
  //: comment g24 /dolink:1 /link:"@C/welcome_tut.v" @(630,40) /sn:0 /anc:1
  //: /line:"Introduzione a TkGate"
  //: /end
  //: comment g21 /dolink:1 /link:"@C/seqsim_tut.v" @(630,131) /sn:0
  //: /line:"Simulazione sequenziale"
  //: /end
  xor g41 (.I0(w3), .I1(w1), .Z(S));   //: @(799,278) /sn:0 /w:[ 7 0 0 ]
  //: comment g23 /dolink:0 /link:"" @(605,116) /sn:0
  //: /line:"->"
  //: /end
  nand g40 (.I0(w1), .I1(w3), .Z(w0));   //: @(746,312) /sn:0 /R:3 /w:[ 5 9 1 ]
  led g46 (.I(w3));   //: @(748,224) /sn:0 /w:[ 3 ] /type:0
  //: joint g45 (w7) @(657, 277) /w:[ 1 2 -1 8 ]
  //: joint g35 (w1) @(743, 280) /w:[ 1 -1 2 4 ]
  //: comment g22 /dolink:1 /link:"@C/edit2_tut.v" @(630,85) /sn:0 /anc:1
  //: /line:"Gruppi di oggetti"
  //: /end
  //: comment g12 /dolink:0 /link:"" @(16,18) /anc:1
  //: /line:"Questo tutorial introduce alla simulazione di circuiti combinatori in TkGate."
  //: /line:""
  //: /end
  nand g33 (.I0(w7), .I1(w8), .Z(w6));   //: @(707,343) /sn:0 /w:[ 9 7 1 ]
  //: joint g49 (w8) @(626, 305) /w:[ 2 8 1 -1 ]

endmodule
