package learningproject;

/**
 * <p>Title: VisualizzaDatiStudenteBehaviour</p>
 * <p>Description: Behaviour che consente di visualizzare i dati di uno studente</p>
 * @author Zito Daniela Dora
 * @version 1.0
 */
import jade.core.behaviours.*;

public class VisualizzaDatiStudenteBehaviour extends OneShotBehaviour
{
  private AgenteStudente studenteAgente;
  private Studente studente = null;
  private AgenteDocente docenteAgente;

  //Costruttori
  public VisualizzaDatiStudenteBehaviour(AgenteStudente studenteAgente)
  {
    super(studenteAgente);
  }
  public VisualizzaDatiStudenteBehaviour(AgenteDocente docenteAgente,
                                         Studente studente)
  {
    super(docenteAgente);
    this.studente = new Studente(studente.getNome(),studente.getCognome(),
                                 studente.getEMail(),studente.getMatricola(),
                                 studente.getLivelloAbilita());
  }

  //Metodi per l'accesso agli attributi
  public AgenteStudente getStudenteAgente()
  {
    return studenteAgente;
  }
  public AgenteDocente getDocente()
  {
    return docenteAgente;
  }
  public Studente getStudente()
  {
    return studente;
  }

  //Metodi per visualizzare lo studente
  public void docenteshowStudenteNomeCognomeEmailAbilita()
  {
    System.out.println(studente.studenteToStringNomeCognomeEmailAbilita());
  }
  public void showStudenteNomeCognome()
  {
    System.out.println(((AgenteStudente)myAgent).studenteToStringNomeCognome());
  }
  public void showStudenteNomeCognomeEmail()
  {
    System.out.println(((AgenteStudente)myAgent).studenteToStringNomeCognomeEmail());
  }
  public void showStudenteNomeCognomeEmailAbilita()
  {
    System.out.println(((AgenteStudente)myAgent).
                       studenteToStringNomeCognomeEmailAbilita());
  }
  public void showStudenteCompleto()
  {
    System.out.println(((AgenteStudente)myAgent).studenteToStringCompleta());
  }


  public void action()
  {
    System.out.println(myAgent+": visualizzazione dati studente:\n");
    if(studente == null) //l'agente proprietario del behaviour  lo studente
      showStudenteNomeCognomeEmailAbilita();
    else //l'agente proprietario del behaviour  il docente
      docenteshowStudenteNomeCognomeEmailAbilita();

      //Distruzione agente
//    myAgent.doDelete();
  }
}
