package learningproject;

/**
 * <p>Title: Studente</p>
 * <p>Description: Classe che descrive lo studente e che eredita dalla
* classe Persona.</p>
 * @author Zito Daniela Dora
 * @version 1.0
 */
import java.util.*;

public class Studente extends Persona
{
  //Attributi
  private String matricola;
  private Vector elencoCorsiSeguiti;
  private String learningStylePreferito;
  private String livelloAbilita;
  private Vector interessiPersonali;

  //Costruttori
  public Studente(String nome,String cognome, String email,String matricola)
  {
    super(nome, cognome, email);
    this.matricola = matricola;
  }
  public Studente(String nome,String cognome, String email,String matricola,
                  String livelloAbilita)
  {
    super(nome, cognome, email);
    this.matricola = matricola;
    this.livelloAbilita = livelloAbilita;
  }

  //Metodi per l'accesso agli attributi privati
  public void setMatricola(String matricola)
  {
    this.matricola = matricola;
  }
  //Inserimento di un corso nell'elenco
  public void insertCorso (CorsoSeguito nuovoCorso)
  {
    if(!elencoCorsiSeguiti.contains(nuovoCorso))
      elencoCorsiSeguiti.add(nuovoCorso);
  }
  //Eliminazione di un corso dall'elenco
  public void deleteCorso (CorsoSeguito vecchioCorso)
  {
    elencoCorsiSeguiti.remove(vecchioCorso);
  }
  public void setLearningStylePreferito(String learningStylePreferito)
  {
    this.learningStylePreferito = learningStylePreferito;
  }
  //Inserimento di un nuovo interesse
  public void insertInteresse(String nuovoInteresse)
  {
    if(!interessiPersonali.contains(nuovoInteresse))
      interessiPersonali.add(nuovoInteresse);
  }
  //Eliminazione di un interesse
  public void deleteInteresse (String vecchioInteresse)
  {
    interessiPersonali.remove(vecchioInteresse);
  }
  public void setLivelloAbilita(String livelloAbilita)
  {
    this.livelloAbilita = livelloAbilita;
  }
  public String getMatricola()
  {
    return matricola;
  }
  public Vector getElencoCorsiSeguiti()
  {
    return elencoCorsiSeguiti;
  }
  public String getLearningStylePreferito()
  {
    return learningStylePreferito;
  }
  public String getLivelloAbilita()
  {
    return livelloAbilita;
  }
  public Vector getInteressiPersonali()
  {
    return interessiPersonali;
  }

  //Metodi per convertire lo studente in stringa
  public String studenteToStringNomeCognome()
  {
    String studente_stringa = super.personaToStringNomeCognome();
    studente_stringa += "Matricola: " + matricola + "\n";
    return studente_stringa;
  }
  public String studenteToStringNomeCognomeEmail()
  {
    String studente_stringa = super.personaToStringNomeCognomeEmail();
    studente_stringa += "Matricola: " + matricola + "\n";
    return studente_stringa;
  }
  public String studenteToStringNomeCognomeEmailAbilita()
  {
    String studente_stringa = super.personaToStringNomeCognomeEmail();
    studente_stringa += "Matricola: " + matricola + "\n";
    studente_stringa += "Livello abilit: " + livelloAbilita + "\n";
    return studente_stringa;
  }
  public String studenteToStringCompleta()
  {
    String studente_stringa = super.personaToStringCompleta();
    studente_stringa += "Matricola: " + matricola + "\n";
    studente_stringa += "Learning Style Preferito: " + learningStylePreferito + "\n";
    studente_stringa += "Elenco Corsi Seguiti: " +"\n";
    for(int i=0; i<elencoCorsiSeguiti.size(); i++)
    {
      studente_stringa += elencoCorsiSeguiti.elementAt(i).toString() + "\n";
    }
    for(int i=0; i<interessiPersonali.size(); i++)
    {
      studente_stringa += interessiPersonali.elementAt(i).toString() + "\n";
    }
    studente_stringa += "Livello di abilit conseguito: "+livelloAbilita +"\n";
    return studente_stringa;
  }
}

