package learningproject;

/**
 * <p>Title: SelezionequizBehaviour</p>
* <p>Description: Behaviour che permette di processare una richiesta di selezione
*  quiz e di inviare le proposte al mittente solo se rispettano
* i criteri di selezione imposti.</p>
 * @author Zito Daniela Dora
 * @version 1.0
 */
import jade.core.behaviours.*;
import jade.lang.acl.*;
import java.lang.String;

public class SelezioneQuizBehaviour extends CyclicBehaviour
{
  private Quiz quizTrovato;

  //Costruttore
  public SelezioneQuizBehaviour(AgenteCorso agenteCorso)
  {
    super(agenteCorso);
  }


  public void action()
  {
    MessageTemplate template = MessageTemplate.MatchPerformative(ACLMessage.CFP);
    //Ricezione delle richieste che fanno match con il template
    ACLMessage messaggio = myAgent.receive(template);
    //Se il messaggio di richiesta non  vuoto viene processato
    if(messaggio != null)
    {
      String difficolta = messaggio.getContent();
      ACLMessage risposta = messaggio.createReply();

      //PER SEMPLICITA' LA SELEZIONE DEI QUIZ E' FATTA SOLO IN BASE AL
      //LIVELLO DI DIFFICOLTA'
      for (int i=0; i<((AgenteCorso)myAgent).getElencoQuiz().size(); i++)
      {
        quizTrovato = (Quiz) ((AgenteCorso)myAgent).getElencoQuiz().get(i);
        if(quizTrovato.getDifficolta().equals(difficolta))
        {
          //Il quiz ha lo stesso livello di difficolt richiesto dallo studente
          risposta.setPerformative(ACLMessage.PROPOSE);

          //PER SEMPLICITA' IL CORSO RISPONDE CON UNA STRINGA
          //CHE RAPPRESENTA IL QUIZ
          risposta.setContent(quizTrovato.quizToString());
          break;
        }
        else
        {
            //Non c' disponibilit
            risposta.setPerformative(ACLMessage.REFUSE);
            risposta.setContent("Non disponibile");
        }
      }
      myAgent.send(risposta);
    }
    else
    {
        block();
    }

    //Distruzione agente
//  myAgent.doDelete();
  }
}
