package learningproject;

/**
 * <p>Title: SelezioneEsecuzioneQuizBehaviour</p>
 * <p>Description: Behaviour che permette di selezionare un quiz in base ad un
* certo criterio, di inviare le risposte al docente e di ricevere il
* voto relativo.</p>
 * @author Zito Daniela Dora
 * @version 1.0
 */
import jade.core.behaviours.*;
import jade.core.*;
import jade.lang.acl.*;

public class SelezioneEsecuzioneQuizBehaviour extends Behaviour
{
  private AID sender;
  private MessageTemplate messageTemplate;
  private ACLMessage risposta;
  private AID docente;
  private String stringaQuiz;
  int step = 0;
  String voto = null;

  //Costruttore
  public SelezioneEsecuzioneQuizBehaviour(AgenteStudente agenteStudente)
  {
    super(agenteStudente);
  }

  public void action()
  {
    switch(step)
    {
        case 0:
          //Invio del messaggio di richiesta del quiz all'agente corso
          //PER SEMPLICITA' IL MESSAGGIO E' INVIATO AD UN CORSO QUALUNQUE
          ACLMessage messaggio = new ACLMessage(ACLMessage.CFP);
          AID receiver = new AID("AgenteCorso", false);
          messaggio.addReceiver(receiver);

          //PER SEMPLICITA' LA SELEZIONE DEL QUIZ E' FATTA SOLO IN BASE AL
          //LIVELLO DI DIFFICOLTA'
          messaggio.setContent(((AgenteStudente)myAgent).getLivelloAbilita());
          messaggio.setConversationId("Ricerca quiz");
          messaggio.setReplyWith("CFP" + System.currentTimeMillis());
          myAgent.send(messaggio);

          //Preparazione template per la ricezione delle proposte
          messageTemplate = MessageTemplate.and
              (MessageTemplate.MatchConversationId("Ricerca quiz"),
               MessageTemplate.MatchInReplyTo(messaggio.getReplyWith()));
          step = 1;
          break;

        case 1:
          //Ricezione delle proposte di quiz e dei rifiuti
          ACLMessage risposta = myAgent.receive(messageTemplate);
          if (risposta != null)
          {
            if (risposta.getPerformative() == ACLMessage.PROPOSE)
            {
              //PER SEMPLICITA' IL CORSO RISPONDE CON UNA STRINGA
              //CHE RAPPRESENTA IL QUIZ
              sender = risposta.getSender();
              stringaQuiz = risposta.getContent();
            }
          }
          else
          {
              block();
          }
          break;

        case 2:
          //Invio del messaggio di conferma al corso
          ACLMessage conferma = new ACLMessage(ACLMessage.ACCEPT_PROPOSAL);
          conferma.addReceiver(sender);
          conferma.setContent(stringaQuiz);
          conferma.setConversationId("Conferma quiz");
          conferma.setReplyWith("Conferma " + System.currentTimeMillis());
          myAgent.send(conferma);

          //Preparazione template per recuperare la risposta alla conferma
          messageTemplate = MessageTemplate.and
              (MessageTemplate.MatchConversationId("Conferma quiz"),
               MessageTemplate.MatchInReplyTo(conferma.getReplyWith()));
          step = 3;
          break;

        case 3:
          //Ricezione risposta alla conferma
          risposta = myAgent.receive(messageTemplate);
          if(risposta != null)
          {
            //Conferma ricevuta correttamente
            if(risposta.getPerformative() == ACLMessage.INFORM)
            {
              //Scelta quiz eseguita correttamente.
              //Mostro il quiz che deve essere eseguito
              System.out.println("Quiz scelto correttamente\n "+
                                 stringaQuiz);
            }
            else
            {
                System.out.println("Fallimento!");
            }
            step = 4;
          }
          else
          {
              block();
          }

        case 4:
          //Creazione risposta del quiz e invio al docente
          //PER SEMPLICITA' LA RISPOSTA E' CREATA QUI
          String rispostaQuiz = "Risposta 1";
          ACLMessage rispostaQuizAcl = new ACLMessage(ACLMessage.INFORM);
          docente = new AID("AgenteDocente", false);
          rispostaQuizAcl.addReceiver(docente);
          rispostaQuizAcl.setContent(rispostaQuiz);
          rispostaQuizAcl.setConversationId("Invio risposte");
          rispostaQuizAcl.setReplyWith(voto);
          myAgent.send(rispostaQuizAcl);

          //Preparazione template per la ricezione del voto
          messageTemplate = MessageTemplate.and
              (MessageTemplate.MatchConversationId("Invio risposte"),
               MessageTemplate.MatchInReplyTo(rispostaQuizAcl.getReplyWith()));
          step = 5;
          break;

        case 5:
          //Ricezione del voto
          ACLMessage rispostaVoto = myAgent.receive(messageTemplate);
          //Se la risposta  stata ricevuta invio il messaggio di conferma
          if(rispostaVoto != null)
          {
            if(rispostaVoto.getPerformative() == ACLMessage.INFORM)
            {
              voto = rispostaVoto.getContent();
            }
          }
          else
          {
              block();
          }
          step = 6;
          break;

        case 6:
          //Invio del messaggio di conferma al docente
          ACLMessage confermaVoto = new ACLMessage(ACLMessage.ACCEPT_PROPOSAL);
          confermaVoto.addReceiver(docente);
          confermaVoto.setContent(voto);
          confermaVoto.setConversationId("Memorizzazione voto");
          confermaVoto.setReplyWith("Conferma voto "+System.currentTimeMillis());;
          myAgent.send(confermaVoto);
          step = 7;
          break;
        }

    //Distruzione agente
//    myAgent.doDelete();
  }

  public boolean done()
  {
    if(step==7)
      System.out.println("Terminazione");
    return (step == 7);
  }
}
