package learningproject;

/**
 * <p>Title: SelezioneCorsoBehaviour</p>
 * <p>Description: Behaviour che permette di processare una richiesta di selezione
*  corso e di inviare le proposte al mittente solo se rispettano
* i criteri di selezione imposti.</p>
 * @author Zito Daniela Dora
 * @version 1.0
 */
import jade.core.behaviours.*;
import jade.lang.acl.*;
import java.lang.String;

public class SelezioneCorsoBehaviour extends CyclicBehaviour
{
  //Costruttore
  public SelezioneCorsoBehaviour(AgenteCorso agenteCorso)
  {
    super(agenteCorso);
  }

  public void action()
  {
    MessageTemplate template = MessageTemplate.MatchPerformative(ACLMessage.CFP);

    //Ricezione delle richieste che fanno match con il template
    ACLMessage messaggio = myAgent.receive(template);
    System.out.println(myAgent+" esegue SelezioneCorsoBehaviour: messaggio ricevuto!"+messaggio+"\n");
    //Se il messaggio di richiesta non  vuoto viene processato
    if(messaggio != null)
    {
      String livelloDifficolta = messaggio.getContent();
      System.out.println(myAgent+" esegue SelezioneCorsoBehaviour: livello ricevuto: "+livelloDifficolta+ "\n");
      ACLMessage risposta = messaggio.createReply();

      //PER SEMPLICITA' LA SELEZIONE DEL CORSO E' FATTA SOLO IN BASE AL
      //LIVELLO DI DIFFICOLTA'
      System.out.println(myAgent+" esegue SelezioneCorsoBehaviour: difficolt corso: "+((AgenteCorso)myAgent).getDifficolta()+"\n");
      if(((AgenteCorso)myAgent).getDifficolta().equals(livelloDifficolta))
      {
        //Il corso ha lo stesso livello di difficolt richiesto dallo studente
        System.out.println(myAgent+" esegue SelezioneCorsoBehaviour: livello abilit corretto!\n");
        risposta.setPerformative(ACLMessage.PROPOSE);

        //PER SEMPLICITA' IL CORSO RISPONDE INVIANDO IL SUO NOME
        risposta.setContent(((AgenteCorso)myAgent).getNome());
        System.out.println(myAgent+" esegue SelezioneCorsoBehaviour: risposta " +risposta+"\n" );
      }
      else
      {
          //Non c' disponibilit
          risposta.setPerformative(ACLMessage.REFUSE);
          risposta.setContent(myAgent+" esegue SelezioneCorsoBehaviour: non disponibilit\n");
      }
      myAgent.send(risposta);
    }
    else
    {
        System.out.println(myAgent+" esegue SelezioneCorsoBehaviour: messaggio vuoto\n");
        block();
    }

    //Distruzione agente
//  myAgent.doDelete();
  }
}
