package learningproject;

/**
 * <p>Title: Quiz</p>
* <p>Description: Classe che descrive un quiz
* specificando il titolo, la data di creazione, l'argomento, il livello di
* difficolt e il contenuto</p>
 * @author Zito Daniela Dora
 * @version 1.0
 */

import java.util.*;

public class Quiz
{
  private String titolo;
  private String data_creazione;
  private String argomento;
  private String domanda;
  private Vector choices;
  private String difficolta;

  //Costruttori
  public Quiz()
  {
    this.data_creazione = null;
    this.argomento = null;
    this.domanda = null;
    this.choices = new Vector();
    this.difficolta = null;
  }
  public Quiz(String titolo,String data_creazione,String argomento,
              String domanda,Vector choices,String difficolta )
  {
    this.titolo = titolo;
    this.data_creazione = data_creazione;
    this.argomento = argomento;
    this.domanda = domanda;
    this.difficolta = difficolta;
    this.choices = new Vector(choices);
  }

  //Metodi per l'accesso agli attributi
  public void setTitolo(String titolo)
  {
    this.titolo = titolo;
  }
  public void setData(String data_creazione)
  {
    this.data_creazione = data_creazione;
  }
  public void setArgomento(String argomento)
  {
    this.argomento = argomento;
  }
  public void setDomanda(String domanda)
  {
    this.domanda = domanda;
  }
  //Inserimento di una choice nel quiz
  public void insertChoice (String nuova_choice)
  {
    if(!choices.contains(nuova_choice))
      choices.add(nuova_choice);
  }
  //Eliminazione di una choice dal quiz
  public void deleteChoice (String vecchia_choice)
  {
    choices.remove(vecchia_choice);
  }
  public void setDifficolta(String difficolta)
  {
    this.difficolta = difficolta;
  }
  public String getTitolo()
  {
    return titolo;
  }
  public String getData()
  {
    return data_creazione;
  }
  public String getArgomento()
  {
    return argomento;
  }
  public String getDomanda()
  {
    return domanda;
  }
  public Vector getChoices()
  {
    return choices;
  }
  public String getDifficolta()
  {
    return difficolta;
  }

//Metodi per convertire il quiz in stringa
  public String quizToString()
  {
    String quiz_stringa = titolo + "\n";
    quiz_stringa += "Data creazione: " + data_creazione.toString() + "\n";
    quiz_stringa += argomento + "\n";
    quiz_stringa += domanda + "\n";
    if(!choices.isEmpty())
      for(int i=1; i<=choices.size(); i++)
        quiz_stringa += i +") " + choices.get(i) + "\n"; //CONTROLLARE SE SERVE IL CAST
    quiz_stringa += "Livello di difficolt: " +difficolta + "\n";
    return quiz_stringa;
  }

  //Metodo per mostrare a video il quiz
  public void showQuiz()
  {
    System.out.println(this.quizToString());
  }
}
