package learningproject;

/**
 * <p>Title: Persona </p>
 * <p>Description: Classe che descrive la persona.</p>
 * @author Zito Daniela Dora
 * @version 1.0
 */

public class Persona
{
  //Attributi
  private String nome;
  private String cognome;
  private Indirizzo indirizzo;
  private String e_mail;

  //Costruttori
  public Persona(String nome,String cognome,String e_mail)
  {
    this.nome = nome;
    this.cognome = cognome;
    this.e_mail = e_mail;
  }
  public Persona(String nome,String cognome,Indirizzo indirizzo,String e_mail)
  {
    this.nome = nome;
    this.cognome = cognome;
    this.e_mail = e_mail;
    this.indirizzo = new Indirizzo(indirizzo.getCitta(), indirizzo.getVia(),
                                   indirizzo.getNumeroCivico(),indirizzo.getCap(),
                                   indirizzo.getNazione());
  }

  //Metodi per l'accesso agli attributi
  public void setNome(String nome)
  {
    this.nome = nome;
  }
  public void setCognome(String cognome)
  {
    this.cognome = cognome;
  }
  public void setIndirizzo(Indirizzo indirizzo)
  {
    this.indirizzo = indirizzo;
  }
  public void setEMail(String e_mail)
  {
    this.e_mail = e_mail;
  }
  public String getNome()
  {
    return nome;
  }
  public String getCognome()
  {
    return cognome;
  }
  public Indirizzo getIndirizzo()
  {
    return indirizzo;
  }
  public String getEMail()
  {
    return e_mail;
  }

  //Metodi per convertire la persona in stringa
  public String personaToStringNomeCognome()
  {
    String persona_stringa = "Nome:" +nome + "\n";
    persona_stringa += "Cognome: " + cognome + "\n";
    return persona_stringa;
  }
  public String personaToStringNomeCognomeEmail()
  {
    String persona_stringa = "Nome:" + nome + "\n";
    persona_stringa += "Cognome: " + cognome + "\n";
    persona_stringa += "Email: " + e_mail + "\n";
    return persona_stringa;
  }
  public String personaToStringCompleta()
  {
    String persona_stringa = "Nome:" + nome + "\n";
    persona_stringa += "Cognome: " + cognome + "\n";
    persona_stringa += "Indirizzo: " + indirizzo.indirizzoToString() + "\n";
    persona_stringa += "Email: " + e_mail + "\n";
    return persona_stringa;
  }
}



