package learningproject;

/**
 * <p>Title: InviaRiceviPreferenzeCorsoBehaviour</p>
 * <p>Description: Behaviour che permette di selezionare un corso.</p>
 * @author Zito Daniela Dora
 * @version 1.0
 */
import jade.core.behaviours.*;
import jade.domain.FIPAAgentManagement.*;
import jade.domain.*;
import jade.core.*;
import jade.lang.acl.*;

public class InviaRiceviPreferenzeCorsoBehaviour extends Behaviour
{
  private int numRisposte = 0;
  private AID[] corsiTrovati = null;
  private MessageTemplate messageTemplate;
  private AID corsoMiglioreTrovatoAID;
  private Corso corsoMigliore;
  private CorsoSeguito corsoMiglioreDaSeguire;
  private ACLMessage risposta;
  int step = 0;

  //Costruttore
  public InviaRiceviPreferenzeCorsoBehaviour(AgenteStudente studenteAgente)
  {
    super(studenteAgente);
  }

  public void action()
  {
    //Ricerca dei corsi disponibili tra quelli registrati nelle yellow pages
    DFAgentDescription template = new DFAgentDescription ();
    ServiceDescription descrizione = new ServiceDescription ();
    descrizione.setType("Corsi");
    template.addServices(descrizione);
    try
    {
//    myAgent.doWait(5000);
      DFAgentDescription[] risultato = DFService.search(myAgent,template);
      System.out.println(myAgent+" esegue InviaRiceviPreferenzeCorsoBehaviour: trovati i seguenti corsi: ");
      corsiTrovati = new AID[risultato.length];
      for(int i=0; i<risultato.length; ++i)
      {
        corsiTrovati[i] = risultato[i].getName();
        System.out.println(corsiTrovati[i].getName());
      }
    }
    catch (Exception fe){fe.printStackTrace();}
    System.out.println();
    switch(step)
    {
        case 0:
          //Invio del messaggio di richiesta a tutti i corsi trovati
          ACLMessage messaggio = new ACLMessage(ACLMessage.CFP);
          for (int j = 0; j < corsiTrovati.length; ++j)
          {
            messaggio.addReceiver(corsiTrovati[j]);
          }
          //PER SEMPLICITA' LA SELEZIONE E' FATTA SOLO IN BASE AL LIVELLO DI ABILITA'
          messaggio.setContent(((AgenteStudente)myAgent).getLivelloAbilita());
          System.out.println(myAgent.getName()+" esegue InviaRiceviPreferenzeCorsoBehaviour: contenuto messaggio:\n"
                             +((AgenteStudente)myAgent).getLivelloAbilita()+"\n");
          messaggio.setConversationId("Ricerca corso");
          messaggio.setReplyWith("CFP" + System.currentTimeMillis());
          myAgent.send(messaggio);
          System.out.println(myAgent.getName()+" esegue InviaRiceviPreferenzeCorsoBehaviour: messaggio completo "+messaggio+"\n");

          //Preparazione template per la ricezione delle proposte
          messageTemplate = MessageTemplate.and
              (MessageTemplate.MatchConversationId("Ricerca corso"),
               MessageTemplate.MatchInReplyTo(messaggio.getReplyWith()));
          step = 1;
          break;

        case 1:
          //Ricezione delle proposte e dei rifiuti da parte dei corsi
          risposta = myAgent.receive(messageTemplate);
          if (risposta != null)
          {
            if (risposta.getPerformative() == ACLMessage.PROPOSE)
            {
              corsoMiglioreTrovatoAID = risposta.getSender();
              System.out.println(myAgent+" esegue InviaRiceviPreferenzeCorsoBehaviour: ricevuta proposta "+risposta+"\n");
            }
            numRisposte++;
            if (numRisposte >= corsiTrovati.length)
            {
              //Ricevute tutte le risposte
              step = 2;
            }
          }
          else
          {
              block();
          }
          break;

        case 2:
          //Invio del messaggio di conferma al corso scelto
          ACLMessage conferma = new ACLMessage(ACLMessage.ACCEPT_PROPOSAL);
          conferma.addReceiver(corsoMiglioreTrovatoAID);
          conferma.setContent(risposta.getContent());
          conferma.setConversationId("Conferma corso");
          conferma.setReplyWith("Conferma " + System.currentTimeMillis());
          myAgent.send(conferma);

          //Preparazione template per recuperare la risposta alla conferma
          messageTemplate = MessageTemplate.and
              (MessageTemplate.MatchConversationId("Conferma corso"),
               MessageTemplate.MatchInReplyTo(conferma.getReplyWith()));
          step = 3;
          break;

        case 3:
          //Ricezione risposta alla conferma
          risposta = myAgent.receive(messageTemplate);
          if(risposta != null)
          {
            //Conferma ricevuta correttamente
            if(risposta.getPerformative() == ACLMessage.INFORM)
            {
              //Scelta corso eseguita correttamente
              System.out.println(myAgent+" esegue InviaRiceviPreferenzeCorsoBehaviour: corso scelto correttamente "+
                                 risposta.getSender().getName()+"\n");
              //Aggiungo il corso all'elenco dei corsi seguiti dello studente
              //PER SEMPLICITA' COSTRUISCO IL CORSO SOLO IN BASE AL NOME
              corsoMigliore = new Corso(risposta.getContent());
              Studente studente = new Studente(((AgenteStudente)myAgent).getNome(),
                                               ((AgenteStudente)myAgent).getCognome(),
                                               ((AgenteStudente)myAgent).getEMail(),
                                               ((AgenteStudente)myAgent).getMatricola(),
                                               ((AgenteStudente)myAgent).getLivelloAbilita());
              corsoMiglioreDaSeguire = new CorsoSeguito(studente,corsoMigliore);
//            studente.insertCorso(corsoMiglioreDaSeguire);
//            ((AgenteStudente)myAgent).insertCorso(corsoMiglioreDaSeguire);
              //Aggiungo lo studente all'elenco studenti del corso
//            corsoMigliore.insertStudente(studente);
            }
            else
            {
                System.out.println(myAgent+" esegue InviaRiceviPreferenzeCorsoBehaviour: fallimento!\n");
            }
            step = 4;
          }
          else
          {
              block();
          }
          break;
        }

        //Distruzione agente
//      myAgent.doDelete();
  }

  public boolean done()
  {
    if(step==4)
      System.out.println(myAgent+" esegue InviaRiceviPreferenzeCorsoBehaviour: terminazione\n");
    return (step == 4);
  }
}
