package learningproject;

/**
 * <p>Title: Indirizzo</p>
 * <p>Description: Classe che descrive l'indirizzo costituito da
* citt, via, numero civico, cap e nazione.</p>
  * @author Zito Daniela Dora
 * @version 1.0
 */

public class Indirizzo
{
  //Attributi
  private String citta;
  private String via;
  private String numero_civico; //Il numero civico pu essere alfanumerico
  private int cap;
  private String nazione;

  //Costruttori
  public Indirizzo (String citta, String via, String numero_civico, int cap,
                    String nazione)
  {
    this.citta = citta;
    this.via = via;
    this.numero_civico = numero_civico;
    this.cap = cap;
    this.nazione = nazione;
  }

  //Metodi per l'accesso agli attributi
  public void setCitta(String citta)
  {
    this.citta = citta;
  }
  public void setVia(String via)
  {
    this.via = via;
  }
  public void setNumeroCivico(String numero_civico)
  {
    this.numero_civico = numero_civico;
  }
  public void setCap (int cap)
  {
    this.cap = cap;
  }
  public void setNazione(String nazione)
  {
    this.nazione = nazione;
  }
  public String getCitta()
  {
    return citta;
  }
  public String getVia()
  {
    return via;
  }
  public String getNumeroCivico()
  {
    return numero_civico;
  }
  public int getCap()
  {
    return cap;
  }
  public String getNazione()
  {
    return nazione;
  }

  //Metodi per convertire l'indirizzo in stringa
  public String indirizzoToString()
  {
    String indirizzo_stringa = "Via" +via + "\n";
    indirizzo_stringa += "Numero civico: " + numero_civico + "\n";
    indirizzo_stringa += "Citt:" +citta + "\n";
    indirizzo_stringa += "Cap:" +cap + "\n";
    indirizzo_stringa += "Nazione: " +nazione + "\n";
    return indirizzo_stringa;
  }

  //Metodo per la visualizzazione dell'indirizzo
  public void showIndirizzo()
  {
    System.out.println(this.indirizzoToString());
  }
}
