package learningproject;

/**
 * <p>Title: Docente</p>
 * <p>Description: Classe che descrive il docente e che estende la classe persona.</p>
 * @author Zito Daniela Dora
 * @version 1.0
 */
import java.util.*;

public class Docente extends Persona
{
  //Attributi
  private String matricola;
  private Vector elencoCorsi;

  //Costruttori
  public Docente(String nome, String cognome, String email)
  {
    super(nome, cognome, email);
  }
  public Docente(String nome, String cognome, String email, String matricola)
  {
    super(nome, cognome, email);
    this.matricola = matricola;
  }
  public Docente(String nome, String cognome, String email, Vector elencoCorsi)
  {
    super(nome, cognome, email);
    this.elencoCorsi = new Vector (elencoCorsi);
  }
  public Docente(String nome, String cognome, String email, String matricola,
                 Vector elencoCorsi)
  {
    super(nome, cognome, email);
    this.matricola = matricola;
    this.elencoCorsi = new Vector (elencoCorsi);
  }
  public Docente (String nome, String cognome, String email, Indirizzo indirizzo,
                  String matricola, Vector elencoCorsi)
  {
    super(nome, cognome, indirizzo, email);
    this.matricola = matricola;
    this.elencoCorsi = new Vector (elencoCorsi);
  }

  //Metodi per l'accesso agli attributi
  public void setMatricola(String matricola)
  {
    this.matricola = matricola;
  }
  //Inserimento di un corso nell'elenco
  public void insertCorso (Corso nuovo_corso)
  {
    if(!elencoCorsi.contains(nuovo_corso))
      elencoCorsi.add(nuovo_corso);
  }
  //Eliminazione di un corso dall'elenco
  public void deleteCorso (Corso vecchio_corso)
  {
    elencoCorsi.remove(vecchio_corso);
  }
  public String getMatricola()
  {
    return matricola;
  }
  public Vector getElencoCorsi()
  {
    return elencoCorsi;
  }
}
