package learningproject;

/**
 * <p>Title: CorsoSeguito</p>
 * <p>Description: Classe che descrive ogni corso seguito da
* uno studente e il voto conseguito.</p>
 * @author Zito Daniela Dora
 * @version 1.0
 */

public class CorsoSeguito
{
  //Attributi
  private Studente studente;
  private Corso corso;
  private String voto;

  //Costruttori
  public CorsoSeguito(Corso corso)
  {
    this.corso = new Corso(corso.getNome());
  }
  public CorsoSeguito(Studente studente,Corso corso)
  {
    this.studente = new Studente(studente.getNome(), studente.getCognome(),
                                 studente.getEMail(), studente.getMatricola(),
                                 studente.getLivelloAbilita());
    this.corso = new Corso(corso.getNome());
  }
  public CorsoSeguito(Studente studente, Corso corso, String voto)
  {
    this.studente = new Studente(studente.getNome(), studente.getCognome(),
                                 studente.getEMail(), studente.getMatricola());
    this.corso = new Corso(corso.getNome(), corso.getCodice(), corso.getDocente());
  }

  //Metodi per l'accesso agli attributi privati
  public void setVoto(String voto)
  {
    this.voto = voto;
  }
  public Studente getStudente()
  {
    return studente;
  }
  public Corso getCorso()
  {
    return corso;
  }
  public String getVoto()
  {
    return voto;
  }
}
