package learningproject;

/**
 * <p>Title: Corso/p>
 * <p>Description: Classe che descrive il corso.</p>
 * @author Zito Daniela Dora
 * @version 1.0
 */
import java.util.*;

public class Corso
{
  //Attributi
  private String nome;
  private String codice;
  private Vector materialeDidattico;
  private Vector elencoQuiz;
  private Vector learningStyle; //scritto, orale, progetto, altro
  private Docente docente;
  private String descrizione;
  private Vector elencoStudenti;
  private String difficolta;

  //Costruttori
  public Corso(String nome)
  {
    this.nome = nome;
  }
  public Corso(String nome, String codice, Docente docente)
  {
    this.nome = nome;
    this.codice = codice;
    this.docente = new Docente(docente.getNome(),docente.getCognome(),
                               docente.getEMail(),docente.getMatricola());
  }
  public Corso(String nome, String codice,Vector materialeDidattico,
               Vector elencoQuiz, Vector learningStyle, Docente docente,
               String descrizione, Vector elencoStudenti,String difficolta)
  {
    this.nome = nome;
    this.codice = codice;
    this.elencoQuiz = new Vector(elencoQuiz);
    this.learningStyle = new Vector(learningStyle);
    this.docente = new Docente(docente.getNome(),docente.getCognome(),
                               docente.getEMail(),docente.getMatricola());
    this.descrizione = descrizione;
    this.elencoStudenti = new Vector(elencoStudenti);
  }

  //Metodi per l'accesso agli attributi privati
  public void setNome(String nome)
  {
    this.nome = nome;
  }
  public void setCodice(String codice)
  {
    this.codice = codice;
  }
  //Inserimento di nuovo materiale
  //PER SEMPLICITA' IL MATERIALE DIDATTICO E' UNA STRINGA
  public void insertMaterialeDidattico (String nuova_lettura)
  {
    if (!materialeDidattico.contains(nuova_lettura))
      materialeDidattico.add(nuova_lettura);
  }
  //Eliminazione di materiale
  public void deleteMaterialeDidattico (String vecchia_lettura)
  {
    materialeDidattico.remove(vecchia_lettura);
  }
  //Inserimento di nuovo quiz nell'elenco
  public void insertQuiz (Quiz nuovo_quiz)
  {
    if (!elencoQuiz.contains(nuovo_quiz))
      elencoQuiz.add(nuovo_quiz);
  }
  //Eliminazione di quiz dall'elenco
  public void deleteQuiz (Quiz vecchio_quiz)
  {
    elencoQuiz.remove(vecchio_quiz);
  }
  //Inserimento di un nuovo learning style
  public void insertLearningStyle (String nuovo_learningStyle)
  {
    if (!learningStyle.contains(nuovo_learningStyle))
      learningStyle.add(nuovo_learningStyle);
  }
  //Eliminazione di learning style
  public void deleteLearningStyle (String vecchio_learningStyle)
  {
    learningStyle.remove(vecchio_learningStyle);
  }
  public void setDescrizione(String descrizione)
  {
    this.descrizione = descrizione;
  }
  //Inserimento di nuovo studente
  public void insertStudente (Studente nuovo_studente)
  {
    if (!elencoStudenti.contains(nuovo_studente))
      elencoStudenti.add(nuovo_studente);
  }
  //Eliminazione di uno studente
  public void deleteStudente (Studente vecchio_studente)
  {
    elencoStudenti.removeElement(vecchio_studente);
  }
  public void setDocente(Docente docente)
  {
    this.docente = docente;
  }
  public void setDifficolta(String difficolta)
  {
    this.difficolta = difficolta;
  }
  public String getNome()
  {
    return nome;
  }
  public String getCodice()
  {
    return codice;
  }
  public Vector getMaterialeDidattico()
  {
    return materialeDidattico;
  }
  public Vector getElencoQuiz()
  {
    return elencoQuiz;
  }
  public Vector getLearningStyle()
  {
    return learningStyle;
  }
  public Docente getDocente()
  {
    return docente;
  }
  public String getDescrizione()
  {
    return descrizione;
  }
  public Vector getElencoStudenti()
  {
    return elencoStudenti;
  }
  public String getDifficolta()
  {
    return this.difficolta;
  }
}
