package learningproject;

/**
 * <p>Title: CorrezioneQuizBehaviour</p>
 * <p>Description: Behaviour che permette di ricevere una risposta ad un quiz,
* generare un voto e inviarlo al mittente </p>
 * @author Zito Daniela Dora
 * @version 1.0
 */
import jade.core.behaviours.*;
import jade.lang.acl.*;

public class CorrezioneQuizBehaviour extends OneShotBehaviour
{
  int step = 0;
  private MessageTemplate messageTemplate;

  //Costruttore
  public CorrezioneQuizBehaviour(AgenteDocente agenteDocente)
  {
    super(agenteDocente);
  }

  public void action()
  {
    switch (step)
    {
        case 0:
          //Ricezione risposte inviate dallo studente
          MessageTemplate template = MessageTemplate.MatchPerformative(ACLMessage.INFORM);
          ACLMessage messaggio = myAgent.receive(template);

          //Se la risposta  stata ricevuta ed  corretta invio del voto del corso
          if (messaggio != null)
          {
            String rispostaVoto = messaggio.getContent();
            System.out.println(rispostaVoto);

            //Preparazione del voto e invio
            //PER SEMPLICITA' IL VOTO E' CREATO QUI
            ACLMessage messaggioVoto = messaggio.createReply();
            String voto = "Principiante";
            messaggioVoto.setContent(voto);
            myAgent.send(messaggioVoto);

            //Preparazione template per la ricezione delle conferme
            messageTemplate = MessageTemplate.and
                (MessageTemplate.MatchConversationId("Memorizzazione voto"),
                 MessageTemplate.MatchInReplyTo(messaggioVoto.getReplyWith()));
          }
          else
          {
              block();
          }
          step = 1;
          break;

        case 1:
          //Ricezione del messaggio di conferma inviato dallo studente
          ACLMessage conferma = myAgent.receive();

          //Se la conferma  stata ricevuta invio un nuovo messaggio di conferma
          if (conferma != null)
          {
            if (conferma.getPerformative() == ACLMessage.ACCEPT_PROPOSAL)
            {
              System.out.println("Invio voto avvenuto con successo\n");
            }
            step = 2;
          }
          else
          {
              block();
          }
          break;
        }

      //Distruzione agente
//    myAgent.doDelete();
   }
}
