package learningproject;

/**
 * <p>Title: ConfermaSceltaQuizBehaviour</p>
 * <p>Description: Behaviour che permette di confermare la scelta del quiz.</p>
 * @author Zito Daniela Dora
 * @version 1.0
 */

import jade.core.behaviours.*;
import jade.lang.acl.*;
import java.lang.String;

public class ConfermaSceltaQuizBehaviour extends CyclicBehaviour
{
  //Costruttore
  public ConfermaSceltaQuizBehaviour(AgenteCorso agenteCorso)
  {
    super(agenteCorso);
  }

  public void action()
  {
    MessageTemplate template = MessageTemplate.MatchPerformative
        (ACLMessage.ACCEPT_PROPOSAL);
    ACLMessage messaggio = myAgent.receive(template);

    //Se il messaggio non  vuoto viene processato
    if(messaggio != null)
    {
      String stringaQuiz = messaggio.getContent();
      ACLMessage risposta = messaggio.createReply();

      //Controllo nell'elenco che il quiz scelto dallo studente sia corretto
      for (int i=0; i<((AgenteCorso)myAgent).getElencoQuiz().size(); i++)
      {
        Quiz quizCorrente = (Quiz) ((AgenteCorso)myAgent).getElencoQuiz().get(i);
        if (quizCorrente.quizToString().equals(stringaQuiz))
        {
          risposta.setPerformative(ACLMessage.INFORM);
          System.out.println("Quiz assegnato all'agente " +
                             messaggio.getSender().getName());
          //PER SEMPLICITA' IL MESSAGGIO DI CONFERMA NON HA CONTENUTO
      //  risposta.setContent("");
        }
        else
        {
            //Non c' disponibilit
            risposta.setPerformative(ACLMessage.FAILURE);
            risposta.setContent("Non disponibilit");
        }
      }
      myAgent.send(risposta);
    }
    else
    {
        block();
    }

    //Distruzione agente
//  myAgent.doDelete();
  }
}
