package learningproject;

/**
 * <p>Title: ConfermaSceltaCorsoBehaviour</p>
 * <p>Description: Behaviour che permette di confermarmare
* la scelta del corso fatta dallo studente</p>
 * @author Zito Daniela Dora
 * @version 1.0
 */

import jade.core.behaviours.*;
import jade.lang.acl.*;
import java.lang.String;

public class ConfermaSceltaCorsoBehaviour extends CyclicBehaviour
{
  //Costruttore
  public ConfermaSceltaCorsoBehaviour(AgenteCorso agenteCorso)
  {
    super(agenteCorso);
  }

  public void action()
  {
    MessageTemplate template = MessageTemplate.MatchPerformative(ACLMessage.ACCEPT_PROPOSAL);
    ACLMessage messaggio = myAgent.receive(template);
    System.out.println(myAgent+" esegue ConfermaSceltaCorsoBehaviour: messaggio "+messaggio+"\n");

    //Se il messaggio non  vuoto viene processato
    if(messaggio != null)
    {
      String nomeCorso = messaggio.getContent();
      ACLMessage risposta = messaggio.createReply();
      //Controllo che il codice del corso scelto dallo studente sia corretto
      if(((AgenteCorso)myAgent).getNome().equals(nomeCorso))
      {
        risposta.setPerformative(ACLMessage.INFORM);
        System.out.println(myAgent+" esegue ConfermaSceltaCorsoBehaviour: "+nomeCorso+" assegnato all'agente "+
                           messaggio.getSender().getName()+"\n");
        //PER SEMPLICITA' IL MESSAGGIO DI CONFERMA NON HA CONTENUTO
        //risposta.setContent("");
      }
      else
      {
          //Non c' disponibilit
          System.out.println(myAgent+" esegue ConfermaSceltaCorsoBehaviour: messaggio vuoto!\n");
          risposta.setPerformative(ACLMessage.FAILURE);
          risposta.setContent("Non disponibilit");
      }
      myAgent.send(risposta);
    }
    else
    {
        block();
    }

    //Distruzione agente
//  myAgent.doDelete();
  }
}
