package learningproject;

/**
 * <p>Title: ClasseMain</p>
 * <p>Description: Classe che inizializza il Jade runtime e mette in esecuzione
* gli agenti</p>
 * @author Zito Daniela Dora
 * @version 1.0
 */

import jade.core.Runtime;
import jade.core.Profile;
import jade.core.ProfileImpl;
import jade.wrapper.*;

public class ClasseMain
{
  public static void main(String[] args)
  {
    try
    {
      // Creazione JADE runtime
      Runtime rt = Runtime.instance();
      // Chiusura della JVM locale quando termina l'ultimo container
      rt.setCloseVM(true);
      // Controllo del flag '-container'
      if(args.length > 0)
      {
        if(args[0].equalsIgnoreCase("-container"))
        {
          // Creazione default profile
          Profile p = new ProfileImpl(false);
          //p.setParameter(Profile.MAIN, "false");

          // Creazione di un nuovo non-main container, connesso
          //al main container di default (i.e. su questo host, porta 1099)
          System.out.println("Creazione agent container ..."+p+"\n");
          AgentContainer container = rt.createAgentContainer(p);

/*
          // Creazione di un nuovo agente Persona
          //parametri:
          //nickname
          //classname
          //parametri di inizializzazione del nuovo agente
          Object[] argomentiPersona = new Object[3];
          argomentiPersona[0] = "Giovanni";
          argomentiPersona[1]= "Verdi";
          argomentiPersona[2]= "verdig@yahoo.it";

          AgentController agentePersona = container.createNewAgent
              ("AgentePersona","learningproject.AgentePersona",argomentiPersona);
        // Esecuzione agente Persona
          System.out.println("Esecuzione agente Persona...\n");
          agentePersona.start();
*/

          //Creazione di un nuovo agente Docente nello stesso container
          Object[] argomentiDocente = new Object[4];
          argomentiDocente[0] = "Giuseppe";
          argomentiDocente[1] = "Bianchi";
          argomentiDocente[2] = "GBianchi@libero.it";
          argomentiDocente[3] = "34576";

          AgentController agenteDocente = container.createNewAgent
              ("AgenteDocente", "learningproject.AgenteDocente", argomentiDocente);
          System.out.println("Esecuzione agente Docente...\n");
          agenteDocente.start();

/*
          // Creazione di un nuovo agente Studente
          //parametri:
          //nickname
          //classname
          //parametri di inizializzazione del nuovo agente
          Object[] argomentiStudente = new Object[5];
          argomentiStudente[0] = "Roberto";
          argomentiStudente[1]= "Del male";
          argomentiStudente[2]= "robedel@yahoo.it";
          argomentiStudente[3]= "20345";
          argomentiStudente[4]= "principiante";

          AgentController agenteStudente = container.createNewAgent
              ("AgenteStudente","learningproject.AgenteStudente",argomentiStudente);
          // Esecuzione agente Studente
          System.out.println("Esecuzione agente Studente...\n");
          agenteStudente.start();
*/

          // Creazione di un nuovo agente Studente
          //parametri:
          //nickname
          //classname
          //parametri di inizializzazione del nuovo agente
          Object[] argomentiStudente2 = new Object[5];
          argomentiStudente2[0] = "Felice";
          argomentiStudente2[1]= "De Felice";
          argomentiStudente2[2]= "felide@hotmail.com";
          argomentiStudente2[3]= "569087";
          argomentiStudente2[4]= "abile";

          AgentController agenteStudente2 = container.createNewAgent
              ("AgenteStudente2","learningproject.AgenteStudente",argomentiStudente2);
          // Esecuzione agente Studente
          System.out.println("Esecuzione agente Studente2...\n");
          agenteStudente2.start();

          // Creazione di un nuovo agente Corso
          //parametri di inizializzazione del nuovo agente
          Object[] argomentiCorso = new Object[3];
          argomentiCorso[0] = "Reti di Calcolatori";
          argomentiCorso[1]= "345";
          argomentiCorso[2]= "abile";

          AgentController agenteCorso = container.createNewAgent
              ("AgenteCorso","learningproject.AgenteCorso",argomentiCorso);
          // Esecuzione agente Corso
          System.out.println("Esecuzione agente Corso...\n");
          agenteCorso.start();

/*
         // Distruzione agente Persona
         System.out.println("Killing agente Persona...");
         agentePersona.kill();
*/
/*
         // Distruzione agente Studente
         System.out.println("Killing agente Studente...");
         agenteStudente.kill();
*/
/*
        // Distruzione agente Docente
        System.out.println("Killing agente Docente...");
        agenteDocente.kill();
*/
/*
        // Distruzione agente Corso
        System.out.println("Killing agente Corso...");
        agenteCorso.kill();
*/

        return;
       }
      }
     // Lancia una piattaforma completa sulla porta 8888
     // creazione default Profile
     Profile pMain = new ProfileImpl(null, 8888, null);

     System.out.println("Launching a whole in-process platform..."+pMain);
     AgentContainer mc = rt.createMainContainer(pMain);

     // Setting del default Profile per creare un container
     ProfileImpl pContainer = new ProfileImpl(null, 8888, null);
     System.out.println("Launching the agent container ..."+pContainer);
     AgentContainer cont = rt.createAgentContainer(pContainer);
     System.out.println("Launching the agent container after ..."+pContainer);

     System.out.println("Launching the rma agent on the main container ...");
     AgentController rma = mc.createNewAgent("rma", "jade.tools.rma.rma", new Object[0]);
     rma.start();

     // Lancia un agente Studente
     Object[] argomentiStudente = new Object[5];
     argomentiStudente[0] = "Giovanni";
     argomentiStudente[1]= "Verdi";
     argomentiStudente[2]= "verdig@yahoo.it";
     argomentiStudente[3]= ""+171628;
     argomentiStudente[4]= "principiante";

     AgentController agenteStudente = mc.createNewAgent
         ("Studente","learningproject.Studente",argomentiStudente);
     // Esecuzione agente Studente
     System.out.println("Esecuzione agente Studente...");
     agenteStudente.start();
   }
   catch(Exception e) {e.printStackTrace();}
  }
}



