package learningproject;

/**
 * <p>Title: AgenteStudente</p>
 * <p>Description: Agente che rappresenta l'agente studente e che eredita
 * dall'agente persona. Pu svolgere diverse funzioni tra cui
 * visualizzare il proprio profilo,
* inviare i propri dati personali ai docenti,
* definire il proprio piano di studi scegliendo i corsi da seguire,
 *  seguire le letture;
 *  ricercare i quiz da eseguire e inviare le risposte al docente;
 *  conoscere il proprio profilo accademico;
 * @author Zito Daniela Dora
 * @version 1.0
 */
import jade.core.*;
import java.util.*;

public class AgenteStudente extends AgentePersona
{
  //Attributi
  private String matricola;
  private Vector elencoCorsiSeguiti;
  private String learningStylePreferito;
  private String livelloAbilita;
  private Vector interessiPersonali;

  public AID[] corsiTrovati = null;

  //Metodi per l'accesso agli attributi
  public void setMatricola(String matricola)
  {
    this.matricola = matricola;
  }
  //Inserimento di un corso nell'elenco
  public void insertCorso (CorsoSeguito nuovoCorso)
  {
  //  if(!elencoCorsiSeguiti.contains(nuovoCorso))
  elencoCorsiSeguiti.add(nuovoCorso);
  }
  //Eliminazione di un corso dall'elenco
  public void deleteCorso (CorsoSeguito vecchioCorso)
  {
    elencoCorsiSeguiti.remove(vecchioCorso);
  }
  public void setLearningStylePreferito(String learningStylePreferito)
  {
    this.learningStylePreferito = learningStylePreferito;
  }
  //Inserimento di un nuovo interesse
  public void insertInteresse(String nuovoInteresse)
  {
    if(!interessiPersonali.contains(nuovoInteresse))
      interessiPersonali.add(nuovoInteresse);
  }
   //Eliminazione di un interesse
   public void deleteInteresse (String vecchioInteresse)
   {
     interessiPersonali.remove(vecchioInteresse);
   }
   public String getMatricola()
   {
     return matricola;
   }
   public Vector getElencoCorsiSeguiti()
   {
     return elencoCorsiSeguiti;
   }
   public String getLearningStylePreferito()
   {
     return learningStylePreferito;
   }
   public String getLivelloAbilita()
   {
     return livelloAbilita;
   }
   public Vector getInteressiPersonali()
   {
     return interessiPersonali;
   }

   //Metodi per convertire lo studente in stringa
   public String studenteToStringNomeCognome()
   {
     String studente_stringa = super.personaToStringNomeCognome();
     studente_stringa += "Matricola: " + matricola + "\n";
     return studente_stringa;
   }
   public String studenteToStringNomeCognomeEmail()
   {
     String studente_stringa = super.personaToStringNomeCognomeEmail();
     studente_stringa += "Matricola: " + matricola + "\n";
     return studente_stringa;
   }
   public String studenteToStringNomeCognomeEmailAbilita()
   {
     String studente_stringa = super.personaToStringNomeCognomeEmail();
     studente_stringa += "Matricola: " + matricola + "\n";
     studente_stringa += "Livello abilit: " + livelloAbilita + "\n";
     return studente_stringa;
   }
   public String studenteToStringCompleta()
   {
     String studente_stringa = super.personaToStringCompleta();
     studente_stringa += "Matricola: " + matricola + "\n";
     studente_stringa += "Learning Style Preferito: " + learningStylePreferito + "\n";
     studente_stringa += "Elenco Corsi Seguiti: " +"\n";
     for(int i=0; i<elencoCorsiSeguiti.size(); i++)
     {
       studente_stringa += elencoCorsiSeguiti.elementAt(i).toString() + "\n";
     }
     for(int i=0; i<interessiPersonali.size(); i++)
     {
       studente_stringa += interessiPersonali.elementAt(i).toString() + "\n";
     }
     studente_stringa += "Livello di abilit conseguito: "+livelloAbilita +"\n";
     return studente_stringa;
   }


   //Inizializzazione agente
   protected void setup()
   {
     //Recupero gli argomenti
     //PER SEMPLICITA' USO SOLO ALCUNI PARAMETRI
     Object[] args = getArguments();
     if(args != null && args.length >0)
     {
       super.setNome((String)args[0]);
       super.setCognome((String)args[1]);
       super.setEMail((String)args[2]);
       this.matricola = (String)args[3];
       this.livelloAbilita = (String)args[4];
     }
     System.out.println(getAID().getName()+ ": pronto per l'esecuzione!\n");

     //Visualizzazione profilo studente
     addBehaviour(new VisualizzaDatiStudenteBehaviour(this));

     //Invio dei dati personali a tutti i docenti
     //NON IMPLEMENTATO
//   addBehaviour(new InviaACLDatiStudenteBehaviour(this));

     //Selezione corso
     addBehaviour(new InviaRiceviPreferenzeCorsoBehaviour(this));

     //Seguire le letture
     //NON IMPLEMENTATO
//   addBehaviour(new EseguiLettureBehaviour(this));

     //Ricerca quiz con un certo livello di difficolta, esecuzione,
     //invio dei risultati al docente e ricezione risposta
//   addBehaviour(new SelezioneEsecuzioneQuizBehaviour(this));
   }

   protected void takeDown()
   {
     System.out.println("AgenteStudente "+getAID().getName()+" in terminazione");
   }
}
